#[doc = "Register `INTCTRL0` reader"]
pub struct R(crate::R<INTCTRL0_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<INTCTRL0_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<INTCTRL0_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<INTCTRL0_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `INTCTRL0` writer"]
pub struct W(crate::W<INTCTRL0_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<INTCTRL0_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<INTCTRL0_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<INTCTRL0_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Interrupt Mode for LUT0\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum INTMODE0_A {
    #[doc = "0: Interrupt disabled"]
    INTDISABLE = 0,
    #[doc = "1: Sense rising edge"]
    RISING = 1,
    #[doc = "2: Sense falling edge"]
    FALLING = 2,
    #[doc = "3: Sense both edges"]
    BOTH = 3,
}
impl From<INTMODE0_A> for u8 {
    #[inline(always)]
    fn from(variant: INTMODE0_A) -> Self {
        variant as _
    }
}
#[doc = "Field `INTMODE0` reader - Interrupt Mode for LUT0"]
pub struct INTMODE0_R(crate::FieldReader<u8, INTMODE0_A>);
impl INTMODE0_R {
    pub(crate) fn new(bits: u8) -> Self {
        INTMODE0_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> INTMODE0_A {
        match self.bits {
            0 => INTMODE0_A::INTDISABLE,
            1 => INTMODE0_A::RISING,
            2 => INTMODE0_A::FALLING,
            3 => INTMODE0_A::BOTH,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `INTDISABLE`"]
    #[inline(always)]
    pub fn is_intdisable(&self) -> bool {
        **self == INTMODE0_A::INTDISABLE
    }
    #[doc = "Checks if the value of the field is `RISING`"]
    #[inline(always)]
    pub fn is_rising(&self) -> bool {
        **self == INTMODE0_A::RISING
    }
    #[doc = "Checks if the value of the field is `FALLING`"]
    #[inline(always)]
    pub fn is_falling(&self) -> bool {
        **self == INTMODE0_A::FALLING
    }
    #[doc = "Checks if the value of the field is `BOTH`"]
    #[inline(always)]
    pub fn is_both(&self) -> bool {
        **self == INTMODE0_A::BOTH
    }
}
impl core::ops::Deref for INTMODE0_R {
    type Target = crate::FieldReader<u8, INTMODE0_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `INTMODE0` writer - Interrupt Mode for LUT0"]
pub struct INTMODE0_W<'a> {
    w: &'a mut W,
}
impl<'a> INTMODE0_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: INTMODE0_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "Interrupt disabled"]
    #[inline(always)]
    pub fn intdisable(self) -> &'a mut W {
        self.variant(INTMODE0_A::INTDISABLE)
    }
    #[doc = "Sense rising edge"]
    #[inline(always)]
    pub fn rising(self) -> &'a mut W {
        self.variant(INTMODE0_A::RISING)
    }
    #[doc = "Sense falling edge"]
    #[inline(always)]
    pub fn falling(self) -> &'a mut W {
        self.variant(INTMODE0_A::FALLING)
    }
    #[doc = "Sense both edges"]
    #[inline(always)]
    pub fn both(self) -> &'a mut W {
        self.variant(INTMODE0_A::BOTH)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x03) | (value as u8 & 0x03);
        self.w
    }
}
#[doc = "Interrupt Mode for LUT1\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum INTMODE1_A {
    #[doc = "0: Interrupt disabled"]
    INTDISABLE = 0,
    #[doc = "1: Sense rising edge"]
    RISING = 1,
    #[doc = "2: Sense falling edge"]
    FALLING = 2,
    #[doc = "3: Sense both edges"]
    BOTH = 3,
}
impl From<INTMODE1_A> for u8 {
    #[inline(always)]
    fn from(variant: INTMODE1_A) -> Self {
        variant as _
    }
}
#[doc = "Field `INTMODE1` reader - Interrupt Mode for LUT1"]
pub struct INTMODE1_R(crate::FieldReader<u8, INTMODE1_A>);
impl INTMODE1_R {
    pub(crate) fn new(bits: u8) -> Self {
        INTMODE1_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> INTMODE1_A {
        match self.bits {
            0 => INTMODE1_A::INTDISABLE,
            1 => INTMODE1_A::RISING,
            2 => INTMODE1_A::FALLING,
            3 => INTMODE1_A::BOTH,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `INTDISABLE`"]
    #[inline(always)]
    pub fn is_intdisable(&self) -> bool {
        **self == INTMODE1_A::INTDISABLE
    }
    #[doc = "Checks if the value of the field is `RISING`"]
    #[inline(always)]
    pub fn is_rising(&self) -> bool {
        **self == INTMODE1_A::RISING
    }
    #[doc = "Checks if the value of the field is `FALLING`"]
    #[inline(always)]
    pub fn is_falling(&self) -> bool {
        **self == INTMODE1_A::FALLING
    }
    #[doc = "Checks if the value of the field is `BOTH`"]
    #[inline(always)]
    pub fn is_both(&self) -> bool {
        **self == INTMODE1_A::BOTH
    }
}
impl core::ops::Deref for INTMODE1_R {
    type Target = crate::FieldReader<u8, INTMODE1_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `INTMODE1` writer - Interrupt Mode for LUT1"]
pub struct INTMODE1_W<'a> {
    w: &'a mut W,
}
impl<'a> INTMODE1_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: INTMODE1_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "Interrupt disabled"]
    #[inline(always)]
    pub fn intdisable(self) -> &'a mut W {
        self.variant(INTMODE1_A::INTDISABLE)
    }
    #[doc = "Sense rising edge"]
    #[inline(always)]
    pub fn rising(self) -> &'a mut W {
        self.variant(INTMODE1_A::RISING)
    }
    #[doc = "Sense falling edge"]
    #[inline(always)]
    pub fn falling(self) -> &'a mut W {
        self.variant(INTMODE1_A::FALLING)
    }
    #[doc = "Sense both edges"]
    #[inline(always)]
    pub fn both(self) -> &'a mut W {
        self.variant(INTMODE1_A::BOTH)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 2)) | ((value as u8 & 0x03) << 2);
        self.w
    }
}
#[doc = "Interrupt Mode for LUT2\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum INTMODE2_A {
    #[doc = "0: Interrupt disabled"]
    INTDISABLE = 0,
    #[doc = "1: Sense rising edge"]
    RISING = 1,
    #[doc = "2: Sense falling edge"]
    FALLING = 2,
    #[doc = "3: Sense both edges"]
    BOTH = 3,
}
impl From<INTMODE2_A> for u8 {
    #[inline(always)]
    fn from(variant: INTMODE2_A) -> Self {
        variant as _
    }
}
#[doc = "Field `INTMODE2` reader - Interrupt Mode for LUT2"]
pub struct INTMODE2_R(crate::FieldReader<u8, INTMODE2_A>);
impl INTMODE2_R {
    pub(crate) fn new(bits: u8) -> Self {
        INTMODE2_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> INTMODE2_A {
        match self.bits {
            0 => INTMODE2_A::INTDISABLE,
            1 => INTMODE2_A::RISING,
            2 => INTMODE2_A::FALLING,
            3 => INTMODE2_A::BOTH,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `INTDISABLE`"]
    #[inline(always)]
    pub fn is_intdisable(&self) -> bool {
        **self == INTMODE2_A::INTDISABLE
    }
    #[doc = "Checks if the value of the field is `RISING`"]
    #[inline(always)]
    pub fn is_rising(&self) -> bool {
        **self == INTMODE2_A::RISING
    }
    #[doc = "Checks if the value of the field is `FALLING`"]
    #[inline(always)]
    pub fn is_falling(&self) -> bool {
        **self == INTMODE2_A::FALLING
    }
    #[doc = "Checks if the value of the field is `BOTH`"]
    #[inline(always)]
    pub fn is_both(&self) -> bool {
        **self == INTMODE2_A::BOTH
    }
}
impl core::ops::Deref for INTMODE2_R {
    type Target = crate::FieldReader<u8, INTMODE2_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `INTMODE2` writer - Interrupt Mode for LUT2"]
pub struct INTMODE2_W<'a> {
    w: &'a mut W,
}
impl<'a> INTMODE2_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: INTMODE2_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "Interrupt disabled"]
    #[inline(always)]
    pub fn intdisable(self) -> &'a mut W {
        self.variant(INTMODE2_A::INTDISABLE)
    }
    #[doc = "Sense rising edge"]
    #[inline(always)]
    pub fn rising(self) -> &'a mut W {
        self.variant(INTMODE2_A::RISING)
    }
    #[doc = "Sense falling edge"]
    #[inline(always)]
    pub fn falling(self) -> &'a mut W {
        self.variant(INTMODE2_A::FALLING)
    }
    #[doc = "Sense both edges"]
    #[inline(always)]
    pub fn both(self) -> &'a mut W {
        self.variant(INTMODE2_A::BOTH)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 4)) | ((value as u8 & 0x03) << 4);
        self.w
    }
}
#[doc = "Interrupt Mode for LUT3\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum INTMODE3_A {
    #[doc = "0: Interrupt disabled"]
    INTDISABLE = 0,
    #[doc = "1: Sense rising edge"]
    RISING = 1,
    #[doc = "2: Sense falling edge"]
    FALLING = 2,
    #[doc = "3: Sense both edges"]
    BOTH = 3,
}
impl From<INTMODE3_A> for u8 {
    #[inline(always)]
    fn from(variant: INTMODE3_A) -> Self {
        variant as _
    }
}
#[doc = "Field `INTMODE3` reader - Interrupt Mode for LUT3"]
pub struct INTMODE3_R(crate::FieldReader<u8, INTMODE3_A>);
impl INTMODE3_R {
    pub(crate) fn new(bits: u8) -> Self {
        INTMODE3_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> INTMODE3_A {
        match self.bits {
            0 => INTMODE3_A::INTDISABLE,
            1 => INTMODE3_A::RISING,
            2 => INTMODE3_A::FALLING,
            3 => INTMODE3_A::BOTH,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `INTDISABLE`"]
    #[inline(always)]
    pub fn is_intdisable(&self) -> bool {
        **self == INTMODE3_A::INTDISABLE
    }
    #[doc = "Checks if the value of the field is `RISING`"]
    #[inline(always)]
    pub fn is_rising(&self) -> bool {
        **self == INTMODE3_A::RISING
    }
    #[doc = "Checks if the value of the field is `FALLING`"]
    #[inline(always)]
    pub fn is_falling(&self) -> bool {
        **self == INTMODE3_A::FALLING
    }
    #[doc = "Checks if the value of the field is `BOTH`"]
    #[inline(always)]
    pub fn is_both(&self) -> bool {
        **self == INTMODE3_A::BOTH
    }
}
impl core::ops::Deref for INTMODE3_R {
    type Target = crate::FieldReader<u8, INTMODE3_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `INTMODE3` writer - Interrupt Mode for LUT3"]
pub struct INTMODE3_W<'a> {
    w: &'a mut W,
}
impl<'a> INTMODE3_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: INTMODE3_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "Interrupt disabled"]
    #[inline(always)]
    pub fn intdisable(self) -> &'a mut W {
        self.variant(INTMODE3_A::INTDISABLE)
    }
    #[doc = "Sense rising edge"]
    #[inline(always)]
    pub fn rising(self) -> &'a mut W {
        self.variant(INTMODE3_A::RISING)
    }
    #[doc = "Sense falling edge"]
    #[inline(always)]
    pub fn falling(self) -> &'a mut W {
        self.variant(INTMODE3_A::FALLING)
    }
    #[doc = "Sense both edges"]
    #[inline(always)]
    pub fn both(self) -> &'a mut W {
        self.variant(INTMODE3_A::BOTH)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 6)) | ((value as u8 & 0x03) << 6);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:1 - Interrupt Mode for LUT0"]
    #[inline(always)]
    pub fn intmode0(&self) -> INTMODE0_R {
        INTMODE0_R::new((self.bits & 0x03) as u8)
    }
    #[doc = "Bits 2:3 - Interrupt Mode for LUT1"]
    #[inline(always)]
    pub fn intmode1(&self) -> INTMODE1_R {
        INTMODE1_R::new(((self.bits >> 2) & 0x03) as u8)
    }
    #[doc = "Bits 4:5 - Interrupt Mode for LUT2"]
    #[inline(always)]
    pub fn intmode2(&self) -> INTMODE2_R {
        INTMODE2_R::new(((self.bits >> 4) & 0x03) as u8)
    }
    #[doc = "Bits 6:7 - Interrupt Mode for LUT3"]
    #[inline(always)]
    pub fn intmode3(&self) -> INTMODE3_R {
        INTMODE3_R::new(((self.bits >> 6) & 0x03) as u8)
    }
}
impl W {
    #[doc = "Bits 0:1 - Interrupt Mode for LUT0"]
    #[inline(always)]
    pub fn intmode0(&mut self) -> INTMODE0_W {
        INTMODE0_W { w: self }
    }
    #[doc = "Bits 2:3 - Interrupt Mode for LUT1"]
    #[inline(always)]
    pub fn intmode1(&mut self) -> INTMODE1_W {
        INTMODE1_W { w: self }
    }
    #[doc = "Bits 4:5 - Interrupt Mode for LUT2"]
    #[inline(always)]
    pub fn intmode2(&mut self) -> INTMODE2_W {
        INTMODE2_W { w: self }
    }
    #[doc = "Bits 6:7 - Interrupt Mode for LUT3"]
    #[inline(always)]
    pub fn intmode3(&mut self) -> INTMODE3_W {
        INTMODE3_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Interrupt Control 0\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [intctrl0](index.html) module"]
pub struct INTCTRL0_SPEC;
impl crate::RegisterSpec for INTCTRL0_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [intctrl0::R](R) reader structure"]
impl crate::Readable for INTCTRL0_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [intctrl0::W](W) writer structure"]
impl crate::Writable for INTCTRL0_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets INTCTRL0 to value 0"]
impl crate::Resettable for INTCTRL0_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
