#[doc = "Register `VLMCTRLA` reader"]
pub struct R(crate::R<VLMCTRLA_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<VLMCTRLA_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<VLMCTRLA_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<VLMCTRLA_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `VLMCTRLA` writer"]
pub struct W(crate::W<VLMCTRLA_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<VLMCTRLA_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<VLMCTRLA_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<VLMCTRLA_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "voltage level monitor level\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum VLMLVL_A {
    #[doc = "0: VLM threshold 5% above BOD level"]
    _5ABOVE = 0,
    #[doc = "1: VLM threshold 15% above BOD level"]
    _15ABOVE = 1,
    #[doc = "2: VLM threshold 25% above BOD level"]
    _25ABOVE = 2,
}
impl From<VLMLVL_A> for u8 {
    #[inline(always)]
    fn from(variant: VLMLVL_A) -> Self {
        variant as _
    }
}
#[doc = "Field `VLMLVL` reader - voltage level monitor level"]
pub struct VLMLVL_R(crate::FieldReader<u8, VLMLVL_A>);
impl VLMLVL_R {
    pub(crate) fn new(bits: u8) -> Self {
        VLMLVL_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> Option<VLMLVL_A> {
        match self.bits {
            0 => Some(VLMLVL_A::_5ABOVE),
            1 => Some(VLMLVL_A::_15ABOVE),
            2 => Some(VLMLVL_A::_25ABOVE),
            _ => None,
        }
    }
    #[doc = "Checks if the value of the field is `_5ABOVE`"]
    #[inline(always)]
    pub fn is_5above(&self) -> bool {
        **self == VLMLVL_A::_5ABOVE
    }
    #[doc = "Checks if the value of the field is `_15ABOVE`"]
    #[inline(always)]
    pub fn is_15above(&self) -> bool {
        **self == VLMLVL_A::_15ABOVE
    }
    #[doc = "Checks if the value of the field is `_25ABOVE`"]
    #[inline(always)]
    pub fn is_25above(&self) -> bool {
        **self == VLMLVL_A::_25ABOVE
    }
}
impl core::ops::Deref for VLMLVL_R {
    type Target = crate::FieldReader<u8, VLMLVL_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `VLMLVL` writer - voltage level monitor level"]
pub struct VLMLVL_W<'a> {
    w: &'a mut W,
}
impl<'a> VLMLVL_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: VLMLVL_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "VLM threshold 5% above BOD level"]
    #[inline(always)]
    pub fn _5above(self) -> &'a mut W {
        self.variant(VLMLVL_A::_5ABOVE)
    }
    #[doc = "VLM threshold 15% above BOD level"]
    #[inline(always)]
    pub fn _15above(self) -> &'a mut W {
        self.variant(VLMLVL_A::_15ABOVE)
    }
    #[doc = "VLM threshold 25% above BOD level"]
    #[inline(always)]
    pub fn _25above(self) -> &'a mut W {
        self.variant(VLMLVL_A::_25ABOVE)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x03) | (value as u8 & 0x03);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:1 - voltage level monitor level"]
    #[inline(always)]
    pub fn vlmlvl(&self) -> VLMLVL_R {
        VLMLVL_R::new((self.bits & 0x03) as u8)
    }
}
impl W {
    #[doc = "Bits 0:1 - voltage level monitor level"]
    #[inline(always)]
    pub fn vlmlvl(&mut self) -> VLMLVL_W {
        VLMLVL_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Voltage level monitor Control\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [vlmctrla](index.html) module"]
pub struct VLMCTRLA_SPEC;
impl crate::RegisterSpec for VLMCTRLA_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [vlmctrla::R](R) reader structure"]
impl crate::Readable for VLMCTRLA_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [vlmctrla::W](W) writer structure"]
impl crate::Writable for VLMCTRLA_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets VLMCTRLA to value 0"]
impl crate::Resettable for VLMCTRLA_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
