#[doc = "Register `TIMSK4` reader"]
pub struct R(crate::R<TIMSK4_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<TIMSK4_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<TIMSK4_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<TIMSK4_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `TIMSK4` writer"]
pub struct W(crate::W<TIMSK4_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<TIMSK4_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<TIMSK4_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<TIMSK4_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `TOIE4` reader - Timer/Counter4 Overflow Interrupt Enable"]
pub struct TOIE4_R(crate::FieldReader<bool, bool>);
impl TOIE4_R {
    pub(crate) fn new(bits: bool) -> Self {
        TOIE4_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TOIE4_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TOIE4` writer - Timer/Counter4 Overflow Interrupt Enable"]
pub struct TOIE4_W<'a> {
    w: &'a mut W,
}
impl<'a> TOIE4_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `OCIE4B` reader - Timer/Counter4 Output Compare B Match Interrupt Enable"]
pub struct OCIE4B_R(crate::FieldReader<bool, bool>);
impl OCIE4B_R {
    pub(crate) fn new(bits: bool) -> Self {
        OCIE4B_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for OCIE4B_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `OCIE4B` writer - Timer/Counter4 Output Compare B Match Interrupt Enable"]
pub struct OCIE4B_W<'a> {
    w: &'a mut W,
}
impl<'a> OCIE4B_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `OCIE4A` reader - Timer/Counter4 Output Compare A Match Interrupt Enable"]
pub struct OCIE4A_R(crate::FieldReader<bool, bool>);
impl OCIE4A_R {
    pub(crate) fn new(bits: bool) -> Self {
        OCIE4A_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for OCIE4A_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `OCIE4A` writer - Timer/Counter4 Output Compare A Match Interrupt Enable"]
pub struct OCIE4A_W<'a> {
    w: &'a mut W,
}
impl<'a> OCIE4A_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `OCIE4D` reader - Timer/Counter4 Output Compare D Match Interrupt Enable"]
pub struct OCIE4D_R(crate::FieldReader<bool, bool>);
impl OCIE4D_R {
    pub(crate) fn new(bits: bool) -> Self {
        OCIE4D_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for OCIE4D_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `OCIE4D` writer - Timer/Counter4 Output Compare D Match Interrupt Enable"]
pub struct OCIE4D_W<'a> {
    w: &'a mut W,
}
impl<'a> OCIE4D_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bit 2 - Timer/Counter4 Overflow Interrupt Enable"]
    #[inline(always)]
    pub fn toie4(&self) -> TOIE4_R {
        TOIE4_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Timer/Counter4 Output Compare B Match Interrupt Enable"]
    #[inline(always)]
    pub fn ocie4b(&self) -> OCIE4B_R {
        OCIE4B_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Timer/Counter4 Output Compare A Match Interrupt Enable"]
    #[inline(always)]
    pub fn ocie4a(&self) -> OCIE4A_R {
        OCIE4A_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Timer/Counter4 Output Compare D Match Interrupt Enable"]
    #[inline(always)]
    pub fn ocie4d(&self) -> OCIE4D_R {
        OCIE4D_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 2 - Timer/Counter4 Overflow Interrupt Enable"]
    #[inline(always)]
    pub fn toie4(&mut self) -> TOIE4_W {
        TOIE4_W { w: self }
    }
    #[doc = "Bit 5 - Timer/Counter4 Output Compare B Match Interrupt Enable"]
    #[inline(always)]
    pub fn ocie4b(&mut self) -> OCIE4B_W {
        OCIE4B_W { w: self }
    }
    #[doc = "Bit 6 - Timer/Counter4 Output Compare A Match Interrupt Enable"]
    #[inline(always)]
    pub fn ocie4a(&mut self) -> OCIE4A_W {
        OCIE4A_W { w: self }
    }
    #[doc = "Bit 7 - Timer/Counter4 Output Compare D Match Interrupt Enable"]
    #[inline(always)]
    pub fn ocie4d(&mut self) -> OCIE4D_W {
        OCIE4D_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Timer/Counter4 Interrupt Mask Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [timsk4](index.html) module"]
pub struct TIMSK4_SPEC;
impl crate::RegisterSpec for TIMSK4_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [timsk4::R](R) reader structure"]
impl crate::Readable for TIMSK4_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [timsk4::W](W) writer structure"]
impl crate::Writable for TIMSK4_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets TIMSK4 to value 0"]
impl crate::Resettable for TIMSK4_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
