#[doc = "Register `TCCR4A` reader"]
pub struct R(crate::R<TCCR4A_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<TCCR4A_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<TCCR4A_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<TCCR4A_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `TCCR4A` writer"]
pub struct W(crate::W<TCCR4A_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<TCCR4A_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<TCCR4A_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<TCCR4A_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `PWM4B` reader - No Description."]
pub struct PWM4B_R(crate::FieldReader<bool, bool>);
impl PWM4B_R {
    pub(crate) fn new(bits: bool) -> Self {
        PWM4B_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PWM4B_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PWM4B` writer - No Description."]
pub struct PWM4B_W<'a> {
    w: &'a mut W,
}
impl<'a> PWM4B_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `PWM4A` reader - No Description."]
pub struct PWM4A_R(crate::FieldReader<bool, bool>);
impl PWM4A_R {
    pub(crate) fn new(bits: bool) -> Self {
        PWM4A_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PWM4A_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PWM4A` writer - No Description."]
pub struct PWM4A_W<'a> {
    w: &'a mut W,
}
impl<'a> PWM4A_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `FOC4B` writer - Force Output Compare Match 4B"]
pub struct FOC4B_W<'a> {
    w: &'a mut W,
}
impl<'a> FOC4B_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `FOC4A` writer - Force Output Compare Match 4A"]
pub struct FOC4A_W<'a> {
    w: &'a mut W,
}
impl<'a> FOC4A_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Compare Output Mode 4B, bits\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum COM4B_A {
    #[doc = "0: Normal port operation, OCix disconnected"]
    DISCONNECTED = 0,
    #[doc = "1: Toggle OCix on Compare Match (Might depend on WGM)"]
    MATCH_TOGGLE = 1,
    #[doc = "2: Clear OCix on Compare Match (If PWM is enabled, OCix is set at TOP)"]
    MATCH_CLEAR = 2,
    #[doc = "3: Set OCix on Compare Match (If PWM is enabled, OCix is cleared at TOP)"]
    MATCH_SET = 3,
}
impl From<COM4B_A> for u8 {
    #[inline(always)]
    fn from(variant: COM4B_A) -> Self {
        variant as _
    }
}
#[doc = "Field `COM4B` reader - Compare Output Mode 4B, bits"]
pub struct COM4B_R(crate::FieldReader<u8, COM4B_A>);
impl COM4B_R {
    pub(crate) fn new(bits: u8) -> Self {
        COM4B_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> COM4B_A {
        match self.bits {
            0 => COM4B_A::DISCONNECTED,
            1 => COM4B_A::MATCH_TOGGLE,
            2 => COM4B_A::MATCH_CLEAR,
            3 => COM4B_A::MATCH_SET,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `DISCONNECTED`"]
    #[inline(always)]
    pub fn is_disconnected(&self) -> bool {
        **self == COM4B_A::DISCONNECTED
    }
    #[doc = "Checks if the value of the field is `MATCH_TOGGLE`"]
    #[inline(always)]
    pub fn is_match_toggle(&self) -> bool {
        **self == COM4B_A::MATCH_TOGGLE
    }
    #[doc = "Checks if the value of the field is `MATCH_CLEAR`"]
    #[inline(always)]
    pub fn is_match_clear(&self) -> bool {
        **self == COM4B_A::MATCH_CLEAR
    }
    #[doc = "Checks if the value of the field is `MATCH_SET`"]
    #[inline(always)]
    pub fn is_match_set(&self) -> bool {
        **self == COM4B_A::MATCH_SET
    }
}
impl core::ops::Deref for COM4B_R {
    type Target = crate::FieldReader<u8, COM4B_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `COM4B` writer - Compare Output Mode 4B, bits"]
pub struct COM4B_W<'a> {
    w: &'a mut W,
}
impl<'a> COM4B_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: COM4B_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "Normal port operation, OCix disconnected"]
    #[inline(always)]
    pub fn disconnected(self) -> &'a mut W {
        self.variant(COM4B_A::DISCONNECTED)
    }
    #[doc = "Toggle OCix on Compare Match (Might depend on WGM)"]
    #[inline(always)]
    pub fn match_toggle(self) -> &'a mut W {
        self.variant(COM4B_A::MATCH_TOGGLE)
    }
    #[doc = "Clear OCix on Compare Match (If PWM is enabled, OCix is set at TOP)"]
    #[inline(always)]
    pub fn match_clear(self) -> &'a mut W {
        self.variant(COM4B_A::MATCH_CLEAR)
    }
    #[doc = "Set OCix on Compare Match (If PWM is enabled, OCix is cleared at TOP)"]
    #[inline(always)]
    pub fn match_set(self) -> &'a mut W {
        self.variant(COM4B_A::MATCH_SET)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 4)) | ((value as u8 & 0x03) << 4);
        self.w
    }
}
#[doc = "Compare Output Mode 1A, bits"]
pub type COM4A_A = COM4B_A;
#[doc = "Field `COM4A` reader - Compare Output Mode 1A, bits"]
pub type COM4A_R = COM4B_R;
#[doc = "Field `COM4A` writer - Compare Output Mode 1A, bits"]
pub struct COM4A_W<'a> {
    w: &'a mut W,
}
impl<'a> COM4A_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: COM4A_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "Normal port operation, OCix disconnected"]
    #[inline(always)]
    pub fn disconnected(self) -> &'a mut W {
        self.variant(COM4A_A::DISCONNECTED)
    }
    #[doc = "Toggle OCix on Compare Match (Might depend on WGM)"]
    #[inline(always)]
    pub fn match_toggle(self) -> &'a mut W {
        self.variant(COM4A_A::MATCH_TOGGLE)
    }
    #[doc = "Clear OCix on Compare Match (If PWM is enabled, OCix is set at TOP)"]
    #[inline(always)]
    pub fn match_clear(self) -> &'a mut W {
        self.variant(COM4A_A::MATCH_CLEAR)
    }
    #[doc = "Set OCix on Compare Match (If PWM is enabled, OCix is cleared at TOP)"]
    #[inline(always)]
    pub fn match_set(self) -> &'a mut W {
        self.variant(COM4A_A::MATCH_SET)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 6)) | ((value as u8 & 0x03) << 6);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - No Description."]
    #[inline(always)]
    pub fn pwm4b(&self) -> PWM4B_R {
        PWM4B_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - No Description."]
    #[inline(always)]
    pub fn pwm4a(&self) -> PWM4A_R {
        PWM4A_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bits 4:5 - Compare Output Mode 4B, bits"]
    #[inline(always)]
    pub fn com4b(&self) -> COM4B_R {
        COM4B_R::new(((self.bits >> 4) & 0x03) as u8)
    }
    #[doc = "Bits 6:7 - Compare Output Mode 1A, bits"]
    #[inline(always)]
    pub fn com4a(&self) -> COM4A_R {
        COM4A_R::new(((self.bits >> 6) & 0x03) as u8)
    }
}
impl W {
    #[doc = "Bit 0 - No Description."]
    #[inline(always)]
    pub fn pwm4b(&mut self) -> PWM4B_W {
        PWM4B_W { w: self }
    }
    #[doc = "Bit 1 - No Description."]
    #[inline(always)]
    pub fn pwm4a(&mut self) -> PWM4A_W {
        PWM4A_W { w: self }
    }
    #[doc = "Bit 2 - Force Output Compare Match 4B"]
    #[inline(always)]
    pub fn foc4b(&mut self) -> FOC4B_W {
        FOC4B_W { w: self }
    }
    #[doc = "Bit 3 - Force Output Compare Match 4A"]
    #[inline(always)]
    pub fn foc4a(&mut self) -> FOC4A_W {
        FOC4A_W { w: self }
    }
    #[doc = "Bits 4:5 - Compare Output Mode 4B, bits"]
    #[inline(always)]
    pub fn com4b(&mut self) -> COM4B_W {
        COM4B_W { w: self }
    }
    #[doc = "Bits 6:7 - Compare Output Mode 1A, bits"]
    #[inline(always)]
    pub fn com4a(&mut self) -> COM4A_W {
        COM4A_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Timer/Counter4 Control Register A\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [tccr4a](index.html) module"]
pub struct TCCR4A_SPEC;
impl crate::RegisterSpec for TCCR4A_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [tccr4a::R](R) reader structure"]
impl crate::Readable for TCCR4A_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [tccr4a::W](W) writer structure"]
impl crate::Writable for TCCR4A_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets TCCR4A to value 0"]
impl crate::Resettable for TCCR4A_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
