#[doc = "Register `DT4` reader"]
pub struct R(crate::R<DT4_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<DT4_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<DT4_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<DT4_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `DT4` writer"]
pub struct W(crate::W<DT4_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<DT4_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<DT4_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<DT4_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `DT4L` reader - Timer/Counter 4 Dead Time Value Bits"]
pub struct DT4L_R(crate::FieldReader<u8, u8>);
impl DT4L_R {
    pub(crate) fn new(bits: u8) -> Self {
        DT4L_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DT4L_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DT4L` writer - Timer/Counter 4 Dead Time Value Bits"]
pub struct DT4L_W<'a> {
    w: &'a mut W,
}
impl<'a> DT4L_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0xff) | (value as u8 & 0xff);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:7 - Timer/Counter 4 Dead Time Value Bits"]
    #[inline(always)]
    pub fn dt4l(&self) -> DT4L_R {
        DT4L_R::new((self.bits & 0xff) as u8)
    }
}
impl W {
    #[doc = "Bits 0:7 - Timer/Counter 4 Dead Time Value Bits"]
    #[inline(always)]
    pub fn dt4l(&mut self) -> DT4L_W {
        DT4L_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Timer/Counter 4 Dead Time Value\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [dt4](index.html) module"]
pub struct DT4_SPEC;
impl crate::RegisterSpec for DT4_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [dt4::R](R) reader structure"]
impl crate::Readable for DT4_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [dt4::W](W) writer structure"]
impl crate::Writable for DT4_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets DT4 to value 0"]
impl crate::Resettable for DT4_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
