#[doc = "Register `PORTC` reader"]
pub struct R(crate::R<PORTC_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<PORTC_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<PORTC_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<PORTC_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `PORTC` writer"]
pub struct W(crate::W<PORTC_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<PORTC_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<PORTC_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<PORTC_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `PC6` reader - Pin C6"]
pub struct PC6_R(crate::FieldReader<bool, bool>);
impl PC6_R {
    pub(crate) fn new(bits: bool) -> Self {
        PC6_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PC6_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PC6` writer - Pin C6"]
pub struct PC6_W<'a> {
    w: &'a mut W,
}
impl<'a> PC6_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `PC7` reader - Pin C7"]
pub struct PC7_R(crate::FieldReader<bool, bool>);
impl PC7_R {
    pub(crate) fn new(bits: bool) -> Self {
        PC7_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PC7_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PC7` writer - Pin C7"]
pub struct PC7_W<'a> {
    w: &'a mut W,
}
impl<'a> PC7_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bit 6 - Pin C6"]
    #[inline(always)]
    pub fn pc6(&self) -> PC6_R {
        PC6_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Pin C7"]
    #[inline(always)]
    pub fn pc7(&self) -> PC7_R {
        PC7_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 6 - Pin C6"]
    #[inline(always)]
    pub fn pc6(&mut self) -> PC6_W {
        PC6_W { w: self }
    }
    #[doc = "Bit 7 - Pin C7"]
    #[inline(always)]
    pub fn pc7(&mut self) -> PC7_W {
        PC7_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Port C Data Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [portc](index.html) module"]
pub struct PORTC_SPEC;
impl crate::RegisterSpec for PORTC_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [portc::R](R) reader structure"]
impl crate::Readable for PORTC_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [portc::W](W) writer structure"]
impl crate::Writable for PORTC_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets PORTC to value 0"]
impl crate::Resettable for PORTC_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
