#[doc = "Register `PLLFRQ` reader"]
pub struct R(crate::R<PLLFRQ_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<PLLFRQ_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<PLLFRQ_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<PLLFRQ_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `PLLFRQ` writer"]
pub struct W(crate::W<PLLFRQ_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<PLLFRQ_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<PLLFRQ_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<PLLFRQ_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "PLL Lock Frequency\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum PDIV_A {
    #[doc = "3: 40 MHz"]
    MHZ40 = 3,
    #[doc = "4: 48 MHz"]
    MHZ48 = 4,
    #[doc = "5: 56 MHz"]
    MHZ56 = 5,
    #[doc = "7: 72 MHz"]
    MHZ72 = 7,
    #[doc = "8: 80 MHz"]
    MHZ80 = 8,
    #[doc = "9: 88 MHz"]
    MHZ88 = 9,
    #[doc = "10: 96 MHz"]
    MHZ96 = 10,
}
impl From<PDIV_A> for u8 {
    #[inline(always)]
    fn from(variant: PDIV_A) -> Self {
        variant as _
    }
}
#[doc = "Field `PDIV` reader - PLL Lock Frequency"]
pub struct PDIV_R(crate::FieldReader<u8, PDIV_A>);
impl PDIV_R {
    pub(crate) fn new(bits: u8) -> Self {
        PDIV_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> Option<PDIV_A> {
        match self.bits {
            3 => Some(PDIV_A::MHZ40),
            4 => Some(PDIV_A::MHZ48),
            5 => Some(PDIV_A::MHZ56),
            7 => Some(PDIV_A::MHZ72),
            8 => Some(PDIV_A::MHZ80),
            9 => Some(PDIV_A::MHZ88),
            10 => Some(PDIV_A::MHZ96),
            _ => None,
        }
    }
    #[doc = "Checks if the value of the field is `MHZ40`"]
    #[inline(always)]
    pub fn is_mhz40(&self) -> bool {
        **self == PDIV_A::MHZ40
    }
    #[doc = "Checks if the value of the field is `MHZ48`"]
    #[inline(always)]
    pub fn is_mhz48(&self) -> bool {
        **self == PDIV_A::MHZ48
    }
    #[doc = "Checks if the value of the field is `MHZ56`"]
    #[inline(always)]
    pub fn is_mhz56(&self) -> bool {
        **self == PDIV_A::MHZ56
    }
    #[doc = "Checks if the value of the field is `MHZ72`"]
    #[inline(always)]
    pub fn is_mhz72(&self) -> bool {
        **self == PDIV_A::MHZ72
    }
    #[doc = "Checks if the value of the field is `MHZ80`"]
    #[inline(always)]
    pub fn is_mhz80(&self) -> bool {
        **self == PDIV_A::MHZ80
    }
    #[doc = "Checks if the value of the field is `MHZ88`"]
    #[inline(always)]
    pub fn is_mhz88(&self) -> bool {
        **self == PDIV_A::MHZ88
    }
    #[doc = "Checks if the value of the field is `MHZ96`"]
    #[inline(always)]
    pub fn is_mhz96(&self) -> bool {
        **self == PDIV_A::MHZ96
    }
}
impl core::ops::Deref for PDIV_R {
    type Target = crate::FieldReader<u8, PDIV_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PDIV` writer - PLL Lock Frequency"]
pub struct PDIV_W<'a> {
    w: &'a mut W,
}
impl<'a> PDIV_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: PDIV_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "40 MHz"]
    #[inline(always)]
    pub fn mhz40(self) -> &'a mut W {
        self.variant(PDIV_A::MHZ40)
    }
    #[doc = "48 MHz"]
    #[inline(always)]
    pub fn mhz48(self) -> &'a mut W {
        self.variant(PDIV_A::MHZ48)
    }
    #[doc = "56 MHz"]
    #[inline(always)]
    pub fn mhz56(self) -> &'a mut W {
        self.variant(PDIV_A::MHZ56)
    }
    #[doc = "72 MHz"]
    #[inline(always)]
    pub fn mhz72(self) -> &'a mut W {
        self.variant(PDIV_A::MHZ72)
    }
    #[doc = "80 MHz"]
    #[inline(always)]
    pub fn mhz80(self) -> &'a mut W {
        self.variant(PDIV_A::MHZ80)
    }
    #[doc = "88 MHz"]
    #[inline(always)]
    pub fn mhz88(self) -> &'a mut W {
        self.variant(PDIV_A::MHZ88)
    }
    #[doc = "96 MHz"]
    #[inline(always)]
    pub fn mhz96(self) -> &'a mut W {
        self.variant(PDIV_A::MHZ96)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x0f) | (value as u8 & 0x0f);
        self.w
    }
}
#[doc = "PLL Postscaler for High Speed Timer\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum PLLTM_A {
    #[doc = "0: 0 (Disconnected)"]
    DISCONNECTED = 0,
    #[doc = "1: 1"]
    FACTOR_1 = 1,
    #[doc = "2: 1.5"]
    FACTOR_15 = 2,
    #[doc = "3: 2"]
    FACTOR_2 = 3,
}
impl From<PLLTM_A> for u8 {
    #[inline(always)]
    fn from(variant: PLLTM_A) -> Self {
        variant as _
    }
}
#[doc = "Field `PLLTM` reader - PLL Postscaler for High Speed Timer"]
pub struct PLLTM_R(crate::FieldReader<u8, PLLTM_A>);
impl PLLTM_R {
    pub(crate) fn new(bits: u8) -> Self {
        PLLTM_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> PLLTM_A {
        match self.bits {
            0 => PLLTM_A::DISCONNECTED,
            1 => PLLTM_A::FACTOR_1,
            2 => PLLTM_A::FACTOR_15,
            3 => PLLTM_A::FACTOR_2,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `DISCONNECTED`"]
    #[inline(always)]
    pub fn is_disconnected(&self) -> bool {
        **self == PLLTM_A::DISCONNECTED
    }
    #[doc = "Checks if the value of the field is `FACTOR_1`"]
    #[inline(always)]
    pub fn is_factor_1(&self) -> bool {
        **self == PLLTM_A::FACTOR_1
    }
    #[doc = "Checks if the value of the field is `FACTOR_15`"]
    #[inline(always)]
    pub fn is_factor_15(&self) -> bool {
        **self == PLLTM_A::FACTOR_15
    }
    #[doc = "Checks if the value of the field is `FACTOR_2`"]
    #[inline(always)]
    pub fn is_factor_2(&self) -> bool {
        **self == PLLTM_A::FACTOR_2
    }
}
impl core::ops::Deref for PLLTM_R {
    type Target = crate::FieldReader<u8, PLLTM_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PLLTM` writer - PLL Postscaler for High Speed Timer"]
pub struct PLLTM_W<'a> {
    w: &'a mut W,
}
impl<'a> PLLTM_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: PLLTM_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "0 (Disconnected)"]
    #[inline(always)]
    pub fn disconnected(self) -> &'a mut W {
        self.variant(PLLTM_A::DISCONNECTED)
    }
    #[doc = "1"]
    #[inline(always)]
    pub fn factor_1(self) -> &'a mut W {
        self.variant(PLLTM_A::FACTOR_1)
    }
    #[doc = "1.5"]
    #[inline(always)]
    pub fn factor_15(self) -> &'a mut W {
        self.variant(PLLTM_A::FACTOR_15)
    }
    #[doc = "2"]
    #[inline(always)]
    pub fn factor_2(self) -> &'a mut W {
        self.variant(PLLTM_A::FACTOR_2)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 4)) | ((value as u8 & 0x03) << 4);
        self.w
    }
}
#[doc = "Field `PLLUSB` reader - PLL Postscaler for USB Peripheral"]
pub struct PLLUSB_R(crate::FieldReader<bool, bool>);
impl PLLUSB_R {
    pub(crate) fn new(bits: bool) -> Self {
        PLLUSB_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PLLUSB_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PLLUSB` writer - PLL Postscaler for USB Peripheral"]
pub struct PLLUSB_W<'a> {
    w: &'a mut W,
}
impl<'a> PLLUSB_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `PINMUX` reader - PLL Input Multiplexer"]
pub struct PINMUX_R(crate::FieldReader<bool, bool>);
impl PINMUX_R {
    pub(crate) fn new(bits: bool) -> Self {
        PINMUX_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PINMUX_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PINMUX` writer - PLL Input Multiplexer"]
pub struct PINMUX_W<'a> {
    w: &'a mut W,
}
impl<'a> PINMUX_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:3 - PLL Lock Frequency"]
    #[inline(always)]
    pub fn pdiv(&self) -> PDIV_R {
        PDIV_R::new((self.bits & 0x0f) as u8)
    }
    #[doc = "Bits 4:5 - PLL Postscaler for High Speed Timer"]
    #[inline(always)]
    pub fn plltm(&self) -> PLLTM_R {
        PLLTM_R::new(((self.bits >> 4) & 0x03) as u8)
    }
    #[doc = "Bit 6 - PLL Postscaler for USB Peripheral"]
    #[inline(always)]
    pub fn pllusb(&self) -> PLLUSB_R {
        PLLUSB_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - PLL Input Multiplexer"]
    #[inline(always)]
    pub fn pinmux(&self) -> PINMUX_R {
        PINMUX_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:3 - PLL Lock Frequency"]
    #[inline(always)]
    pub fn pdiv(&mut self) -> PDIV_W {
        PDIV_W { w: self }
    }
    #[doc = "Bits 4:5 - PLL Postscaler for High Speed Timer"]
    #[inline(always)]
    pub fn plltm(&mut self) -> PLLTM_W {
        PLLTM_W { w: self }
    }
    #[doc = "Bit 6 - PLL Postscaler for USB Peripheral"]
    #[inline(always)]
    pub fn pllusb(&mut self) -> PLLUSB_W {
        PLLUSB_W { w: self }
    }
    #[doc = "Bit 7 - PLL Input Multiplexer"]
    #[inline(always)]
    pub fn pinmux(&mut self) -> PINMUX_W {
        PINMUX_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "PLL Frequency Control Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [pllfrq](index.html) module"]
pub struct PLLFRQ_SPEC;
impl crate::RegisterSpec for PLLFRQ_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [pllfrq::R](R) reader structure"]
impl crate::Readable for PLLFRQ_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [pllfrq::W](W) writer structure"]
impl crate::Writable for PLLFRQ_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets PLLFRQ to value 0"]
impl crate::Resettable for PLLFRQ_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
