#[doc = "Register `PLLCSR` reader"]
pub struct R(crate::R<PLLCSR_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<PLLCSR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<PLLCSR_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<PLLCSR_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `PLLCSR` writer"]
pub struct W(crate::W<PLLCSR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<PLLCSR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<PLLCSR_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<PLLCSR_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `PLOCK` reader - PLL Lock Status Bit"]
pub struct PLOCK_R(crate::FieldReader<bool, bool>);
impl PLOCK_R {
    pub(crate) fn new(bits: bool) -> Self {
        PLOCK_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PLOCK_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PLLE` reader - PLL Enable Bit"]
pub struct PLLE_R(crate::FieldReader<bool, bool>);
impl PLLE_R {
    pub(crate) fn new(bits: bool) -> Self {
        PLLE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PLLE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PLLE` writer - PLL Enable Bit"]
pub struct PLLE_W<'a> {
    w: &'a mut W,
}
impl<'a> PLLE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `PINDIV` reader - PLL prescaler Bit 2"]
pub struct PINDIV_R(crate::FieldReader<bool, bool>);
impl PINDIV_R {
    pub(crate) fn new(bits: bool) -> Self {
        PINDIV_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PINDIV_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PINDIV` writer - PLL prescaler Bit 2"]
pub struct PINDIV_W<'a> {
    w: &'a mut W,
}
impl<'a> PINDIV_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - PLL Lock Status Bit"]
    #[inline(always)]
    pub fn plock(&self) -> PLOCK_R {
        PLOCK_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - PLL Enable Bit"]
    #[inline(always)]
    pub fn plle(&self) -> PLLE_R {
        PLLE_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 4 - PLL prescaler Bit 2"]
    #[inline(always)]
    pub fn pindiv(&self) -> PINDIV_R {
        PINDIV_R::new(((self.bits >> 4) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 1 - PLL Enable Bit"]
    #[inline(always)]
    pub fn plle(&mut self) -> PLLE_W {
        PLLE_W { w: self }
    }
    #[doc = "Bit 4 - PLL prescaler Bit 2"]
    #[inline(always)]
    pub fn pindiv(&mut self) -> PINDIV_W {
        PINDIV_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "PLL Status and Control register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [pllcsr](index.html) module"]
pub struct PLLCSR_SPEC;
impl crate::RegisterSpec for PLLCSR_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [pllcsr::R](R) reader structure"]
impl crate::Readable for PLLCSR_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [pllcsr::W](W) writer structure"]
impl crate::Writable for PLLCSR_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets PLLCSR to value 0"]
impl crate::Resettable for PLLCSR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
