#[doc = "Register `HIGH` reader"]
pub struct R(crate::R<HIGH_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<HIGH_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<HIGH_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<HIGH_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `HIGH` writer"]
pub struct W(crate::W<HIGH_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<HIGH_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<HIGH_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<HIGH_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `BOOTRST` reader - Boot Reset vector Enabled"]
pub struct BOOTRST_R(crate::FieldReader<bool, bool>);
impl BOOTRST_R {
    pub(crate) fn new(bits: bool) -> Self {
        BOOTRST_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for BOOTRST_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `BOOTRST` writer - Boot Reset vector Enabled"]
pub struct BOOTRST_W<'a> {
    w: &'a mut W,
}
impl<'a> BOOTRST_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Select Boot Size\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum BOOTSZ_A {
    #[doc = "0: Boot Flash size=2048 words start address=$3800"]
    _2048W_3800 = 0,
    #[doc = "1: Boot Flash size=1024 words start address=$3C00"]
    _1024W_3C00 = 1,
    #[doc = "2: Boot Flash size=512 words start address=$3E00"]
    _512W_3E00 = 2,
    #[doc = "3: Boot Flash size=256 words start address=$3F00"]
    _256W_3F00 = 3,
}
impl From<BOOTSZ_A> for u8 {
    #[inline(always)]
    fn from(variant: BOOTSZ_A) -> Self {
        variant as _
    }
}
#[doc = "Field `BOOTSZ` reader - Select Boot Size"]
pub struct BOOTSZ_R(crate::FieldReader<u8, BOOTSZ_A>);
impl BOOTSZ_R {
    pub(crate) fn new(bits: u8) -> Self {
        BOOTSZ_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> BOOTSZ_A {
        match self.bits {
            0 => BOOTSZ_A::_2048W_3800,
            1 => BOOTSZ_A::_1024W_3C00,
            2 => BOOTSZ_A::_512W_3E00,
            3 => BOOTSZ_A::_256W_3F00,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `_2048W_3800`"]
    #[inline(always)]
    pub fn is_2048w_3800(&self) -> bool {
        **self == BOOTSZ_A::_2048W_3800
    }
    #[doc = "Checks if the value of the field is `_1024W_3C00`"]
    #[inline(always)]
    pub fn is_1024w_3c00(&self) -> bool {
        **self == BOOTSZ_A::_1024W_3C00
    }
    #[doc = "Checks if the value of the field is `_512W_3E00`"]
    #[inline(always)]
    pub fn is_512w_3e00(&self) -> bool {
        **self == BOOTSZ_A::_512W_3E00
    }
    #[doc = "Checks if the value of the field is `_256W_3F00`"]
    #[inline(always)]
    pub fn is_256w_3f00(&self) -> bool {
        **self == BOOTSZ_A::_256W_3F00
    }
}
impl core::ops::Deref for BOOTSZ_R {
    type Target = crate::FieldReader<u8, BOOTSZ_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `BOOTSZ` writer - Select Boot Size"]
pub struct BOOTSZ_W<'a> {
    w: &'a mut W,
}
impl<'a> BOOTSZ_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: BOOTSZ_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "Boot Flash size=2048 words start address=$3800"]
    #[inline(always)]
    pub fn _2048w_3800(self) -> &'a mut W {
        self.variant(BOOTSZ_A::_2048W_3800)
    }
    #[doc = "Boot Flash size=1024 words start address=$3C00"]
    #[inline(always)]
    pub fn _1024w_3c00(self) -> &'a mut W {
        self.variant(BOOTSZ_A::_1024W_3C00)
    }
    #[doc = "Boot Flash size=512 words start address=$3E00"]
    #[inline(always)]
    pub fn _512w_3e00(self) -> &'a mut W {
        self.variant(BOOTSZ_A::_512W_3E00)
    }
    #[doc = "Boot Flash size=256 words start address=$3F00"]
    #[inline(always)]
    pub fn _256w_3f00(self) -> &'a mut W {
        self.variant(BOOTSZ_A::_256W_3F00)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 1)) | ((value as u8 & 0x03) << 1);
        self.w
    }
}
#[doc = "Field `EESAVE` reader - Preserve EEPROM through the Chip Erase cycle"]
pub struct EESAVE_R(crate::FieldReader<bool, bool>);
impl EESAVE_R {
    pub(crate) fn new(bits: bool) -> Self {
        EESAVE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for EESAVE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `EESAVE` writer - Preserve EEPROM through the Chip Erase cycle"]
pub struct EESAVE_W<'a> {
    w: &'a mut W,
}
impl<'a> EESAVE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `WDTON` reader - Watchdog timer always on"]
pub struct WDTON_R(crate::FieldReader<bool, bool>);
impl WDTON_R {
    pub(crate) fn new(bits: bool) -> Self {
        WDTON_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for WDTON_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `WDTON` writer - Watchdog timer always on"]
pub struct WDTON_W<'a> {
    w: &'a mut W,
}
impl<'a> WDTON_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `SPIEN` reader - Serial program downloading (SPI) enabled"]
pub struct SPIEN_R(crate::FieldReader<bool, bool>);
impl SPIEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        SPIEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPIEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SPIEN` writer - Serial program downloading (SPI) enabled"]
pub struct SPIEN_W<'a> {
    w: &'a mut W,
}
impl<'a> SPIEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `JTAGEN` reader - JTAG Interface Enabled"]
pub struct JTAGEN_R(crate::FieldReader<bool, bool>);
impl JTAGEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        JTAGEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for JTAGEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `JTAGEN` writer - JTAG Interface Enabled"]
pub struct JTAGEN_W<'a> {
    w: &'a mut W,
}
impl<'a> JTAGEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `OCDEN` reader - On-Chip Debug Enabled"]
pub struct OCDEN_R(crate::FieldReader<bool, bool>);
impl OCDEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        OCDEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for OCDEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `OCDEN` writer - On-Chip Debug Enabled"]
pub struct OCDEN_W<'a> {
    w: &'a mut W,
}
impl<'a> OCDEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Boot Reset vector Enabled"]
    #[inline(always)]
    pub fn bootrst(&self) -> BOOTRST_R {
        BOOTRST_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bits 1:2 - Select Boot Size"]
    #[inline(always)]
    pub fn bootsz(&self) -> BOOTSZ_R {
        BOOTSZ_R::new(((self.bits >> 1) & 0x03) as u8)
    }
    #[doc = "Bit 3 - Preserve EEPROM through the Chip Erase cycle"]
    #[inline(always)]
    pub fn eesave(&self) -> EESAVE_R {
        EESAVE_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Watchdog timer always on"]
    #[inline(always)]
    pub fn wdton(&self) -> WDTON_R {
        WDTON_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Serial program downloading (SPI) enabled"]
    #[inline(always)]
    pub fn spien(&self) -> SPIEN_R {
        SPIEN_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - JTAG Interface Enabled"]
    #[inline(always)]
    pub fn jtagen(&self) -> JTAGEN_R {
        JTAGEN_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - On-Chip Debug Enabled"]
    #[inline(always)]
    pub fn ocden(&self) -> OCDEN_R {
        OCDEN_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Boot Reset vector Enabled"]
    #[inline(always)]
    pub fn bootrst(&mut self) -> BOOTRST_W {
        BOOTRST_W { w: self }
    }
    #[doc = "Bits 1:2 - Select Boot Size"]
    #[inline(always)]
    pub fn bootsz(&mut self) -> BOOTSZ_W {
        BOOTSZ_W { w: self }
    }
    #[doc = "Bit 3 - Preserve EEPROM through the Chip Erase cycle"]
    #[inline(always)]
    pub fn eesave(&mut self) -> EESAVE_W {
        EESAVE_W { w: self }
    }
    #[doc = "Bit 4 - Watchdog timer always on"]
    #[inline(always)]
    pub fn wdton(&mut self) -> WDTON_W {
        WDTON_W { w: self }
    }
    #[doc = "Bit 5 - Serial program downloading (SPI) enabled"]
    #[inline(always)]
    pub fn spien(&mut self) -> SPIEN_W {
        SPIEN_W { w: self }
    }
    #[doc = "Bit 6 - JTAG Interface Enabled"]
    #[inline(always)]
    pub fn jtagen(&mut self) -> JTAGEN_W {
        JTAGEN_W { w: self }
    }
    #[doc = "Bit 7 - On-Chip Debug Enabled"]
    #[inline(always)]
    pub fn ocden(&mut self) -> OCDEN_W {
        OCDEN_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "No Description.\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [high](index.html) module"]
pub struct HIGH_SPEC;
impl crate::RegisterSpec for HIGH_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [high::R](R) reader structure"]
impl crate::Readable for HIGH_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [high::W](W) writer structure"]
impl crate::Writable for HIGH_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets HIGH to value 0"]
impl crate::Resettable for HIGH_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
