#[doc = "Register `ADCSRB` reader"]
pub struct R(crate::R<ADCSRB_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<ADCSRB_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<ADCSRB_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<ADCSRB_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `ADCSRB` writer"]
pub struct W(crate::W<ADCSRB_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<ADCSRB_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<ADCSRB_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<ADCSRB_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "ADC Auto Trigger Sources\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum ADTS_A {
    #[doc = "0: Free Running mode"]
    VAL_0X00 = 0,
    #[doc = "1: Analog Comparator"]
    VAL_0X01 = 1,
    #[doc = "2: External Interrupt Request 0"]
    VAL_0X02 = 2,
    #[doc = "3: Timer/Counter0 Compare Match A"]
    VAL_0X03 = 3,
    #[doc = "4: Timer/Counter0 Overflow"]
    VAL_0X04 = 4,
    #[doc = "5: Timer/Counter1 Compare Match B"]
    VAL_0X05 = 5,
    #[doc = "6: Timer/Counter1 Overflow"]
    VAL_0X06 = 6,
    #[doc = "7: Timer/Counter1 Capture Event"]
    VAL_0X07 = 7,
}
impl From<ADTS_A> for u8 {
    #[inline(always)]
    fn from(variant: ADTS_A) -> Self {
        variant as _
    }
}
#[doc = "Field `ADTS` reader - ADC Auto Trigger Sources"]
pub struct ADTS_R(crate::FieldReader<u8, ADTS_A>);
impl ADTS_R {
    pub(crate) fn new(bits: u8) -> Self {
        ADTS_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> Option<ADTS_A> {
        match self.bits {
            0 => Some(ADTS_A::VAL_0X00),
            1 => Some(ADTS_A::VAL_0X01),
            2 => Some(ADTS_A::VAL_0X02),
            3 => Some(ADTS_A::VAL_0X03),
            4 => Some(ADTS_A::VAL_0X04),
            5 => Some(ADTS_A::VAL_0X05),
            6 => Some(ADTS_A::VAL_0X06),
            7 => Some(ADTS_A::VAL_0X07),
            _ => None,
        }
    }
    #[doc = "Checks if the value of the field is `VAL_0X00`"]
    #[inline(always)]
    pub fn is_val_0x00(&self) -> bool {
        **self == ADTS_A::VAL_0X00
    }
    #[doc = "Checks if the value of the field is `VAL_0X01`"]
    #[inline(always)]
    pub fn is_val_0x01(&self) -> bool {
        **self == ADTS_A::VAL_0X01
    }
    #[doc = "Checks if the value of the field is `VAL_0X02`"]
    #[inline(always)]
    pub fn is_val_0x02(&self) -> bool {
        **self == ADTS_A::VAL_0X02
    }
    #[doc = "Checks if the value of the field is `VAL_0X03`"]
    #[inline(always)]
    pub fn is_val_0x03(&self) -> bool {
        **self == ADTS_A::VAL_0X03
    }
    #[doc = "Checks if the value of the field is `VAL_0X04`"]
    #[inline(always)]
    pub fn is_val_0x04(&self) -> bool {
        **self == ADTS_A::VAL_0X04
    }
    #[doc = "Checks if the value of the field is `VAL_0X05`"]
    #[inline(always)]
    pub fn is_val_0x05(&self) -> bool {
        **self == ADTS_A::VAL_0X05
    }
    #[doc = "Checks if the value of the field is `VAL_0X06`"]
    #[inline(always)]
    pub fn is_val_0x06(&self) -> bool {
        **self == ADTS_A::VAL_0X06
    }
    #[doc = "Checks if the value of the field is `VAL_0X07`"]
    #[inline(always)]
    pub fn is_val_0x07(&self) -> bool {
        **self == ADTS_A::VAL_0X07
    }
}
impl core::ops::Deref for ADTS_R {
    type Target = crate::FieldReader<u8, ADTS_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ADTS` writer - ADC Auto Trigger Sources"]
pub struct ADTS_W<'a> {
    w: &'a mut W,
}
impl<'a> ADTS_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: ADTS_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "Free Running mode"]
    #[inline(always)]
    pub fn val_0x00(self) -> &'a mut W {
        self.variant(ADTS_A::VAL_0X00)
    }
    #[doc = "Analog Comparator"]
    #[inline(always)]
    pub fn val_0x01(self) -> &'a mut W {
        self.variant(ADTS_A::VAL_0X01)
    }
    #[doc = "External Interrupt Request 0"]
    #[inline(always)]
    pub fn val_0x02(self) -> &'a mut W {
        self.variant(ADTS_A::VAL_0X02)
    }
    #[doc = "Timer/Counter0 Compare Match A"]
    #[inline(always)]
    pub fn val_0x03(self) -> &'a mut W {
        self.variant(ADTS_A::VAL_0X03)
    }
    #[doc = "Timer/Counter0 Overflow"]
    #[inline(always)]
    pub fn val_0x04(self) -> &'a mut W {
        self.variant(ADTS_A::VAL_0X04)
    }
    #[doc = "Timer/Counter1 Compare Match B"]
    #[inline(always)]
    pub fn val_0x05(self) -> &'a mut W {
        self.variant(ADTS_A::VAL_0X05)
    }
    #[doc = "Timer/Counter1 Overflow"]
    #[inline(always)]
    pub fn val_0x06(self) -> &'a mut W {
        self.variant(ADTS_A::VAL_0X06)
    }
    #[doc = "Timer/Counter1 Capture Event"]
    #[inline(always)]
    pub fn val_0x07(self) -> &'a mut W {
        self.variant(ADTS_A::VAL_0X07)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x1f) | (value as u8 & 0x1f);
        self.w
    }
}
#[doc = "Field `MUX5` reader - Analog Channel and Gain Selection Bits"]
pub struct MUX5_R(crate::FieldReader<bool, bool>);
impl MUX5_R {
    pub(crate) fn new(bits: bool) -> Self {
        MUX5_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for MUX5_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `MUX5` writer - Analog Channel and Gain Selection Bits"]
pub struct MUX5_W<'a> {
    w: &'a mut W,
}
impl<'a> MUX5_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `ADHSM` reader - ADC High Speed Mode"]
pub struct ADHSM_R(crate::FieldReader<bool, bool>);
impl ADHSM_R {
    pub(crate) fn new(bits: bool) -> Self {
        ADHSM_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ADHSM_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ADHSM` writer - ADC High Speed Mode"]
pub struct ADHSM_W<'a> {
    w: &'a mut W,
}
impl<'a> ADHSM_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:4 - ADC Auto Trigger Sources"]
    #[inline(always)]
    pub fn adts(&self) -> ADTS_R {
        ADTS_R::new((self.bits & 0x1f) as u8)
    }
    #[doc = "Bit 5 - Analog Channel and Gain Selection Bits"]
    #[inline(always)]
    pub fn mux5(&self) -> MUX5_R {
        MUX5_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 7 - ADC High Speed Mode"]
    #[inline(always)]
    pub fn adhsm(&self) -> ADHSM_R {
        ADHSM_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:4 - ADC Auto Trigger Sources"]
    #[inline(always)]
    pub fn adts(&mut self) -> ADTS_W {
        ADTS_W { w: self }
    }
    #[doc = "Bit 5 - Analog Channel and Gain Selection Bits"]
    #[inline(always)]
    pub fn mux5(&mut self) -> MUX5_W {
        MUX5_W { w: self }
    }
    #[doc = "Bit 7 - ADC High Speed Mode"]
    #[inline(always)]
    pub fn adhsm(&mut self) -> ADHSM_W {
        ADHSM_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "ADC Control and Status Register B\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [adcsrb](index.html) module"]
pub struct ADCSRB_SPEC;
impl crate::RegisterSpec for ADCSRB_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [adcsrb::R](R) reader structure"]
impl crate::Readable for ADCSRB_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [adcsrb::W](W) writer structure"]
impl crate::Writable for ADCSRB_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets ADCSRB to value 0"]
impl crate::Resettable for ADCSRB_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
