#[doc = "Register `TIFR4` reader"]
pub struct R(crate::R<TIFR4_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<TIFR4_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<TIFR4_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<TIFR4_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `TIFR4` writer"]
pub struct W(crate::W<TIFR4_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<TIFR4_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<TIFR4_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<TIFR4_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `TOV4` reader - Timer/Counter4 Overflow Flag"]
pub struct TOV4_R(crate::FieldReader<bool, bool>);
impl TOV4_R {
    pub(crate) fn new(bits: bool) -> Self {
        TOV4_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TOV4_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TOV4` writer - Timer/Counter4 Overflow Flag"]
pub struct TOV4_W<'a> {
    w: &'a mut W,
}
impl<'a> TOV4_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `OCF4A` reader - Output Compare Flag 4A"]
pub struct OCF4A_R(crate::FieldReader<bool, bool>);
impl OCF4A_R {
    pub(crate) fn new(bits: bool) -> Self {
        OCF4A_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for OCF4A_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `OCF4A` writer - Output Compare Flag 4A"]
pub struct OCF4A_W<'a> {
    w: &'a mut W,
}
impl<'a> OCF4A_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `OCF4B` reader - Output Compare Flag 4B"]
pub struct OCF4B_R(crate::FieldReader<bool, bool>);
impl OCF4B_R {
    pub(crate) fn new(bits: bool) -> Self {
        OCF4B_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for OCF4B_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `OCF4B` writer - Output Compare Flag 4B"]
pub struct OCF4B_W<'a> {
    w: &'a mut W,
}
impl<'a> OCF4B_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `ICF4` reader - Timer/Counter4 Input Capture Flag"]
pub struct ICF4_R(crate::FieldReader<bool, bool>);
impl ICF4_R {
    pub(crate) fn new(bits: bool) -> Self {
        ICF4_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ICF4_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ICF4` writer - Timer/Counter4 Input Capture Flag"]
pub struct ICF4_W<'a> {
    w: &'a mut W,
}
impl<'a> ICF4_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Timer/Counter4 Overflow Flag"]
    #[inline(always)]
    pub fn tov4(&self) -> TOV4_R {
        TOV4_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Output Compare Flag 4A"]
    #[inline(always)]
    pub fn ocf4a(&self) -> OCF4A_R {
        OCF4A_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Output Compare Flag 4B"]
    #[inline(always)]
    pub fn ocf4b(&self) -> OCF4B_R {
        OCF4B_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Timer/Counter4 Input Capture Flag"]
    #[inline(always)]
    pub fn icf4(&self) -> ICF4_R {
        ICF4_R::new(((self.bits >> 5) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Timer/Counter4 Overflow Flag"]
    #[inline(always)]
    pub fn tov4(&mut self) -> TOV4_W {
        TOV4_W { w: self }
    }
    #[doc = "Bit 1 - Output Compare Flag 4A"]
    #[inline(always)]
    pub fn ocf4a(&mut self) -> OCF4A_W {
        OCF4A_W { w: self }
    }
    #[doc = "Bit 2 - Output Compare Flag 4B"]
    #[inline(always)]
    pub fn ocf4b(&mut self) -> OCF4B_W {
        OCF4B_W { w: self }
    }
    #[doc = "Bit 5 - Timer/Counter4 Input Capture Flag"]
    #[inline(always)]
    pub fn icf4(&mut self) -> ICF4_W {
        ICF4_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Timer/Counter4 Interrupt Flag register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [tifr4](index.html) module"]
pub struct TIFR4_SPEC;
impl crate::RegisterSpec for TIFR4_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [tifr4::R](R) reader structure"]
impl crate::Readable for TIFR4_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [tifr4::W](W) writer structure"]
impl crate::Writable for TIFR4_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets TIFR4 to value 0"]
impl crate::Resettable for TIFR4_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
