#[doc = "Register `PRR1` reader"]
pub struct R(crate::R<PRR1_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<PRR1_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<PRR1_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<PRR1_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `PRR1` writer"]
pub struct W(crate::W<PRR1_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<PRR1_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<PRR1_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<PRR1_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `PRTIM3` reader - Power Reduction Timer/Counter3"]
pub struct PRTIM3_R(crate::FieldReader<bool, bool>);
impl PRTIM3_R {
    pub(crate) fn new(bits: bool) -> Self {
        PRTIM3_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PRTIM3_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PRTIM3` writer - Power Reduction Timer/Counter3"]
pub struct PRTIM3_W<'a> {
    w: &'a mut W,
}
impl<'a> PRTIM3_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `PRSPI1` reader - Power Reduction Serial Peripheral Interface 1"]
pub struct PRSPI1_R(crate::FieldReader<bool, bool>);
impl PRSPI1_R {
    pub(crate) fn new(bits: bool) -> Self {
        PRSPI1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PRSPI1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PRSPI1` writer - Power Reduction Serial Peripheral Interface 1"]
pub struct PRSPI1_W<'a> {
    w: &'a mut W,
}
impl<'a> PRSPI1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `PRTIM4` reader - Power Reduction Timer/Counter4"]
pub struct PRTIM4_R(crate::FieldReader<bool, bool>);
impl PRTIM4_R {
    pub(crate) fn new(bits: bool) -> Self {
        PRTIM4_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PRTIM4_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PRTIM4` writer - Power Reduction Timer/Counter4"]
pub struct PRTIM4_W<'a> {
    w: &'a mut W,
}
impl<'a> PRTIM4_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `PRPTC` reader - Power Reduction Peripheral Touch Controller"]
pub struct PRPTC_R(crate::FieldReader<bool, bool>);
impl PRPTC_R {
    pub(crate) fn new(bits: bool) -> Self {
        PRPTC_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PRPTC_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PRPTC` writer - Power Reduction Peripheral Touch Controller"]
pub struct PRPTC_W<'a> {
    w: &'a mut W,
}
impl<'a> PRPTC_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `PRTWI1` reader - Power Reduction TWI1"]
pub struct PRTWI1_R(crate::FieldReader<bool, bool>);
impl PRTWI1_R {
    pub(crate) fn new(bits: bool) -> Self {
        PRTWI1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PRTWI1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PRTWI1` writer - Power Reduction TWI1"]
pub struct PRTWI1_W<'a> {
    w: &'a mut W,
}
impl<'a> PRTWI1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Power Reduction Timer/Counter3"]
    #[inline(always)]
    pub fn prtim3(&self) -> PRTIM3_R {
        PRTIM3_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 2 - Power Reduction Serial Peripheral Interface 1"]
    #[inline(always)]
    pub fn prspi1(&self) -> PRSPI1_R {
        PRSPI1_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Power Reduction Timer/Counter4"]
    #[inline(always)]
    pub fn prtim4(&self) -> PRTIM4_R {
        PRTIM4_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Power Reduction Peripheral Touch Controller"]
    #[inline(always)]
    pub fn prptc(&self) -> PRPTC_R {
        PRPTC_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Power Reduction TWI1"]
    #[inline(always)]
    pub fn prtwi1(&self) -> PRTWI1_R {
        PRTWI1_R::new(((self.bits >> 5) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Power Reduction Timer/Counter3"]
    #[inline(always)]
    pub fn prtim3(&mut self) -> PRTIM3_W {
        PRTIM3_W { w: self }
    }
    #[doc = "Bit 2 - Power Reduction Serial Peripheral Interface 1"]
    #[inline(always)]
    pub fn prspi1(&mut self) -> PRSPI1_W {
        PRSPI1_W { w: self }
    }
    #[doc = "Bit 3 - Power Reduction Timer/Counter4"]
    #[inline(always)]
    pub fn prtim4(&mut self) -> PRTIM4_W {
        PRTIM4_W { w: self }
    }
    #[doc = "Bit 4 - Power Reduction Peripheral Touch Controller"]
    #[inline(always)]
    pub fn prptc(&mut self) -> PRPTC_W {
        PRPTC_W { w: self }
    }
    #[doc = "Bit 5 - Power Reduction TWI1"]
    #[inline(always)]
    pub fn prtwi1(&mut self) -> PRTWI1_W {
        PRTWI1_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Power Reduction Register 1\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [prr1](index.html) module"]
pub struct PRR1_SPEC;
impl crate::RegisterSpec for PRR1_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [prr1::R](R) reader structure"]
impl crate::Readable for PRR1_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [prr1::W](W) writer structure"]
impl crate::Writable for PRR1_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets PRR1 to value 0"]
impl crate::Resettable for PRR1_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
