#[doc = "Register `XFDCSR` reader"]
pub struct R(crate::R<XFDCSR_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<XFDCSR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<XFDCSR_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<XFDCSR_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `XFDCSR` writer"]
pub struct W(crate::W<XFDCSR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<XFDCSR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<XFDCSR_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<XFDCSR_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `XFDIE` reader - Failure Detection Interrupt Enable"]
pub struct XFDIE_R(crate::FieldReader<bool, bool>);
impl XFDIE_R {
    pub(crate) fn new(bits: bool) -> Self {
        XFDIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for XFDIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `XFDIE` writer - Failure Detection Interrupt Enable"]
pub struct XFDIE_W<'a> {
    w: &'a mut W,
}
impl<'a> XFDIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `XFDIF` reader - Failure Detection Interrupt Flag"]
pub struct XFDIF_R(crate::FieldReader<bool, bool>);
impl XFDIF_R {
    pub(crate) fn new(bits: bool) -> Self {
        XFDIF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for XFDIF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `XFDIF` writer - Failure Detection Interrupt Flag"]
pub struct XFDIF_W<'a> {
    w: &'a mut W,
}
impl<'a> XFDIF_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Failure Detection Interrupt Enable"]
    #[inline(always)]
    pub fn xfdie(&self) -> XFDIE_R {
        XFDIE_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Failure Detection Interrupt Flag"]
    #[inline(always)]
    pub fn xfdif(&self) -> XFDIF_R {
        XFDIF_R::new(((self.bits >> 1) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Failure Detection Interrupt Enable"]
    #[inline(always)]
    pub fn xfdie(&mut self) -> XFDIE_W {
        XFDIE_W { w: self }
    }
    #[doc = "Bit 1 - Failure Detection Interrupt Flag"]
    #[inline(always)]
    pub fn xfdif(&mut self) -> XFDIF_W {
        XFDIF_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "XOSC Failure Detection Control and Status Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [xfdcsr](index.html) module"]
pub struct XFDCSR_SPEC;
impl crate::RegisterSpec for XFDCSR_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [xfdcsr::R](R) reader structure"]
impl crate::Readable for XFDCSR_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [xfdcsr::W](W) writer structure"]
impl crate::Writable for XFDCSR_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets XFDCSR to value 0"]
impl crate::Resettable for XFDCSR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
