#[doc = "Register `ACSRB` reader"]
pub struct R(crate::R<ACSRB_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<ACSRB_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<ACSRB_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<ACSRB_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `ACSRB` writer"]
pub struct W(crate::W<ACSRB_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<ACSRB_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<ACSRB_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<ACSRB_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `ACOE` reader - Analog Comparator Output Enable"]
pub struct ACOE_R(crate::FieldReader<bool, bool>);
impl ACOE_R {
    pub(crate) fn new(bits: bool) -> Self {
        ACOE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ACOE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ACOE` writer - Analog Comparator Output Enable"]
pub struct ACOE_W<'a> {
    w: &'a mut W,
}
impl<'a> ACOE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Analog Comparator Output Enable"]
    #[inline(always)]
    pub fn acoe(&self) -> ACOE_R {
        ACOE_R::new((self.bits & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Analog Comparator Output Enable"]
    #[inline(always)]
    pub fn acoe(&mut self) -> ACOE_W {
        ACOE_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Analog Comparator Control And Status Register-B\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [acsrb](index.html) module"]
pub struct ACSRB_SPEC;
impl crate::RegisterSpec for ACSRB_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [acsrb::R](R) reader structure"]
impl crate::Readable for ACSRB_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [acsrb::W](W) writer structure"]
impl crate::Writable for ACSRB_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets ACSRB to value 0"]
impl crate::Resettable for ACSRB_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
