#[doc = "Register `SPMCSR` reader"]
pub struct R(crate::R<SPMCSR_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<SPMCSR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<SPMCSR_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<SPMCSR_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `SPMCSR` writer"]
pub struct W(crate::W<SPMCSR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<SPMCSR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<SPMCSR_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<SPMCSR_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `SPMEN` reader - Store Program Memory"]
pub struct SPMEN_R(crate::FieldReader<bool, bool>);
impl SPMEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        SPMEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPMEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SPMEN` writer - Store Program Memory"]
pub struct SPMEN_W<'a> {
    w: &'a mut W,
}
impl<'a> SPMEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `PGERS` reader - Page Erase"]
pub struct PGERS_R(crate::FieldReader<bool, bool>);
impl PGERS_R {
    pub(crate) fn new(bits: bool) -> Self {
        PGERS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PGERS_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PGERS` writer - Page Erase"]
pub struct PGERS_W<'a> {
    w: &'a mut W,
}
impl<'a> PGERS_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `PGWRT` reader - Page Write"]
pub struct PGWRT_R(crate::FieldReader<bool, bool>);
impl PGWRT_R {
    pub(crate) fn new(bits: bool) -> Self {
        PGWRT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PGWRT_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PGWRT` writer - Page Write"]
pub struct PGWRT_W<'a> {
    w: &'a mut W,
}
impl<'a> PGWRT_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `BLBSET` reader - Boot Lock Bit Set"]
pub struct BLBSET_R(crate::FieldReader<bool, bool>);
impl BLBSET_R {
    pub(crate) fn new(bits: bool) -> Self {
        BLBSET_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for BLBSET_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `BLBSET` writer - Boot Lock Bit Set"]
pub struct BLBSET_W<'a> {
    w: &'a mut W,
}
impl<'a> BLBSET_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `RWWSRE` reader - Read-While-Write section read enable"]
pub struct RWWSRE_R(crate::FieldReader<bool, bool>);
impl RWWSRE_R {
    pub(crate) fn new(bits: bool) -> Self {
        RWWSRE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RWWSRE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RWWSRE` writer - Read-While-Write section read enable"]
pub struct RWWSRE_W<'a> {
    w: &'a mut W,
}
impl<'a> RWWSRE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `SIGRD` reader - Signature Row Read"]
pub struct SIGRD_R(crate::FieldReader<bool, bool>);
impl SIGRD_R {
    pub(crate) fn new(bits: bool) -> Self {
        SIGRD_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SIGRD_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SIGRD` writer - Signature Row Read"]
pub struct SIGRD_W<'a> {
    w: &'a mut W,
}
impl<'a> SIGRD_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `RWWSB` reader - Read-While-Write Section Busy"]
pub struct RWWSB_R(crate::FieldReader<bool, bool>);
impl RWWSB_R {
    pub(crate) fn new(bits: bool) -> Self {
        RWWSB_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RWWSB_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RWWSB` writer - Read-While-Write Section Busy"]
pub struct RWWSB_W<'a> {
    w: &'a mut W,
}
impl<'a> RWWSB_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `SPMIE` reader - SPM Interrupt Enable"]
pub struct SPMIE_R(crate::FieldReader<bool, bool>);
impl SPMIE_R {
    pub(crate) fn new(bits: bool) -> Self {
        SPMIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPMIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SPMIE` writer - SPM Interrupt Enable"]
pub struct SPMIE_W<'a> {
    w: &'a mut W,
}
impl<'a> SPMIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Store Program Memory"]
    #[inline(always)]
    pub fn spmen(&self) -> SPMEN_R {
        SPMEN_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Page Erase"]
    #[inline(always)]
    pub fn pgers(&self) -> PGERS_R {
        PGERS_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Page Write"]
    #[inline(always)]
    pub fn pgwrt(&self) -> PGWRT_R {
        PGWRT_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Boot Lock Bit Set"]
    #[inline(always)]
    pub fn blbset(&self) -> BLBSET_R {
        BLBSET_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Read-While-Write section read enable"]
    #[inline(always)]
    pub fn rwwsre(&self) -> RWWSRE_R {
        RWWSRE_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Signature Row Read"]
    #[inline(always)]
    pub fn sigrd(&self) -> SIGRD_R {
        SIGRD_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Read-While-Write Section Busy"]
    #[inline(always)]
    pub fn rwwsb(&self) -> RWWSB_R {
        RWWSB_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - SPM Interrupt Enable"]
    #[inline(always)]
    pub fn spmie(&self) -> SPMIE_R {
        SPMIE_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Store Program Memory"]
    #[inline(always)]
    pub fn spmen(&mut self) -> SPMEN_W {
        SPMEN_W { w: self }
    }
    #[doc = "Bit 1 - Page Erase"]
    #[inline(always)]
    pub fn pgers(&mut self) -> PGERS_W {
        PGERS_W { w: self }
    }
    #[doc = "Bit 2 - Page Write"]
    #[inline(always)]
    pub fn pgwrt(&mut self) -> PGWRT_W {
        PGWRT_W { w: self }
    }
    #[doc = "Bit 3 - Boot Lock Bit Set"]
    #[inline(always)]
    pub fn blbset(&mut self) -> BLBSET_W {
        BLBSET_W { w: self }
    }
    #[doc = "Bit 4 - Read-While-Write section read enable"]
    #[inline(always)]
    pub fn rwwsre(&mut self) -> RWWSRE_W {
        RWWSRE_W { w: self }
    }
    #[doc = "Bit 5 - Signature Row Read"]
    #[inline(always)]
    pub fn sigrd(&mut self) -> SIGRD_W {
        SIGRD_W { w: self }
    }
    #[doc = "Bit 6 - Read-While-Write Section Busy"]
    #[inline(always)]
    pub fn rwwsb(&mut self) -> RWWSB_W {
        RWWSB_W { w: self }
    }
    #[doc = "Bit 7 - SPM Interrupt Enable"]
    #[inline(always)]
    pub fn spmie(&mut self) -> SPMIE_W {
        SPMIE_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Store Program Memory Control and Status Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [spmcsr](index.html) module"]
pub struct SPMCSR_SPEC;
impl crate::RegisterSpec for SPMCSR_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [spmcsr::R](R) reader structure"]
impl crate::Readable for SPMCSR_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [spmcsr::W](W) writer structure"]
impl crate::Writable for SPMCSR_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets SPMCSR to value 0"]
impl crate::Resettable for SPMCSR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
