#[doc = "Register `UCSR3B` reader"]
pub struct R(crate::R<UCSR3B_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<UCSR3B_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<UCSR3B_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<UCSR3B_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `UCSR3B` writer"]
pub struct W(crate::W<UCSR3B_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<UCSR3B_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<UCSR3B_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<UCSR3B_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `TXB83` reader - Transmit Data Bit 8"]
pub struct TXB83_R(crate::FieldReader<bool, bool>);
impl TXB83_R {
    pub(crate) fn new(bits: bool) -> Self {
        TXB83_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TXB83_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TXB83` writer - Transmit Data Bit 8"]
pub struct TXB83_W<'a> {
    w: &'a mut W,
}
impl<'a> TXB83_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `RXB83` reader - Receive Data Bit 8"]
pub struct RXB83_R(crate::FieldReader<bool, bool>);
impl RXB83_R {
    pub(crate) fn new(bits: bool) -> Self {
        RXB83_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RXB83_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `UCSZ32` reader - Character Size"]
pub struct UCSZ32_R(crate::FieldReader<bool, bool>);
impl UCSZ32_R {
    pub(crate) fn new(bits: bool) -> Self {
        UCSZ32_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for UCSZ32_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `UCSZ32` writer - Character Size"]
pub struct UCSZ32_W<'a> {
    w: &'a mut W,
}
impl<'a> UCSZ32_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `TXEN3` reader - Transmitter Enable"]
pub struct TXEN3_R(crate::FieldReader<bool, bool>);
impl TXEN3_R {
    pub(crate) fn new(bits: bool) -> Self {
        TXEN3_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TXEN3_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TXEN3` writer - Transmitter Enable"]
pub struct TXEN3_W<'a> {
    w: &'a mut W,
}
impl<'a> TXEN3_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `RXEN3` reader - Receiver Enable"]
pub struct RXEN3_R(crate::FieldReader<bool, bool>);
impl RXEN3_R {
    pub(crate) fn new(bits: bool) -> Self {
        RXEN3_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RXEN3_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RXEN3` writer - Receiver Enable"]
pub struct RXEN3_W<'a> {
    w: &'a mut W,
}
impl<'a> RXEN3_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `UDRIE3` reader - USART Data register Empty Interrupt Enable"]
pub struct UDRIE3_R(crate::FieldReader<bool, bool>);
impl UDRIE3_R {
    pub(crate) fn new(bits: bool) -> Self {
        UDRIE3_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for UDRIE3_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `UDRIE3` writer - USART Data register Empty Interrupt Enable"]
pub struct UDRIE3_W<'a> {
    w: &'a mut W,
}
impl<'a> UDRIE3_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `TXCIE3` reader - TX Complete Interrupt Enable"]
pub struct TXCIE3_R(crate::FieldReader<bool, bool>);
impl TXCIE3_R {
    pub(crate) fn new(bits: bool) -> Self {
        TXCIE3_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TXCIE3_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TXCIE3` writer - TX Complete Interrupt Enable"]
pub struct TXCIE3_W<'a> {
    w: &'a mut W,
}
impl<'a> TXCIE3_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `RXCIE3` reader - RX Complete Interrupt Enable"]
pub struct RXCIE3_R(crate::FieldReader<bool, bool>);
impl RXCIE3_R {
    pub(crate) fn new(bits: bool) -> Self {
        RXCIE3_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RXCIE3_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RXCIE3` writer - RX Complete Interrupt Enable"]
pub struct RXCIE3_W<'a> {
    w: &'a mut W,
}
impl<'a> RXCIE3_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Transmit Data Bit 8"]
    #[inline(always)]
    pub fn txb83(&self) -> TXB83_R {
        TXB83_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Receive Data Bit 8"]
    #[inline(always)]
    pub fn rxb83(&self) -> RXB83_R {
        RXB83_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Character Size"]
    #[inline(always)]
    pub fn ucsz32(&self) -> UCSZ32_R {
        UCSZ32_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Transmitter Enable"]
    #[inline(always)]
    pub fn txen3(&self) -> TXEN3_R {
        TXEN3_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Receiver Enable"]
    #[inline(always)]
    pub fn rxen3(&self) -> RXEN3_R {
        RXEN3_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - USART Data register Empty Interrupt Enable"]
    #[inline(always)]
    pub fn udrie3(&self) -> UDRIE3_R {
        UDRIE3_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - TX Complete Interrupt Enable"]
    #[inline(always)]
    pub fn txcie3(&self) -> TXCIE3_R {
        TXCIE3_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - RX Complete Interrupt Enable"]
    #[inline(always)]
    pub fn rxcie3(&self) -> RXCIE3_R {
        RXCIE3_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Transmit Data Bit 8"]
    #[inline(always)]
    pub fn txb83(&mut self) -> TXB83_W {
        TXB83_W { w: self }
    }
    #[doc = "Bit 2 - Character Size"]
    #[inline(always)]
    pub fn ucsz32(&mut self) -> UCSZ32_W {
        UCSZ32_W { w: self }
    }
    #[doc = "Bit 3 - Transmitter Enable"]
    #[inline(always)]
    pub fn txen3(&mut self) -> TXEN3_W {
        TXEN3_W { w: self }
    }
    #[doc = "Bit 4 - Receiver Enable"]
    #[inline(always)]
    pub fn rxen3(&mut self) -> RXEN3_W {
        RXEN3_W { w: self }
    }
    #[doc = "Bit 5 - USART Data register Empty Interrupt Enable"]
    #[inline(always)]
    pub fn udrie3(&mut self) -> UDRIE3_W {
        UDRIE3_W { w: self }
    }
    #[doc = "Bit 6 - TX Complete Interrupt Enable"]
    #[inline(always)]
    pub fn txcie3(&mut self) -> TXCIE3_W {
        TXCIE3_W { w: self }
    }
    #[doc = "Bit 7 - RX Complete Interrupt Enable"]
    #[inline(always)]
    pub fn rxcie3(&mut self) -> RXCIE3_W {
        RXCIE3_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "USART Control and Status Register B\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [ucsr3b](index.html) module"]
pub struct UCSR3B_SPEC;
impl crate::RegisterSpec for UCSR3B_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [ucsr3b::R](R) reader structure"]
impl crate::Readable for UCSR3B_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [ucsr3b::W](W) writer structure"]
impl crate::Writable for UCSR3B_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets UCSR3B to value 0"]
impl crate::Resettable for UCSR3B_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
