#[doc = "Register `UCSR2C` reader"]
pub struct R(crate::R<UCSR2C_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<UCSR2C_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<UCSR2C_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<UCSR2C_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `UCSR2C` writer"]
pub struct W(crate::W<UCSR2C_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<UCSR2C_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<UCSR2C_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<UCSR2C_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Clock Polarity\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum UCPOL2_A {
    #[doc = "0: Transmit on Rising XCKn Edge, Receive on Falling XCKn Edge"]
    RISING_EDGE = 0,
    #[doc = "1: Transmit on Falling XCKn Edge, Receive on Rising XCKn Edge"]
    FALLING_EDGE = 1,
}
impl From<UCPOL2_A> for bool {
    #[inline(always)]
    fn from(variant: UCPOL2_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `UCPOL2` reader - Clock Polarity"]
pub struct UCPOL2_R(crate::FieldReader<bool, UCPOL2_A>);
impl UCPOL2_R {
    pub(crate) fn new(bits: bool) -> Self {
        UCPOL2_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> UCPOL2_A {
        match self.bits {
            false => UCPOL2_A::RISING_EDGE,
            true => UCPOL2_A::FALLING_EDGE,
        }
    }
    #[doc = "Checks if the value of the field is `RISING_EDGE`"]
    #[inline(always)]
    pub fn is_rising_edge(&self) -> bool {
        **self == UCPOL2_A::RISING_EDGE
    }
    #[doc = "Checks if the value of the field is `FALLING_EDGE`"]
    #[inline(always)]
    pub fn is_falling_edge(&self) -> bool {
        **self == UCPOL2_A::FALLING_EDGE
    }
}
impl core::ops::Deref for UCPOL2_R {
    type Target = crate::FieldReader<bool, UCPOL2_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `UCPOL2` writer - Clock Polarity"]
pub struct UCPOL2_W<'a> {
    w: &'a mut W,
}
impl<'a> UCPOL2_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: UCPOL2_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Transmit on Rising XCKn Edge, Receive on Falling XCKn Edge"]
    #[inline(always)]
    pub fn rising_edge(self) -> &'a mut W {
        self.variant(UCPOL2_A::RISING_EDGE)
    }
    #[doc = "Transmit on Falling XCKn Edge, Receive on Rising XCKn Edge"]
    #[inline(always)]
    pub fn falling_edge(self) -> &'a mut W {
        self.variant(UCPOL2_A::FALLING_EDGE)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Character Size\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum UCSZ2_A {
    #[doc = "0: Character Size: 5 bit"]
    CHR5 = 0,
    #[doc = "1: Character Size: 6 bit"]
    CHR6 = 1,
    #[doc = "2: Character Size: 7 bit"]
    CHR7 = 2,
    #[doc = "3: Character Size: 8 bit"]
    CHR8 = 3,
}
impl From<UCSZ2_A> for u8 {
    #[inline(always)]
    fn from(variant: UCSZ2_A) -> Self {
        variant as _
    }
}
#[doc = "Field `UCSZ2` reader - Character Size"]
pub struct UCSZ2_R(crate::FieldReader<u8, UCSZ2_A>);
impl UCSZ2_R {
    pub(crate) fn new(bits: u8) -> Self {
        UCSZ2_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> UCSZ2_A {
        match self.bits {
            0 => UCSZ2_A::CHR5,
            1 => UCSZ2_A::CHR6,
            2 => UCSZ2_A::CHR7,
            3 => UCSZ2_A::CHR8,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `CHR5`"]
    #[inline(always)]
    pub fn is_chr5(&self) -> bool {
        **self == UCSZ2_A::CHR5
    }
    #[doc = "Checks if the value of the field is `CHR6`"]
    #[inline(always)]
    pub fn is_chr6(&self) -> bool {
        **self == UCSZ2_A::CHR6
    }
    #[doc = "Checks if the value of the field is `CHR7`"]
    #[inline(always)]
    pub fn is_chr7(&self) -> bool {
        **self == UCSZ2_A::CHR7
    }
    #[doc = "Checks if the value of the field is `CHR8`"]
    #[inline(always)]
    pub fn is_chr8(&self) -> bool {
        **self == UCSZ2_A::CHR8
    }
}
impl core::ops::Deref for UCSZ2_R {
    type Target = crate::FieldReader<u8, UCSZ2_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `UCSZ2` writer - Character Size"]
pub struct UCSZ2_W<'a> {
    w: &'a mut W,
}
impl<'a> UCSZ2_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: UCSZ2_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "Character Size: 5 bit"]
    #[inline(always)]
    pub fn chr5(self) -> &'a mut W {
        self.variant(UCSZ2_A::CHR5)
    }
    #[doc = "Character Size: 6 bit"]
    #[inline(always)]
    pub fn chr6(self) -> &'a mut W {
        self.variant(UCSZ2_A::CHR6)
    }
    #[doc = "Character Size: 7 bit"]
    #[inline(always)]
    pub fn chr7(self) -> &'a mut W {
        self.variant(UCSZ2_A::CHR7)
    }
    #[doc = "Character Size: 8 bit"]
    #[inline(always)]
    pub fn chr8(self) -> &'a mut W {
        self.variant(UCSZ2_A::CHR8)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 1)) | ((value as u8 & 0x03) << 1);
        self.w
    }
}
#[doc = "Stop Bit Select\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum USBS2_A {
    #[doc = "0: 1-bit"]
    STOP1 = 0,
    #[doc = "1: 2-bit"]
    STOP2 = 1,
}
impl From<USBS2_A> for bool {
    #[inline(always)]
    fn from(variant: USBS2_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `USBS2` reader - Stop Bit Select"]
pub struct USBS2_R(crate::FieldReader<bool, USBS2_A>);
impl USBS2_R {
    pub(crate) fn new(bits: bool) -> Self {
        USBS2_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> USBS2_A {
        match self.bits {
            false => USBS2_A::STOP1,
            true => USBS2_A::STOP2,
        }
    }
    #[doc = "Checks if the value of the field is `STOP1`"]
    #[inline(always)]
    pub fn is_stop1(&self) -> bool {
        **self == USBS2_A::STOP1
    }
    #[doc = "Checks if the value of the field is `STOP2`"]
    #[inline(always)]
    pub fn is_stop2(&self) -> bool {
        **self == USBS2_A::STOP2
    }
}
impl core::ops::Deref for USBS2_R {
    type Target = crate::FieldReader<bool, USBS2_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `USBS2` writer - Stop Bit Select"]
pub struct USBS2_W<'a> {
    w: &'a mut W,
}
impl<'a> USBS2_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: USBS2_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "1-bit"]
    #[inline(always)]
    pub fn stop1(self) -> &'a mut W {
        self.variant(USBS2_A::STOP1)
    }
    #[doc = "2-bit"]
    #[inline(always)]
    pub fn stop2(self) -> &'a mut W {
        self.variant(USBS2_A::STOP2)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Parity Mode Bits\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum UPM2_A {
    #[doc = "0: Disabled"]
    DISABLED = 0,
    #[doc = "2: Enabled, Even Parity"]
    PARITY_EVEN = 2,
    #[doc = "3: Enabled, Odd Parity"]
    PARITY_ODD = 3,
}
impl From<UPM2_A> for u8 {
    #[inline(always)]
    fn from(variant: UPM2_A) -> Self {
        variant as _
    }
}
#[doc = "Field `UPM2` reader - Parity Mode Bits"]
pub struct UPM2_R(crate::FieldReader<u8, UPM2_A>);
impl UPM2_R {
    pub(crate) fn new(bits: u8) -> Self {
        UPM2_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> Option<UPM2_A> {
        match self.bits {
            0 => Some(UPM2_A::DISABLED),
            2 => Some(UPM2_A::PARITY_EVEN),
            3 => Some(UPM2_A::PARITY_ODD),
            _ => None,
        }
    }
    #[doc = "Checks if the value of the field is `DISABLED`"]
    #[inline(always)]
    pub fn is_disabled(&self) -> bool {
        **self == UPM2_A::DISABLED
    }
    #[doc = "Checks if the value of the field is `PARITY_EVEN`"]
    #[inline(always)]
    pub fn is_parity_even(&self) -> bool {
        **self == UPM2_A::PARITY_EVEN
    }
    #[doc = "Checks if the value of the field is `PARITY_ODD`"]
    #[inline(always)]
    pub fn is_parity_odd(&self) -> bool {
        **self == UPM2_A::PARITY_ODD
    }
}
impl core::ops::Deref for UPM2_R {
    type Target = crate::FieldReader<u8, UPM2_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `UPM2` writer - Parity Mode Bits"]
pub struct UPM2_W<'a> {
    w: &'a mut W,
}
impl<'a> UPM2_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: UPM2_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "Disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(UPM2_A::DISABLED)
    }
    #[doc = "Enabled, Even Parity"]
    #[inline(always)]
    pub fn parity_even(self) -> &'a mut W {
        self.variant(UPM2_A::PARITY_EVEN)
    }
    #[doc = "Enabled, Odd Parity"]
    #[inline(always)]
    pub fn parity_odd(self) -> &'a mut W {
        self.variant(UPM2_A::PARITY_ODD)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 4)) | ((value as u8 & 0x03) << 4);
        self.w
    }
}
#[doc = "USART Mode Select\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum UMSEL2_A {
    #[doc = "0: Asynchronous USART"]
    USART_ASYNC = 0,
    #[doc = "1: Synchronous USART"]
    USART_SYNC = 1,
    #[doc = "3: Master SPI (MSPIM)"]
    SPI_MASTER = 3,
}
impl From<UMSEL2_A> for u8 {
    #[inline(always)]
    fn from(variant: UMSEL2_A) -> Self {
        variant as _
    }
}
#[doc = "Field `UMSEL2` reader - USART Mode Select"]
pub struct UMSEL2_R(crate::FieldReader<u8, UMSEL2_A>);
impl UMSEL2_R {
    pub(crate) fn new(bits: u8) -> Self {
        UMSEL2_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> Option<UMSEL2_A> {
        match self.bits {
            0 => Some(UMSEL2_A::USART_ASYNC),
            1 => Some(UMSEL2_A::USART_SYNC),
            3 => Some(UMSEL2_A::SPI_MASTER),
            _ => None,
        }
    }
    #[doc = "Checks if the value of the field is `USART_ASYNC`"]
    #[inline(always)]
    pub fn is_usart_async(&self) -> bool {
        **self == UMSEL2_A::USART_ASYNC
    }
    #[doc = "Checks if the value of the field is `USART_SYNC`"]
    #[inline(always)]
    pub fn is_usart_sync(&self) -> bool {
        **self == UMSEL2_A::USART_SYNC
    }
    #[doc = "Checks if the value of the field is `SPI_MASTER`"]
    #[inline(always)]
    pub fn is_spi_master(&self) -> bool {
        **self == UMSEL2_A::SPI_MASTER
    }
}
impl core::ops::Deref for UMSEL2_R {
    type Target = crate::FieldReader<u8, UMSEL2_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `UMSEL2` writer - USART Mode Select"]
pub struct UMSEL2_W<'a> {
    w: &'a mut W,
}
impl<'a> UMSEL2_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: UMSEL2_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "Asynchronous USART"]
    #[inline(always)]
    pub fn usart_async(self) -> &'a mut W {
        self.variant(UMSEL2_A::USART_ASYNC)
    }
    #[doc = "Synchronous USART"]
    #[inline(always)]
    pub fn usart_sync(self) -> &'a mut W {
        self.variant(UMSEL2_A::USART_SYNC)
    }
    #[doc = "Master SPI (MSPIM)"]
    #[inline(always)]
    pub fn spi_master(self) -> &'a mut W {
        self.variant(UMSEL2_A::SPI_MASTER)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 6)) | ((value as u8 & 0x03) << 6);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Clock Polarity"]
    #[inline(always)]
    pub fn ucpol2(&self) -> UCPOL2_R {
        UCPOL2_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bits 1:2 - Character Size"]
    #[inline(always)]
    pub fn ucsz2(&self) -> UCSZ2_R {
        UCSZ2_R::new(((self.bits >> 1) & 0x03) as u8)
    }
    #[doc = "Bit 3 - Stop Bit Select"]
    #[inline(always)]
    pub fn usbs2(&self) -> USBS2_R {
        USBS2_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bits 4:5 - Parity Mode Bits"]
    #[inline(always)]
    pub fn upm2(&self) -> UPM2_R {
        UPM2_R::new(((self.bits >> 4) & 0x03) as u8)
    }
    #[doc = "Bits 6:7 - USART Mode Select"]
    #[inline(always)]
    pub fn umsel2(&self) -> UMSEL2_R {
        UMSEL2_R::new(((self.bits >> 6) & 0x03) as u8)
    }
}
impl W {
    #[doc = "Bit 0 - Clock Polarity"]
    #[inline(always)]
    pub fn ucpol2(&mut self) -> UCPOL2_W {
        UCPOL2_W { w: self }
    }
    #[doc = "Bits 1:2 - Character Size"]
    #[inline(always)]
    pub fn ucsz2(&mut self) -> UCSZ2_W {
        UCSZ2_W { w: self }
    }
    #[doc = "Bit 3 - Stop Bit Select"]
    #[inline(always)]
    pub fn usbs2(&mut self) -> USBS2_W {
        USBS2_W { w: self }
    }
    #[doc = "Bits 4:5 - Parity Mode Bits"]
    #[inline(always)]
    pub fn upm2(&mut self) -> UPM2_W {
        UPM2_W { w: self }
    }
    #[doc = "Bits 6:7 - USART Mode Select"]
    #[inline(always)]
    pub fn umsel2(&mut self) -> UMSEL2_W {
        UMSEL2_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "USART Control and Status Register C\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [ucsr2c](index.html) module"]
pub struct UCSR2C_SPEC;
impl crate::RegisterSpec for UCSR2C_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [ucsr2c::R](R) reader structure"]
impl crate::Readable for UCSR2C_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [ucsr2c::W](W) writer structure"]
impl crate::Writable for UCSR2C_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets UCSR2C to value 0"]
impl crate::Resettable for UCSR2C_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
