#[doc = "Register `TIMSK5` reader"]
pub struct R(crate::R<TIMSK5_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<TIMSK5_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<TIMSK5_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<TIMSK5_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `TIMSK5` writer"]
pub struct W(crate::W<TIMSK5_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<TIMSK5_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<TIMSK5_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<TIMSK5_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `TOIE5` reader - Timer/Counter5 Overflow Interrupt Enable"]
pub struct TOIE5_R(crate::FieldReader<bool, bool>);
impl TOIE5_R {
    pub(crate) fn new(bits: bool) -> Self {
        TOIE5_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TOIE5_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TOIE5` writer - Timer/Counter5 Overflow Interrupt Enable"]
pub struct TOIE5_W<'a> {
    w: &'a mut W,
}
impl<'a> TOIE5_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `OCIE5A` reader - Timer/Counter5 Output Compare A Match Interrupt Enable"]
pub struct OCIE5A_R(crate::FieldReader<bool, bool>);
impl OCIE5A_R {
    pub(crate) fn new(bits: bool) -> Self {
        OCIE5A_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for OCIE5A_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `OCIE5A` writer - Timer/Counter5 Output Compare A Match Interrupt Enable"]
pub struct OCIE5A_W<'a> {
    w: &'a mut W,
}
impl<'a> OCIE5A_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `OCIE5B` reader - Timer/Counter5 Output Compare B Match Interrupt Enable"]
pub struct OCIE5B_R(crate::FieldReader<bool, bool>);
impl OCIE5B_R {
    pub(crate) fn new(bits: bool) -> Self {
        OCIE5B_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for OCIE5B_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `OCIE5B` writer - Timer/Counter5 Output Compare B Match Interrupt Enable"]
pub struct OCIE5B_W<'a> {
    w: &'a mut W,
}
impl<'a> OCIE5B_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `OCIE5C` reader - Timer/Counter5 Output Compare C Match Interrupt Enable"]
pub struct OCIE5C_R(crate::FieldReader<bool, bool>);
impl OCIE5C_R {
    pub(crate) fn new(bits: bool) -> Self {
        OCIE5C_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for OCIE5C_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `OCIE5C` writer - Timer/Counter5 Output Compare C Match Interrupt Enable"]
pub struct OCIE5C_W<'a> {
    w: &'a mut W,
}
impl<'a> OCIE5C_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `ICIE5` reader - Timer/Counter5 Input Capture Interrupt Enable"]
pub struct ICIE5_R(crate::FieldReader<bool, bool>);
impl ICIE5_R {
    pub(crate) fn new(bits: bool) -> Self {
        ICIE5_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ICIE5_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ICIE5` writer - Timer/Counter5 Input Capture Interrupt Enable"]
pub struct ICIE5_W<'a> {
    w: &'a mut W,
}
impl<'a> ICIE5_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Timer/Counter5 Overflow Interrupt Enable"]
    #[inline(always)]
    pub fn toie5(&self) -> TOIE5_R {
        TOIE5_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Timer/Counter5 Output Compare A Match Interrupt Enable"]
    #[inline(always)]
    pub fn ocie5a(&self) -> OCIE5A_R {
        OCIE5A_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Timer/Counter5 Output Compare B Match Interrupt Enable"]
    #[inline(always)]
    pub fn ocie5b(&self) -> OCIE5B_R {
        OCIE5B_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Timer/Counter5 Output Compare C Match Interrupt Enable"]
    #[inline(always)]
    pub fn ocie5c(&self) -> OCIE5C_R {
        OCIE5C_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Timer/Counter5 Input Capture Interrupt Enable"]
    #[inline(always)]
    pub fn icie5(&self) -> ICIE5_R {
        ICIE5_R::new(((self.bits >> 5) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Timer/Counter5 Overflow Interrupt Enable"]
    #[inline(always)]
    pub fn toie5(&mut self) -> TOIE5_W {
        TOIE5_W { w: self }
    }
    #[doc = "Bit 1 - Timer/Counter5 Output Compare A Match Interrupt Enable"]
    #[inline(always)]
    pub fn ocie5a(&mut self) -> OCIE5A_W {
        OCIE5A_W { w: self }
    }
    #[doc = "Bit 2 - Timer/Counter5 Output Compare B Match Interrupt Enable"]
    #[inline(always)]
    pub fn ocie5b(&mut self) -> OCIE5B_W {
        OCIE5B_W { w: self }
    }
    #[doc = "Bit 3 - Timer/Counter5 Output Compare C Match Interrupt Enable"]
    #[inline(always)]
    pub fn ocie5c(&mut self) -> OCIE5C_W {
        OCIE5C_W { w: self }
    }
    #[doc = "Bit 5 - Timer/Counter5 Input Capture Interrupt Enable"]
    #[inline(always)]
    pub fn icie5(&mut self) -> ICIE5_W {
        ICIE5_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Timer/Counter5 Interrupt Mask Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [timsk5](index.html) module"]
pub struct TIMSK5_SPEC;
impl crate::RegisterSpec for TIMSK5_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [timsk5::R](R) reader structure"]
impl crate::Readable for TIMSK5_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [timsk5::W](W) writer structure"]
impl crate::Writable for TIMSK5_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets TIMSK5 to value 0"]
impl crate::Resettable for TIMSK5_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
