#[doc = "Register `TCCR4B` reader"]
pub struct R(crate::R<TCCR4B_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<TCCR4B_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<TCCR4B_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<TCCR4B_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `TCCR4B` writer"]
pub struct W(crate::W<TCCR4B_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<TCCR4B_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<TCCR4B_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<TCCR4B_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Prescaler source of Timer/Counter 4\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum CS4_A {
    #[doc = "0: No clock source (Timer/Counter stopped)"]
    NO_CLOCK = 0,
    #[doc = "1: Running, No Prescaling"]
    DIRECT = 1,
    #[doc = "2: Running, CLK/8"]
    PRESCALE_8 = 2,
    #[doc = "3: Running, CLK/64"]
    PRESCALE_64 = 3,
    #[doc = "4: Running, CLK/256"]
    PRESCALE_256 = 4,
    #[doc = "5: Running, CLK/1024"]
    PRESCALE_1024 = 5,
    #[doc = "6: Running, ExtClk Tx Falling Edge"]
    EXT_FALLING = 6,
    #[doc = "7: Running, ExtClk Tx Rising Edge"]
    EXT_RISING = 7,
}
impl From<CS4_A> for u8 {
    #[inline(always)]
    fn from(variant: CS4_A) -> Self {
        variant as _
    }
}
#[doc = "Field `CS4` reader - Prescaler source of Timer/Counter 4"]
pub struct CS4_R(crate::FieldReader<u8, CS4_A>);
impl CS4_R {
    pub(crate) fn new(bits: u8) -> Self {
        CS4_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> CS4_A {
        match self.bits {
            0 => CS4_A::NO_CLOCK,
            1 => CS4_A::DIRECT,
            2 => CS4_A::PRESCALE_8,
            3 => CS4_A::PRESCALE_64,
            4 => CS4_A::PRESCALE_256,
            5 => CS4_A::PRESCALE_1024,
            6 => CS4_A::EXT_FALLING,
            7 => CS4_A::EXT_RISING,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `NO_CLOCK`"]
    #[inline(always)]
    pub fn is_no_clock(&self) -> bool {
        **self == CS4_A::NO_CLOCK
    }
    #[doc = "Checks if the value of the field is `DIRECT`"]
    #[inline(always)]
    pub fn is_direct(&self) -> bool {
        **self == CS4_A::DIRECT
    }
    #[doc = "Checks if the value of the field is `PRESCALE_8`"]
    #[inline(always)]
    pub fn is_prescale_8(&self) -> bool {
        **self == CS4_A::PRESCALE_8
    }
    #[doc = "Checks if the value of the field is `PRESCALE_64`"]
    #[inline(always)]
    pub fn is_prescale_64(&self) -> bool {
        **self == CS4_A::PRESCALE_64
    }
    #[doc = "Checks if the value of the field is `PRESCALE_256`"]
    #[inline(always)]
    pub fn is_prescale_256(&self) -> bool {
        **self == CS4_A::PRESCALE_256
    }
    #[doc = "Checks if the value of the field is `PRESCALE_1024`"]
    #[inline(always)]
    pub fn is_prescale_1024(&self) -> bool {
        **self == CS4_A::PRESCALE_1024
    }
    #[doc = "Checks if the value of the field is `EXT_FALLING`"]
    #[inline(always)]
    pub fn is_ext_falling(&self) -> bool {
        **self == CS4_A::EXT_FALLING
    }
    #[doc = "Checks if the value of the field is `EXT_RISING`"]
    #[inline(always)]
    pub fn is_ext_rising(&self) -> bool {
        **self == CS4_A::EXT_RISING
    }
}
impl core::ops::Deref for CS4_R {
    type Target = crate::FieldReader<u8, CS4_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CS4` writer - Prescaler source of Timer/Counter 4"]
pub struct CS4_W<'a> {
    w: &'a mut W,
}
impl<'a> CS4_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: CS4_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "No clock source (Timer/Counter stopped)"]
    #[inline(always)]
    pub fn no_clock(self) -> &'a mut W {
        self.variant(CS4_A::NO_CLOCK)
    }
    #[doc = "Running, No Prescaling"]
    #[inline(always)]
    pub fn direct(self) -> &'a mut W {
        self.variant(CS4_A::DIRECT)
    }
    #[doc = "Running, CLK/8"]
    #[inline(always)]
    pub fn prescale_8(self) -> &'a mut W {
        self.variant(CS4_A::PRESCALE_8)
    }
    #[doc = "Running, CLK/64"]
    #[inline(always)]
    pub fn prescale_64(self) -> &'a mut W {
        self.variant(CS4_A::PRESCALE_64)
    }
    #[doc = "Running, CLK/256"]
    #[inline(always)]
    pub fn prescale_256(self) -> &'a mut W {
        self.variant(CS4_A::PRESCALE_256)
    }
    #[doc = "Running, CLK/1024"]
    #[inline(always)]
    pub fn prescale_1024(self) -> &'a mut W {
        self.variant(CS4_A::PRESCALE_1024)
    }
    #[doc = "Running, ExtClk Tx Falling Edge"]
    #[inline(always)]
    pub fn ext_falling(self) -> &'a mut W {
        self.variant(CS4_A::EXT_FALLING)
    }
    #[doc = "Running, ExtClk Tx Rising Edge"]
    #[inline(always)]
    pub fn ext_rising(self) -> &'a mut W {
        self.variant(CS4_A::EXT_RISING)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x07) | (value as u8 & 0x07);
        self.w
    }
}
#[doc = "Field `WGM4` reader - Waveform Generation Mode"]
pub struct WGM4_R(crate::FieldReader<u8, u8>);
impl WGM4_R {
    pub(crate) fn new(bits: u8) -> Self {
        WGM4_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for WGM4_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `WGM4` writer - Waveform Generation Mode"]
pub struct WGM4_W<'a> {
    w: &'a mut W,
}
impl<'a> WGM4_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 3)) | ((value as u8 & 0x03) << 3);
        self.w
    }
}
#[doc = "Field `ICES4` reader - Input Capture 4 Edge Select"]
pub struct ICES4_R(crate::FieldReader<bool, bool>);
impl ICES4_R {
    pub(crate) fn new(bits: bool) -> Self {
        ICES4_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ICES4_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ICES4` writer - Input Capture 4 Edge Select"]
pub struct ICES4_W<'a> {
    w: &'a mut W,
}
impl<'a> ICES4_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `ICNC4` reader - Input Capture 4 Noise Canceler"]
pub struct ICNC4_R(crate::FieldReader<bool, bool>);
impl ICNC4_R {
    pub(crate) fn new(bits: bool) -> Self {
        ICNC4_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ICNC4_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ICNC4` writer - Input Capture 4 Noise Canceler"]
pub struct ICNC4_W<'a> {
    w: &'a mut W,
}
impl<'a> ICNC4_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:2 - Prescaler source of Timer/Counter 4"]
    #[inline(always)]
    pub fn cs4(&self) -> CS4_R {
        CS4_R::new((self.bits & 0x07) as u8)
    }
    #[doc = "Bits 3:4 - Waveform Generation Mode"]
    #[inline(always)]
    pub fn wgm4(&self) -> WGM4_R {
        WGM4_R::new(((self.bits >> 3) & 0x03) as u8)
    }
    #[doc = "Bit 6 - Input Capture 4 Edge Select"]
    #[inline(always)]
    pub fn ices4(&self) -> ICES4_R {
        ICES4_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Input Capture 4 Noise Canceler"]
    #[inline(always)]
    pub fn icnc4(&self) -> ICNC4_R {
        ICNC4_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:2 - Prescaler source of Timer/Counter 4"]
    #[inline(always)]
    pub fn cs4(&mut self) -> CS4_W {
        CS4_W { w: self }
    }
    #[doc = "Bits 3:4 - Waveform Generation Mode"]
    #[inline(always)]
    pub fn wgm4(&mut self) -> WGM4_W {
        WGM4_W { w: self }
    }
    #[doc = "Bit 6 - Input Capture 4 Edge Select"]
    #[inline(always)]
    pub fn ices4(&mut self) -> ICES4_W {
        ICES4_W { w: self }
    }
    #[doc = "Bit 7 - Input Capture 4 Noise Canceler"]
    #[inline(always)]
    pub fn icnc4(&mut self) -> ICNC4_W {
        ICNC4_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Timer/Counter4 Control Register B\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [tccr4b](index.html) module"]
pub struct TCCR4B_SPEC;
impl crate::RegisterSpec for TCCR4B_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [tccr4b::R](R) reader structure"]
impl crate::Readable for TCCR4B_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [tccr4b::W](W) writer structure"]
impl crate::Writable for TCCR4B_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets TCCR4B to value 0"]
impl crate::Resettable for TCCR4B_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
