#[doc = "Register `TCCR1C` reader"]
pub struct R(crate::R<TCCR1C_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<TCCR1C_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<TCCR1C_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<TCCR1C_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `TCCR1C` writer"]
pub struct W(crate::W<TCCR1C_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<TCCR1C_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<TCCR1C_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<TCCR1C_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `FOC1C` writer - Force Output Compare 1C"]
pub struct FOC1C_W<'a> {
    w: &'a mut W,
}
impl<'a> FOC1C_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `FOC1B` writer - Force Output Compare 1B"]
pub struct FOC1B_W<'a> {
    w: &'a mut W,
}
impl<'a> FOC1B_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `FOC1A` writer - Force Output Compare 1A"]
pub struct FOC1A_W<'a> {
    w: &'a mut W,
}
impl<'a> FOC1A_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl W {
    #[doc = "Bit 5 - Force Output Compare 1C"]
    #[inline(always)]
    pub fn foc1c(&mut self) -> FOC1C_W {
        FOC1C_W { w: self }
    }
    #[doc = "Bit 6 - Force Output Compare 1B"]
    #[inline(always)]
    pub fn foc1b(&mut self) -> FOC1B_W {
        FOC1B_W { w: self }
    }
    #[doc = "Bit 7 - Force Output Compare 1A"]
    #[inline(always)]
    pub fn foc1a(&mut self) -> FOC1A_W {
        FOC1A_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Timer/Counter 1 Control Register C\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [tccr1c](index.html) module"]
pub struct TCCR1C_SPEC;
impl crate::RegisterSpec for TCCR1C_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [tccr1c::R](R) reader structure"]
impl crate::Readable for TCCR1C_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [tccr1c::W](W) writer structure"]
impl crate::Writable for TCCR1C_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets TCCR1C to value 0"]
impl crate::Resettable for TCCR1C_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
