#[doc = "Register `PCMSK1` reader"]
pub struct R(crate::R<PCMSK1_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<PCMSK1_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<PCMSK1_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<PCMSK1_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `PCMSK1` writer"]
pub struct W(crate::W<PCMSK1_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<PCMSK1_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<PCMSK1_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<PCMSK1_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `PCINT` reader - Pin Change Mask interrupt"]
pub struct PCINT_R(crate::FieldReader<u8, u8>);
impl PCINT_R {
    pub(crate) fn new(bits: u8) -> Self {
        PCINT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PCINT_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PCINT` writer - Pin Change Mask interrupt"]
pub struct PCINT_W<'a> {
    w: &'a mut W,
}
impl<'a> PCINT_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0xff) | (value as u8 & 0xff);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:7 - Pin Change Mask interrupt"]
    #[inline(always)]
    pub fn pcint(&self) -> PCINT_R {
        PCINT_R::new((self.bits & 0xff) as u8)
    }
}
impl W {
    #[doc = "Bits 0:7 - Pin Change Mask interrupt"]
    #[inline(always)]
    pub fn pcint(&mut self) -> PCINT_W {
        PCINT_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Pin Change Mask Register 1\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [pcmsk1](index.html) module"]
pub struct PCMSK1_SPEC;
impl crate::RegisterSpec for PCMSK1_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [pcmsk1::R](R) reader structure"]
impl crate::Readable for PCMSK1_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [pcmsk1::W](W) writer structure"]
impl crate::Writable for PCMSK1_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets PCMSK1 to value 0"]
impl crate::Resettable for PCMSK1_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
