#[doc = "Register `ADCSRA` reader"]
pub struct R(crate::R<ADCSRA_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<ADCSRA_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<ADCSRA_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<ADCSRA_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `ADCSRA` writer"]
pub struct W(crate::W<ADCSRA_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<ADCSRA_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<ADCSRA_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<ADCSRA_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "ADC Prescaler Select Bits\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum ADPS_A {
    #[doc = "1: Prescaler Value 2"]
    PRESCALER_2 = 1,
    #[doc = "2: Prescaler Value 4"]
    PRESCALER_4 = 2,
    #[doc = "3: Prescaler Value 8"]
    PRESCALER_8 = 3,
    #[doc = "4: Prescaler Value 16"]
    PRESCALER_16 = 4,
    #[doc = "5: Prescaler Value 32"]
    PRESCALER_32 = 5,
    #[doc = "6: Prescaler Value 64"]
    PRESCALER_64 = 6,
    #[doc = "7: Prescaler Value 128"]
    PRESCALER_128 = 7,
}
impl From<ADPS_A> for u8 {
    #[inline(always)]
    fn from(variant: ADPS_A) -> Self {
        variant as _
    }
}
#[doc = "Field `ADPS` reader - ADC Prescaler Select Bits"]
pub struct ADPS_R(crate::FieldReader<u8, ADPS_A>);
impl ADPS_R {
    pub(crate) fn new(bits: u8) -> Self {
        ADPS_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> Option<ADPS_A> {
        match self.bits {
            1 => Some(ADPS_A::PRESCALER_2),
            2 => Some(ADPS_A::PRESCALER_4),
            3 => Some(ADPS_A::PRESCALER_8),
            4 => Some(ADPS_A::PRESCALER_16),
            5 => Some(ADPS_A::PRESCALER_32),
            6 => Some(ADPS_A::PRESCALER_64),
            7 => Some(ADPS_A::PRESCALER_128),
            _ => None,
        }
    }
    #[doc = "Checks if the value of the field is `PRESCALER_2`"]
    #[inline(always)]
    pub fn is_prescaler_2(&self) -> bool {
        **self == ADPS_A::PRESCALER_2
    }
    #[doc = "Checks if the value of the field is `PRESCALER_4`"]
    #[inline(always)]
    pub fn is_prescaler_4(&self) -> bool {
        **self == ADPS_A::PRESCALER_4
    }
    #[doc = "Checks if the value of the field is `PRESCALER_8`"]
    #[inline(always)]
    pub fn is_prescaler_8(&self) -> bool {
        **self == ADPS_A::PRESCALER_8
    }
    #[doc = "Checks if the value of the field is `PRESCALER_16`"]
    #[inline(always)]
    pub fn is_prescaler_16(&self) -> bool {
        **self == ADPS_A::PRESCALER_16
    }
    #[doc = "Checks if the value of the field is `PRESCALER_32`"]
    #[inline(always)]
    pub fn is_prescaler_32(&self) -> bool {
        **self == ADPS_A::PRESCALER_32
    }
    #[doc = "Checks if the value of the field is `PRESCALER_64`"]
    #[inline(always)]
    pub fn is_prescaler_64(&self) -> bool {
        **self == ADPS_A::PRESCALER_64
    }
    #[doc = "Checks if the value of the field is `PRESCALER_128`"]
    #[inline(always)]
    pub fn is_prescaler_128(&self) -> bool {
        **self == ADPS_A::PRESCALER_128
    }
}
impl core::ops::Deref for ADPS_R {
    type Target = crate::FieldReader<u8, ADPS_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ADPS` writer - ADC Prescaler Select Bits"]
pub struct ADPS_W<'a> {
    w: &'a mut W,
}
impl<'a> ADPS_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: ADPS_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "Prescaler Value 2"]
    #[inline(always)]
    pub fn prescaler_2(self) -> &'a mut W {
        self.variant(ADPS_A::PRESCALER_2)
    }
    #[doc = "Prescaler Value 4"]
    #[inline(always)]
    pub fn prescaler_4(self) -> &'a mut W {
        self.variant(ADPS_A::PRESCALER_4)
    }
    #[doc = "Prescaler Value 8"]
    #[inline(always)]
    pub fn prescaler_8(self) -> &'a mut W {
        self.variant(ADPS_A::PRESCALER_8)
    }
    #[doc = "Prescaler Value 16"]
    #[inline(always)]
    pub fn prescaler_16(self) -> &'a mut W {
        self.variant(ADPS_A::PRESCALER_16)
    }
    #[doc = "Prescaler Value 32"]
    #[inline(always)]
    pub fn prescaler_32(self) -> &'a mut W {
        self.variant(ADPS_A::PRESCALER_32)
    }
    #[doc = "Prescaler Value 64"]
    #[inline(always)]
    pub fn prescaler_64(self) -> &'a mut W {
        self.variant(ADPS_A::PRESCALER_64)
    }
    #[doc = "Prescaler Value 128"]
    #[inline(always)]
    pub fn prescaler_128(self) -> &'a mut W {
        self.variant(ADPS_A::PRESCALER_128)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x07) | (value as u8 & 0x07);
        self.w
    }
}
#[doc = "Field `ADIE` reader - ADC Interrupt Enable"]
pub struct ADIE_R(crate::FieldReader<bool, bool>);
impl ADIE_R {
    pub(crate) fn new(bits: bool) -> Self {
        ADIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ADIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ADIE` writer - ADC Interrupt Enable"]
pub struct ADIE_W<'a> {
    w: &'a mut W,
}
impl<'a> ADIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `ADIF` reader - ADC Interrupt Flag"]
pub struct ADIF_R(crate::FieldReader<bool, bool>);
impl ADIF_R {
    pub(crate) fn new(bits: bool) -> Self {
        ADIF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ADIF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ADIF` writer - ADC Interrupt Flag"]
pub struct ADIF_W<'a> {
    w: &'a mut W,
}
impl<'a> ADIF_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `ADATE` reader - ADC Auto Trigger Enable"]
pub struct ADATE_R(crate::FieldReader<bool, bool>);
impl ADATE_R {
    pub(crate) fn new(bits: bool) -> Self {
        ADATE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ADATE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ADATE` writer - ADC Auto Trigger Enable"]
pub struct ADATE_W<'a> {
    w: &'a mut W,
}
impl<'a> ADATE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `ADSC` reader - ADC Start Conversion"]
pub struct ADSC_R(crate::FieldReader<bool, bool>);
impl ADSC_R {
    pub(crate) fn new(bits: bool) -> Self {
        ADSC_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ADSC_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ADSC` writer - ADC Start Conversion"]
pub struct ADSC_W<'a> {
    w: &'a mut W,
}
impl<'a> ADSC_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `ADEN` reader - ADC Enable"]
pub struct ADEN_R(crate::FieldReader<bool, bool>);
impl ADEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        ADEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ADEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ADEN` writer - ADC Enable"]
pub struct ADEN_W<'a> {
    w: &'a mut W,
}
impl<'a> ADEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:2 - ADC Prescaler Select Bits"]
    #[inline(always)]
    pub fn adps(&self) -> ADPS_R {
        ADPS_R::new((self.bits & 0x07) as u8)
    }
    #[doc = "Bit 3 - ADC Interrupt Enable"]
    #[inline(always)]
    pub fn adie(&self) -> ADIE_R {
        ADIE_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - ADC Interrupt Flag"]
    #[inline(always)]
    pub fn adif(&self) -> ADIF_R {
        ADIF_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - ADC Auto Trigger Enable"]
    #[inline(always)]
    pub fn adate(&self) -> ADATE_R {
        ADATE_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - ADC Start Conversion"]
    #[inline(always)]
    pub fn adsc(&self) -> ADSC_R {
        ADSC_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - ADC Enable"]
    #[inline(always)]
    pub fn aden(&self) -> ADEN_R {
        ADEN_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:2 - ADC Prescaler Select Bits"]
    #[inline(always)]
    pub fn adps(&mut self) -> ADPS_W {
        ADPS_W { w: self }
    }
    #[doc = "Bit 3 - ADC Interrupt Enable"]
    #[inline(always)]
    pub fn adie(&mut self) -> ADIE_W {
        ADIE_W { w: self }
    }
    #[doc = "Bit 4 - ADC Interrupt Flag"]
    #[inline(always)]
    pub fn adif(&mut self) -> ADIF_W {
        ADIF_W { w: self }
    }
    #[doc = "Bit 5 - ADC Auto Trigger Enable"]
    #[inline(always)]
    pub fn adate(&mut self) -> ADATE_W {
        ADATE_W { w: self }
    }
    #[doc = "Bit 6 - ADC Start Conversion"]
    #[inline(always)]
    pub fn adsc(&mut self) -> ADSC_W {
        ADSC_W { w: self }
    }
    #[doc = "Bit 7 - ADC Enable"]
    #[inline(always)]
    pub fn aden(&mut self) -> ADEN_W {
        ADEN_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "The ADC Control and Status register A\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [adcsra](index.html) module"]
pub struct ADCSRA_SPEC;
impl crate::RegisterSpec for ADCSRA_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [adcsra::R](R) reader structure"]
impl crate::Readable for ADCSRA_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [adcsra::W](W) writer structure"]
impl crate::Writable for ADCSRA_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets ADCSRA to value 0"]
impl crate::Resettable for ADCSRA_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
