#[doc = "Register `TIMSK1` reader"]
pub struct R(crate::R<TIMSK1_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<TIMSK1_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<TIMSK1_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<TIMSK1_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `TIMSK1` writer"]
pub struct W(crate::W<TIMSK1_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<TIMSK1_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<TIMSK1_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<TIMSK1_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `TOIE1` reader - Timer/Counter1 Overflow Interrupt Enable"]
pub struct TOIE1_R(crate::FieldReader<bool, bool>);
impl TOIE1_R {
    pub(crate) fn new(bits: bool) -> Self {
        TOIE1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TOIE1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TOIE1` writer - Timer/Counter1 Overflow Interrupt Enable"]
pub struct TOIE1_W<'a> {
    w: &'a mut W,
}
impl<'a> TOIE1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `OCIE1A` reader - Timer/Counter1 Output CompareA Match Interrupt Enable"]
pub struct OCIE1A_R(crate::FieldReader<bool, bool>);
impl OCIE1A_R {
    pub(crate) fn new(bits: bool) -> Self {
        OCIE1A_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for OCIE1A_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `OCIE1A` writer - Timer/Counter1 Output CompareA Match Interrupt Enable"]
pub struct OCIE1A_W<'a> {
    w: &'a mut W,
}
impl<'a> OCIE1A_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `OCIE1B` reader - Timer/Counter1 Output CompareB Match Interrupt Enable"]
pub struct OCIE1B_R(crate::FieldReader<bool, bool>);
impl OCIE1B_R {
    pub(crate) fn new(bits: bool) -> Self {
        OCIE1B_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for OCIE1B_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `OCIE1B` writer - Timer/Counter1 Output CompareB Match Interrupt Enable"]
pub struct OCIE1B_W<'a> {
    w: &'a mut W,
}
impl<'a> OCIE1B_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `ICIE1` reader - Timer/Counter1 Input Capture Interrupt Enable"]
pub struct ICIE1_R(crate::FieldReader<bool, bool>);
impl ICIE1_R {
    pub(crate) fn new(bits: bool) -> Self {
        ICIE1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ICIE1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ICIE1` writer - Timer/Counter1 Input Capture Interrupt Enable"]
pub struct ICIE1_W<'a> {
    w: &'a mut W,
}
impl<'a> ICIE1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Timer/Counter1 Overflow Interrupt Enable"]
    #[inline(always)]
    pub fn toie1(&self) -> TOIE1_R {
        TOIE1_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Timer/Counter1 Output CompareA Match Interrupt Enable"]
    #[inline(always)]
    pub fn ocie1a(&self) -> OCIE1A_R {
        OCIE1A_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Timer/Counter1 Output CompareB Match Interrupt Enable"]
    #[inline(always)]
    pub fn ocie1b(&self) -> OCIE1B_R {
        OCIE1B_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Timer/Counter1 Input Capture Interrupt Enable"]
    #[inline(always)]
    pub fn icie1(&self) -> ICIE1_R {
        ICIE1_R::new(((self.bits >> 5) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Timer/Counter1 Overflow Interrupt Enable"]
    #[inline(always)]
    pub fn toie1(&mut self) -> TOIE1_W {
        TOIE1_W { w: self }
    }
    #[doc = "Bit 1 - Timer/Counter1 Output CompareA Match Interrupt Enable"]
    #[inline(always)]
    pub fn ocie1a(&mut self) -> OCIE1A_W {
        OCIE1A_W { w: self }
    }
    #[doc = "Bit 2 - Timer/Counter1 Output CompareB Match Interrupt Enable"]
    #[inline(always)]
    pub fn ocie1b(&mut self) -> OCIE1B_W {
        OCIE1B_W { w: self }
    }
    #[doc = "Bit 5 - Timer/Counter1 Input Capture Interrupt Enable"]
    #[inline(always)]
    pub fn icie1(&mut self) -> ICIE1_W {
        ICIE1_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Timer/Counter Interrupt Mask Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [timsk1](index.html) module"]
pub struct TIMSK1_SPEC;
impl crate::RegisterSpec for TIMSK1_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [timsk1::R](R) reader structure"]
impl crate::Readable for TIMSK1_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [timsk1::W](W) writer structure"]
impl crate::Writable for TIMSK1_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets TIMSK1 to value 0"]
impl crate::Resettable for TIMSK1_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
