#[doc = "Register `EXTENDED` reader"]
pub struct R(crate::R<EXTENDED_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<EXTENDED_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<EXTENDED_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<EXTENDED_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `EXTENDED` writer"]
pub struct W(crate::W<EXTENDED_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<EXTENDED_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<EXTENDED_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<EXTENDED_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `BOOTRST` reader - Boot Reset vector Enabled"]
pub struct BOOTRST_R(crate::FieldReader<bool, bool>);
impl BOOTRST_R {
    pub(crate) fn new(bits: bool) -> Self {
        BOOTRST_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for BOOTRST_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `BOOTRST` writer - Boot Reset vector Enabled"]
pub struct BOOTRST_W<'a> {
    w: &'a mut W,
}
impl<'a> BOOTRST_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Select boot size\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum BOOTSZ_A {
    #[doc = "0: Boot Flash size=1024 words start address=$1C00"]
    _1024W_1C00 = 0,
    #[doc = "1: Boot Flash size=512 words start address=$1E00"]
    _512W_1E00 = 1,
    #[doc = "2: Boot Flash size=256 words start address=$1F00"]
    _256W_1F00 = 2,
    #[doc = "3: Boot Flash size=128 words start address=$1F80"]
    _128W_1F80 = 3,
}
impl From<BOOTSZ_A> for u8 {
    #[inline(always)]
    fn from(variant: BOOTSZ_A) -> Self {
        variant as _
    }
}
#[doc = "Field `BOOTSZ` reader - Select boot size"]
pub struct BOOTSZ_R(crate::FieldReader<u8, BOOTSZ_A>);
impl BOOTSZ_R {
    pub(crate) fn new(bits: u8) -> Self {
        BOOTSZ_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> BOOTSZ_A {
        match self.bits {
            0 => BOOTSZ_A::_1024W_1C00,
            1 => BOOTSZ_A::_512W_1E00,
            2 => BOOTSZ_A::_256W_1F00,
            3 => BOOTSZ_A::_128W_1F80,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `_1024W_1C00`"]
    #[inline(always)]
    pub fn is_1024w_1c00(&self) -> bool {
        **self == BOOTSZ_A::_1024W_1C00
    }
    #[doc = "Checks if the value of the field is `_512W_1E00`"]
    #[inline(always)]
    pub fn is_512w_1e00(&self) -> bool {
        **self == BOOTSZ_A::_512W_1E00
    }
    #[doc = "Checks if the value of the field is `_256W_1F00`"]
    #[inline(always)]
    pub fn is_256w_1f00(&self) -> bool {
        **self == BOOTSZ_A::_256W_1F00
    }
    #[doc = "Checks if the value of the field is `_128W_1F80`"]
    #[inline(always)]
    pub fn is_128w_1f80(&self) -> bool {
        **self == BOOTSZ_A::_128W_1F80
    }
}
impl core::ops::Deref for BOOTSZ_R {
    type Target = crate::FieldReader<u8, BOOTSZ_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `BOOTSZ` writer - Select boot size"]
pub struct BOOTSZ_W<'a> {
    w: &'a mut W,
}
impl<'a> BOOTSZ_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: BOOTSZ_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "Boot Flash size=1024 words start address=$1C00"]
    #[inline(always)]
    pub fn _1024w_1c00(self) -> &'a mut W {
        self.variant(BOOTSZ_A::_1024W_1C00)
    }
    #[doc = "Boot Flash size=512 words start address=$1E00"]
    #[inline(always)]
    pub fn _512w_1e00(self) -> &'a mut W {
        self.variant(BOOTSZ_A::_512W_1E00)
    }
    #[doc = "Boot Flash size=256 words start address=$1F00"]
    #[inline(always)]
    pub fn _256w_1f00(self) -> &'a mut W {
        self.variant(BOOTSZ_A::_256W_1F00)
    }
    #[doc = "Boot Flash size=128 words start address=$1F80"]
    #[inline(always)]
    pub fn _128w_1f80(self) -> &'a mut W {
        self.variant(BOOTSZ_A::_128W_1F80)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 1)) | ((value as u8 & 0x03) << 1);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Boot Reset vector Enabled"]
    #[inline(always)]
    pub fn bootrst(&self) -> BOOTRST_R {
        BOOTRST_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bits 1:2 - Select boot size"]
    #[inline(always)]
    pub fn bootsz(&self) -> BOOTSZ_R {
        BOOTSZ_R::new(((self.bits >> 1) & 0x03) as u8)
    }
}
impl W {
    #[doc = "Bit 0 - Boot Reset vector Enabled"]
    #[inline(always)]
    pub fn bootrst(&mut self) -> BOOTRST_W {
        BOOTRST_W { w: self }
    }
    #[doc = "Bits 1:2 - Select boot size"]
    #[inline(always)]
    pub fn bootsz(&mut self) -> BOOTSZ_W {
        BOOTSZ_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "No Description.\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [extended](index.html) module"]
pub struct EXTENDED_SPEC;
impl crate::RegisterSpec for EXTENDED_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [extended::R](R) reader structure"]
impl crate::Readable for EXTENDED_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [extended::W](W) writer structure"]
impl crate::Writable for EXTENDED_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets EXTENDED to value 0"]
impl crate::Resettable for EXTENDED_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
