#[doc = "Register `TWAMR` reader"]
pub struct R(crate::R<TWAMR_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<TWAMR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<TWAMR_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<TWAMR_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `TWAMR` writer"]
pub struct W(crate::W<TWAMR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<TWAMR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<TWAMR_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<TWAMR_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `TWAM` reader - TWI (Slave) Address Mask Bits"]
pub struct TWAM_R(crate::FieldReader<u8, u8>);
impl TWAM_R {
    pub(crate) fn new(bits: u8) -> Self {
        TWAM_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TWAM_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TWAM` writer - TWI (Slave) Address Mask Bits"]
pub struct TWAM_W<'a> {
    w: &'a mut W,
}
impl<'a> TWAM_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x7f << 1)) | ((value as u8 & 0x7f) << 1);
        self.w
    }
}
impl R {
    #[doc = "Bits 1:7 - TWI (Slave) Address Mask Bits"]
    #[inline(always)]
    pub fn twam(&self) -> TWAM_R {
        TWAM_R::new(((self.bits >> 1) & 0x7f) as u8)
    }
}
impl W {
    #[doc = "Bits 1:7 - TWI (Slave) Address Mask Bits"]
    #[inline(always)]
    pub fn twam(&mut self) -> TWAM_W {
        TWAM_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "TWI (Slave) Address Mask Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [twamr](index.html) module"]
pub struct TWAMR_SPEC;
impl crate::RegisterSpec for TWAMR_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [twamr::R](R) reader structure"]
impl crate::Readable for TWAMR_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [twamr::W](W) writer structure"]
impl crate::Writable for TWAMR_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets TWAMR to value 0"]
impl crate::Resettable for TWAMR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
