#[doc = "Register `TIFR5` reader"]
pub struct R(crate::R<TIFR5_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<TIFR5_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<TIFR5_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<TIFR5_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `TIFR5` writer"]
pub struct W(crate::W<TIFR5_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<TIFR5_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<TIFR5_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<TIFR5_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `TOV5` reader - Timer/Counter5 Overflow Flag"]
pub struct TOV5_R(crate::FieldReader<bool, bool>);
impl TOV5_R {
    pub(crate) fn new(bits: bool) -> Self {
        TOV5_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TOV5_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TOV5` writer - Timer/Counter5 Overflow Flag"]
pub struct TOV5_W<'a> {
    w: &'a mut W,
}
impl<'a> TOV5_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `OCF5A` reader - Output Compare Flag 5A"]
pub struct OCF5A_R(crate::FieldReader<bool, bool>);
impl OCF5A_R {
    pub(crate) fn new(bits: bool) -> Self {
        OCF5A_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for OCF5A_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `OCF5A` writer - Output Compare Flag 5A"]
pub struct OCF5A_W<'a> {
    w: &'a mut W,
}
impl<'a> OCF5A_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `OCF5B` reader - Output Compare Flag 5B"]
pub struct OCF5B_R(crate::FieldReader<bool, bool>);
impl OCF5B_R {
    pub(crate) fn new(bits: bool) -> Self {
        OCF5B_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for OCF5B_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `OCF5B` writer - Output Compare Flag 5B"]
pub struct OCF5B_W<'a> {
    w: &'a mut W,
}
impl<'a> OCF5B_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `OCF5C` reader - Output Compare Flag 5C"]
pub struct OCF5C_R(crate::FieldReader<bool, bool>);
impl OCF5C_R {
    pub(crate) fn new(bits: bool) -> Self {
        OCF5C_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for OCF5C_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `OCF5C` writer - Output Compare Flag 5C"]
pub struct OCF5C_W<'a> {
    w: &'a mut W,
}
impl<'a> OCF5C_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `ICF5` reader - Input Capture Flag 5"]
pub struct ICF5_R(crate::FieldReader<bool, bool>);
impl ICF5_R {
    pub(crate) fn new(bits: bool) -> Self {
        ICF5_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ICF5_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ICF5` writer - Input Capture Flag 5"]
pub struct ICF5_W<'a> {
    w: &'a mut W,
}
impl<'a> ICF5_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Timer/Counter5 Overflow Flag"]
    #[inline(always)]
    pub fn tov5(&self) -> TOV5_R {
        TOV5_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Output Compare Flag 5A"]
    #[inline(always)]
    pub fn ocf5a(&self) -> OCF5A_R {
        OCF5A_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Output Compare Flag 5B"]
    #[inline(always)]
    pub fn ocf5b(&self) -> OCF5B_R {
        OCF5B_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Output Compare Flag 5C"]
    #[inline(always)]
    pub fn ocf5c(&self) -> OCF5C_R {
        OCF5C_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Input Capture Flag 5"]
    #[inline(always)]
    pub fn icf5(&self) -> ICF5_R {
        ICF5_R::new(((self.bits >> 5) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Timer/Counter5 Overflow Flag"]
    #[inline(always)]
    pub fn tov5(&mut self) -> TOV5_W {
        TOV5_W { w: self }
    }
    #[doc = "Bit 1 - Output Compare Flag 5A"]
    #[inline(always)]
    pub fn ocf5a(&mut self) -> OCF5A_W {
        OCF5A_W { w: self }
    }
    #[doc = "Bit 2 - Output Compare Flag 5B"]
    #[inline(always)]
    pub fn ocf5b(&mut self) -> OCF5B_W {
        OCF5B_W { w: self }
    }
    #[doc = "Bit 3 - Output Compare Flag 5C"]
    #[inline(always)]
    pub fn ocf5c(&mut self) -> OCF5C_W {
        OCF5C_W { w: self }
    }
    #[doc = "Bit 5 - Input Capture Flag 5"]
    #[inline(always)]
    pub fn icf5(&mut self) -> ICF5_W {
        ICF5_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Timer/Counter5 Interrupt Flag register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [tifr5](index.html) module"]
pub struct TIFR5_SPEC;
impl crate::RegisterSpec for TIFR5_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [tifr5::R](R) reader structure"]
impl crate::Readable for TIFR5_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [tifr5::W](W) writer structure"]
impl crate::Writable for TIFR5_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets TIFR5 to value 0"]
impl crate::Resettable for TIFR5_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
