#[doc = "Register `TCCR2A` reader"]
pub struct R(crate::R<TCCR2A_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<TCCR2A_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<TCCR2A_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<TCCR2A_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `TCCR2A` writer"]
pub struct W(crate::W<TCCR2A_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<TCCR2A_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<TCCR2A_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<TCCR2A_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `WGM2` reader - Waveform Genration Mode"]
pub struct WGM2_R(crate::FieldReader<u8, u8>);
impl WGM2_R {
    pub(crate) fn new(bits: u8) -> Self {
        WGM2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for WGM2_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `WGM2` writer - Waveform Genration Mode"]
pub struct WGM2_W<'a> {
    w: &'a mut W,
}
impl<'a> WGM2_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x03) | (value as u8 & 0x03);
        self.w
    }
}
#[doc = "Field `COM2B` reader - Compare Output Mode bits"]
pub struct COM2B_R(crate::FieldReader<u8, u8>);
impl COM2B_R {
    pub(crate) fn new(bits: u8) -> Self {
        COM2B_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for COM2B_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `COM2B` writer - Compare Output Mode bits"]
pub struct COM2B_W<'a> {
    w: &'a mut W,
}
impl<'a> COM2B_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 4)) | ((value as u8 & 0x03) << 4);
        self.w
    }
}
#[doc = "Field `COM2A` reader - Compare Output Mode bits"]
pub struct COM2A_R(crate::FieldReader<u8, u8>);
impl COM2A_R {
    pub(crate) fn new(bits: u8) -> Self {
        COM2A_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for COM2A_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `COM2A` writer - Compare Output Mode bits"]
pub struct COM2A_W<'a> {
    w: &'a mut W,
}
impl<'a> COM2A_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 6)) | ((value as u8 & 0x03) << 6);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:1 - Waveform Genration Mode"]
    #[inline(always)]
    pub fn wgm2(&self) -> WGM2_R {
        WGM2_R::new((self.bits & 0x03) as u8)
    }
    #[doc = "Bits 4:5 - Compare Output Mode bits"]
    #[inline(always)]
    pub fn com2b(&self) -> COM2B_R {
        COM2B_R::new(((self.bits >> 4) & 0x03) as u8)
    }
    #[doc = "Bits 6:7 - Compare Output Mode bits"]
    #[inline(always)]
    pub fn com2a(&self) -> COM2A_R {
        COM2A_R::new(((self.bits >> 6) & 0x03) as u8)
    }
}
impl W {
    #[doc = "Bits 0:1 - Waveform Genration Mode"]
    #[inline(always)]
    pub fn wgm2(&mut self) -> WGM2_W {
        WGM2_W { w: self }
    }
    #[doc = "Bits 4:5 - Compare Output Mode bits"]
    #[inline(always)]
    pub fn com2b(&mut self) -> COM2B_W {
        COM2B_W { w: self }
    }
    #[doc = "Bits 6:7 - Compare Output Mode bits"]
    #[inline(always)]
    pub fn com2a(&mut self) -> COM2A_W {
        COM2A_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Timer/Counter2 Control Register A\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [tccr2a](index.html) module"]
pub struct TCCR2A_SPEC;
impl crate::RegisterSpec for TCCR2A_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [tccr2a::R](R) reader structure"]
impl crate::Readable for TCCR2A_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [tccr2a::W](W) writer structure"]
impl crate::Writable for TCCR2A_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets TCCR2A to value 0"]
impl crate::Resettable for TCCR2A_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
