#[doc = "Register `DDRK` reader"]
pub struct R(crate::R<DDRK_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<DDRK_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<DDRK_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<DDRK_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `DDRK` writer"]
pub struct W(crate::W<DDRK_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<DDRK_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<DDRK_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<DDRK_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `PK0` reader - Pin K0"]
pub struct PK0_R(crate::FieldReader<bool, bool>);
impl PK0_R {
    pub(crate) fn new(bits: bool) -> Self {
        PK0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PK0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PK0` writer - Pin K0"]
pub struct PK0_W<'a> {
    w: &'a mut W,
}
impl<'a> PK0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `PK1` reader - Pin K1"]
pub struct PK1_R(crate::FieldReader<bool, bool>);
impl PK1_R {
    pub(crate) fn new(bits: bool) -> Self {
        PK1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PK1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PK1` writer - Pin K1"]
pub struct PK1_W<'a> {
    w: &'a mut W,
}
impl<'a> PK1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `PK2` reader - Pin K2"]
pub struct PK2_R(crate::FieldReader<bool, bool>);
impl PK2_R {
    pub(crate) fn new(bits: bool) -> Self {
        PK2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PK2_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PK2` writer - Pin K2"]
pub struct PK2_W<'a> {
    w: &'a mut W,
}
impl<'a> PK2_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `PK3` reader - Pin K3"]
pub struct PK3_R(crate::FieldReader<bool, bool>);
impl PK3_R {
    pub(crate) fn new(bits: bool) -> Self {
        PK3_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PK3_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PK3` writer - Pin K3"]
pub struct PK3_W<'a> {
    w: &'a mut W,
}
impl<'a> PK3_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `PK4` reader - Pin K4"]
pub struct PK4_R(crate::FieldReader<bool, bool>);
impl PK4_R {
    pub(crate) fn new(bits: bool) -> Self {
        PK4_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PK4_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PK4` writer - Pin K4"]
pub struct PK4_W<'a> {
    w: &'a mut W,
}
impl<'a> PK4_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `PK5` reader - Pin K5"]
pub struct PK5_R(crate::FieldReader<bool, bool>);
impl PK5_R {
    pub(crate) fn new(bits: bool) -> Self {
        PK5_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PK5_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PK5` writer - Pin K5"]
pub struct PK5_W<'a> {
    w: &'a mut W,
}
impl<'a> PK5_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `PK6` reader - Pin K6"]
pub struct PK6_R(crate::FieldReader<bool, bool>);
impl PK6_R {
    pub(crate) fn new(bits: bool) -> Self {
        PK6_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PK6_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PK6` writer - Pin K6"]
pub struct PK6_W<'a> {
    w: &'a mut W,
}
impl<'a> PK6_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `PK7` reader - Pin K7"]
pub struct PK7_R(crate::FieldReader<bool, bool>);
impl PK7_R {
    pub(crate) fn new(bits: bool) -> Self {
        PK7_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PK7_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PK7` writer - Pin K7"]
pub struct PK7_W<'a> {
    w: &'a mut W,
}
impl<'a> PK7_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Pin K0"]
    #[inline(always)]
    pub fn pk0(&self) -> PK0_R {
        PK0_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Pin K1"]
    #[inline(always)]
    pub fn pk1(&self) -> PK1_R {
        PK1_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Pin K2"]
    #[inline(always)]
    pub fn pk2(&self) -> PK2_R {
        PK2_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Pin K3"]
    #[inline(always)]
    pub fn pk3(&self) -> PK3_R {
        PK3_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Pin K4"]
    #[inline(always)]
    pub fn pk4(&self) -> PK4_R {
        PK4_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Pin K5"]
    #[inline(always)]
    pub fn pk5(&self) -> PK5_R {
        PK5_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Pin K6"]
    #[inline(always)]
    pub fn pk6(&self) -> PK6_R {
        PK6_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Pin K7"]
    #[inline(always)]
    pub fn pk7(&self) -> PK7_R {
        PK7_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Pin K0"]
    #[inline(always)]
    pub fn pk0(&mut self) -> PK0_W {
        PK0_W { w: self }
    }
    #[doc = "Bit 1 - Pin K1"]
    #[inline(always)]
    pub fn pk1(&mut self) -> PK1_W {
        PK1_W { w: self }
    }
    #[doc = "Bit 2 - Pin K2"]
    #[inline(always)]
    pub fn pk2(&mut self) -> PK2_W {
        PK2_W { w: self }
    }
    #[doc = "Bit 3 - Pin K3"]
    #[inline(always)]
    pub fn pk3(&mut self) -> PK3_W {
        PK3_W { w: self }
    }
    #[doc = "Bit 4 - Pin K4"]
    #[inline(always)]
    pub fn pk4(&mut self) -> PK4_W {
        PK4_W { w: self }
    }
    #[doc = "Bit 5 - Pin K5"]
    #[inline(always)]
    pub fn pk5(&mut self) -> PK5_W {
        PK5_W { w: self }
    }
    #[doc = "Bit 6 - Pin K6"]
    #[inline(always)]
    pub fn pk6(&mut self) -> PK6_W {
        PK6_W { w: self }
    }
    #[doc = "Bit 7 - Pin K7"]
    #[inline(always)]
    pub fn pk7(&mut self) -> PK7_W {
        PK7_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "PORT K Data Direction Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [ddrk](index.html) module"]
pub struct DDRK_SPEC;
impl crate::RegisterSpec for DDRK_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [ddrk::R](R) reader structure"]
impl crate::Readable for DDRK_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [ddrk::W](W) writer structure"]
impl crate::Writable for DDRK_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets DDRK to value 0"]
impl crate::Resettable for DDRK_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
