#[doc = "Register `DDRG` reader"]
pub struct R(crate::R<DDRG_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<DDRG_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<DDRG_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<DDRG_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `DDRG` writer"]
pub struct W(crate::W<DDRG_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<DDRG_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<DDRG_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<DDRG_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `PG0` reader - Pin G0"]
pub struct PG0_R(crate::FieldReader<bool, bool>);
impl PG0_R {
    pub(crate) fn new(bits: bool) -> Self {
        PG0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PG0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PG0` writer - Pin G0"]
pub struct PG0_W<'a> {
    w: &'a mut W,
}
impl<'a> PG0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `PG1` reader - Pin G1"]
pub struct PG1_R(crate::FieldReader<bool, bool>);
impl PG1_R {
    pub(crate) fn new(bits: bool) -> Self {
        PG1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PG1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PG1` writer - Pin G1"]
pub struct PG1_W<'a> {
    w: &'a mut W,
}
impl<'a> PG1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `PG2` reader - Pin G2"]
pub struct PG2_R(crate::FieldReader<bool, bool>);
impl PG2_R {
    pub(crate) fn new(bits: bool) -> Self {
        PG2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PG2_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PG2` writer - Pin G2"]
pub struct PG2_W<'a> {
    w: &'a mut W,
}
impl<'a> PG2_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `PG3` reader - Pin G3"]
pub struct PG3_R(crate::FieldReader<bool, bool>);
impl PG3_R {
    pub(crate) fn new(bits: bool) -> Self {
        PG3_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PG3_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PG3` writer - Pin G3"]
pub struct PG3_W<'a> {
    w: &'a mut W,
}
impl<'a> PG3_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `PG4` reader - Pin G4"]
pub struct PG4_R(crate::FieldReader<bool, bool>);
impl PG4_R {
    pub(crate) fn new(bits: bool) -> Self {
        PG4_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PG4_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PG4` writer - Pin G4"]
pub struct PG4_W<'a> {
    w: &'a mut W,
}
impl<'a> PG4_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `PG5` reader - Pin G5"]
pub struct PG5_R(crate::FieldReader<bool, bool>);
impl PG5_R {
    pub(crate) fn new(bits: bool) -> Self {
        PG5_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PG5_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PG5` writer - Pin G5"]
pub struct PG5_W<'a> {
    w: &'a mut W,
}
impl<'a> PG5_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `PG6` reader - Pin G6"]
pub struct PG6_R(crate::FieldReader<bool, bool>);
impl PG6_R {
    pub(crate) fn new(bits: bool) -> Self {
        PG6_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PG6_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PG6` writer - Pin G6"]
pub struct PG6_W<'a> {
    w: &'a mut W,
}
impl<'a> PG6_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `PG7` reader - Pin G7"]
pub struct PG7_R(crate::FieldReader<bool, bool>);
impl PG7_R {
    pub(crate) fn new(bits: bool) -> Self {
        PG7_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PG7_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PG7` writer - Pin G7"]
pub struct PG7_W<'a> {
    w: &'a mut W,
}
impl<'a> PG7_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Pin G0"]
    #[inline(always)]
    pub fn pg0(&self) -> PG0_R {
        PG0_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Pin G1"]
    #[inline(always)]
    pub fn pg1(&self) -> PG1_R {
        PG1_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Pin G2"]
    #[inline(always)]
    pub fn pg2(&self) -> PG2_R {
        PG2_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Pin G3"]
    #[inline(always)]
    pub fn pg3(&self) -> PG3_R {
        PG3_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Pin G4"]
    #[inline(always)]
    pub fn pg4(&self) -> PG4_R {
        PG4_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Pin G5"]
    #[inline(always)]
    pub fn pg5(&self) -> PG5_R {
        PG5_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Pin G6"]
    #[inline(always)]
    pub fn pg6(&self) -> PG6_R {
        PG6_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Pin G7"]
    #[inline(always)]
    pub fn pg7(&self) -> PG7_R {
        PG7_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Pin G0"]
    #[inline(always)]
    pub fn pg0(&mut self) -> PG0_W {
        PG0_W { w: self }
    }
    #[doc = "Bit 1 - Pin G1"]
    #[inline(always)]
    pub fn pg1(&mut self) -> PG1_W {
        PG1_W { w: self }
    }
    #[doc = "Bit 2 - Pin G2"]
    #[inline(always)]
    pub fn pg2(&mut self) -> PG2_W {
        PG2_W { w: self }
    }
    #[doc = "Bit 3 - Pin G3"]
    #[inline(always)]
    pub fn pg3(&mut self) -> PG3_W {
        PG3_W { w: self }
    }
    #[doc = "Bit 4 - Pin G4"]
    #[inline(always)]
    pub fn pg4(&mut self) -> PG4_W {
        PG4_W { w: self }
    }
    #[doc = "Bit 5 - Pin G5"]
    #[inline(always)]
    pub fn pg5(&mut self) -> PG5_W {
        PG5_W { w: self }
    }
    #[doc = "Bit 6 - Pin G6"]
    #[inline(always)]
    pub fn pg6(&mut self) -> PG6_W {
        PG6_W { w: self }
    }
    #[doc = "Bit 7 - Pin G7"]
    #[inline(always)]
    pub fn pg7(&mut self) -> PG7_W {
        PG7_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Data Direction Register, Port G\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [ddrg](index.html) module"]
pub struct DDRG_SPEC;
impl crate::RegisterSpec for DDRG_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [ddrg::R](R) reader structure"]
impl crate::Readable for DDRG_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [ddrg::W](W) writer structure"]
impl crate::Writable for DDRG_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets DDRG to value 0"]
impl crate::Resettable for DDRG_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
