#[doc = "Register `XMCRB` reader"]
pub struct R(crate::R<XMCRB_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<XMCRB_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<XMCRB_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<XMCRB_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `XMCRB` writer"]
pub struct W(crate::W<XMCRB_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<XMCRB_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<XMCRB_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<XMCRB_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `XMM` reader - External Memory High Mask"]
pub struct XMM_R(crate::FieldReader<u8, u8>);
impl XMM_R {
    pub(crate) fn new(bits: u8) -> Self {
        XMM_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for XMM_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `XMM` writer - External Memory High Mask"]
pub struct XMM_W<'a> {
    w: &'a mut W,
}
impl<'a> XMM_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x07) | (value as u8 & 0x07);
        self.w
    }
}
#[doc = "Field `XMBK` reader - External Memory Bus Keeper Enable"]
pub struct XMBK_R(crate::FieldReader<bool, bool>);
impl XMBK_R {
    pub(crate) fn new(bits: bool) -> Self {
        XMBK_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for XMBK_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `XMBK` writer - External Memory Bus Keeper Enable"]
pub struct XMBK_W<'a> {
    w: &'a mut W,
}
impl<'a> XMBK_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:2 - External Memory High Mask"]
    #[inline(always)]
    pub fn xmm(&self) -> XMM_R {
        XMM_R::new((self.bits & 0x07) as u8)
    }
    #[doc = "Bit 7 - External Memory Bus Keeper Enable"]
    #[inline(always)]
    pub fn xmbk(&self) -> XMBK_R {
        XMBK_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:2 - External Memory High Mask"]
    #[inline(always)]
    pub fn xmm(&mut self) -> XMM_W {
        XMM_W { w: self }
    }
    #[doc = "Bit 7 - External Memory Bus Keeper Enable"]
    #[inline(always)]
    pub fn xmbk(&mut self) -> XMBK_W {
        XMBK_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "External Memory Control Register B\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [xmcrb](index.html) module"]
pub struct XMCRB_SPEC;
impl crate::RegisterSpec for XMCRB_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [xmcrb::R](R) reader structure"]
impl crate::Readable for XMCRB_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [xmcrb::W](W) writer structure"]
impl crate::Writable for XMCRB_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets XMCRB to value 0"]
impl crate::Resettable for XMCRB_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
