#[doc = "Register `GPIOR0` reader"]
pub struct R(crate::R<GPIOR0_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<GPIOR0_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<GPIOR0_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<GPIOR0_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `GPIOR0` writer"]
pub struct W(crate::W<GPIOR0_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<GPIOR0_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<GPIOR0_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<GPIOR0_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `GPIOR00` reader - General Purpose IO Register 0 bit 0"]
pub struct GPIOR00_R(crate::FieldReader<bool, bool>);
impl GPIOR00_R {
    pub(crate) fn new(bits: bool) -> Self {
        GPIOR00_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for GPIOR00_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `GPIOR00` writer - General Purpose IO Register 0 bit 0"]
pub struct GPIOR00_W<'a> {
    w: &'a mut W,
}
impl<'a> GPIOR00_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `GPIOR01` reader - General Purpose IO Register 0 bit 1"]
pub struct GPIOR01_R(crate::FieldReader<bool, bool>);
impl GPIOR01_R {
    pub(crate) fn new(bits: bool) -> Self {
        GPIOR01_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for GPIOR01_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `GPIOR01` writer - General Purpose IO Register 0 bit 1"]
pub struct GPIOR01_W<'a> {
    w: &'a mut W,
}
impl<'a> GPIOR01_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `GPIOR02` reader - General Purpose IO Register 0 bit 2"]
pub struct GPIOR02_R(crate::FieldReader<bool, bool>);
impl GPIOR02_R {
    pub(crate) fn new(bits: bool) -> Self {
        GPIOR02_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for GPIOR02_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `GPIOR02` writer - General Purpose IO Register 0 bit 2"]
pub struct GPIOR02_W<'a> {
    w: &'a mut W,
}
impl<'a> GPIOR02_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `GPIOR03` reader - General Purpose IO Register 0 bit 3"]
pub struct GPIOR03_R(crate::FieldReader<bool, bool>);
impl GPIOR03_R {
    pub(crate) fn new(bits: bool) -> Self {
        GPIOR03_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for GPIOR03_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `GPIOR03` writer - General Purpose IO Register 0 bit 3"]
pub struct GPIOR03_W<'a> {
    w: &'a mut W,
}
impl<'a> GPIOR03_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `GPIOR04` reader - General Purpose IO Register 0 bit 4"]
pub struct GPIOR04_R(crate::FieldReader<bool, bool>);
impl GPIOR04_R {
    pub(crate) fn new(bits: bool) -> Self {
        GPIOR04_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for GPIOR04_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `GPIOR04` writer - General Purpose IO Register 0 bit 4"]
pub struct GPIOR04_W<'a> {
    w: &'a mut W,
}
impl<'a> GPIOR04_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `GPIOR05` reader - General Purpose IO Register 0 bit 5"]
pub struct GPIOR05_R(crate::FieldReader<bool, bool>);
impl GPIOR05_R {
    pub(crate) fn new(bits: bool) -> Self {
        GPIOR05_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for GPIOR05_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `GPIOR05` writer - General Purpose IO Register 0 bit 5"]
pub struct GPIOR05_W<'a> {
    w: &'a mut W,
}
impl<'a> GPIOR05_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `GPIOR06` reader - General Purpose IO Register 0 bit 6"]
pub struct GPIOR06_R(crate::FieldReader<bool, bool>);
impl GPIOR06_R {
    pub(crate) fn new(bits: bool) -> Self {
        GPIOR06_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for GPIOR06_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `GPIOR06` writer - General Purpose IO Register 0 bit 6"]
pub struct GPIOR06_W<'a> {
    w: &'a mut W,
}
impl<'a> GPIOR06_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `GPIOR07` reader - General Purpose IO Register 0 bit 7"]
pub struct GPIOR07_R(crate::FieldReader<bool, bool>);
impl GPIOR07_R {
    pub(crate) fn new(bits: bool) -> Self {
        GPIOR07_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for GPIOR07_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `GPIOR07` writer - General Purpose IO Register 0 bit 7"]
pub struct GPIOR07_W<'a> {
    w: &'a mut W,
}
impl<'a> GPIOR07_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - General Purpose IO Register 0 bit 0"]
    #[inline(always)]
    pub fn gpior00(&self) -> GPIOR00_R {
        GPIOR00_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - General Purpose IO Register 0 bit 1"]
    #[inline(always)]
    pub fn gpior01(&self) -> GPIOR01_R {
        GPIOR01_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - General Purpose IO Register 0 bit 2"]
    #[inline(always)]
    pub fn gpior02(&self) -> GPIOR02_R {
        GPIOR02_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - General Purpose IO Register 0 bit 3"]
    #[inline(always)]
    pub fn gpior03(&self) -> GPIOR03_R {
        GPIOR03_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - General Purpose IO Register 0 bit 4"]
    #[inline(always)]
    pub fn gpior04(&self) -> GPIOR04_R {
        GPIOR04_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - General Purpose IO Register 0 bit 5"]
    #[inline(always)]
    pub fn gpior05(&self) -> GPIOR05_R {
        GPIOR05_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - General Purpose IO Register 0 bit 6"]
    #[inline(always)]
    pub fn gpior06(&self) -> GPIOR06_R {
        GPIOR06_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - General Purpose IO Register 0 bit 7"]
    #[inline(always)]
    pub fn gpior07(&self) -> GPIOR07_R {
        GPIOR07_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - General Purpose IO Register 0 bit 0"]
    #[inline(always)]
    pub fn gpior00(&mut self) -> GPIOR00_W {
        GPIOR00_W { w: self }
    }
    #[doc = "Bit 1 - General Purpose IO Register 0 bit 1"]
    #[inline(always)]
    pub fn gpior01(&mut self) -> GPIOR01_W {
        GPIOR01_W { w: self }
    }
    #[doc = "Bit 2 - General Purpose IO Register 0 bit 2"]
    #[inline(always)]
    pub fn gpior02(&mut self) -> GPIOR02_W {
        GPIOR02_W { w: self }
    }
    #[doc = "Bit 3 - General Purpose IO Register 0 bit 3"]
    #[inline(always)]
    pub fn gpior03(&mut self) -> GPIOR03_W {
        GPIOR03_W { w: self }
    }
    #[doc = "Bit 4 - General Purpose IO Register 0 bit 4"]
    #[inline(always)]
    pub fn gpior04(&mut self) -> GPIOR04_W {
        GPIOR04_W { w: self }
    }
    #[doc = "Bit 5 - General Purpose IO Register 0 bit 5"]
    #[inline(always)]
    pub fn gpior05(&mut self) -> GPIOR05_W {
        GPIOR05_W { w: self }
    }
    #[doc = "Bit 6 - General Purpose IO Register 0 bit 6"]
    #[inline(always)]
    pub fn gpior06(&mut self) -> GPIOR06_W {
        GPIOR06_W { w: self }
    }
    #[doc = "Bit 7 - General Purpose IO Register 0 bit 7"]
    #[inline(always)]
    pub fn gpior07(&mut self) -> GPIOR07_W {
        GPIOR07_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "General Purpose IO Register 0\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [gpior0](index.html) module"]
pub struct GPIOR0_SPEC;
impl crate::RegisterSpec for GPIOR0_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [gpior0::R](R) reader structure"]
impl crate::Readable for GPIOR0_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [gpior0::W](W) writer structure"]
impl crate::Writable for GPIOR0_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets GPIOR0 to value 0"]
impl crate::Resettable for GPIOR0_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
