#[doc = "Register `USBINT` reader"]
pub struct R(crate::R<USBINT_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<USBINT_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<USBINT_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<USBINT_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `USBINT` writer"]
pub struct W(crate::W<USBINT_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<USBINT_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<USBINT_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<USBINT_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `VBUSTI` reader - No Description."]
pub struct VBUSTI_R(crate::FieldReader<bool, bool>);
impl VBUSTI_R {
    pub(crate) fn new(bits: bool) -> Self {
        VBUSTI_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for VBUSTI_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `VBUSTI` writer - No Description."]
pub struct VBUSTI_W<'a> {
    w: &'a mut W,
}
impl<'a> VBUSTI_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `IDTI` reader - No Description."]
pub struct IDTI_R(crate::FieldReader<bool, bool>);
impl IDTI_R {
    pub(crate) fn new(bits: bool) -> Self {
        IDTI_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for IDTI_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `IDTI` writer - No Description."]
pub struct IDTI_W<'a> {
    w: &'a mut W,
}
impl<'a> IDTI_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - No Description."]
    #[inline(always)]
    pub fn vbusti(&self) -> VBUSTI_R {
        VBUSTI_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - No Description."]
    #[inline(always)]
    pub fn idti(&self) -> IDTI_R {
        IDTI_R::new(((self.bits >> 1) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - No Description."]
    #[inline(always)]
    pub fn vbusti(&mut self) -> VBUSTI_W {
        VBUSTI_W { w: self }
    }
    #[doc = "Bit 1 - No Description."]
    #[inline(always)]
    pub fn idti(&mut self) -> IDTI_W {
        IDTI_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "No Description.\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [usbint](index.html) module"]
pub struct USBINT_SPEC;
impl crate::RegisterSpec for USBINT_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [usbint::R](R) reader structure"]
impl crate::Readable for USBINT_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [usbint::W](W) writer structure"]
impl crate::Writable for USBINT_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets USBINT to value 0"]
impl crate::Resettable for USBINT_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
