#[doc = "Register `UHWCON` reader"]
pub struct R(crate::R<UHWCON_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<UHWCON_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<UHWCON_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<UHWCON_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `UHWCON` writer"]
pub struct W(crate::W<UHWCON_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<UHWCON_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<UHWCON_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<UHWCON_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `UVREGE` reader - No Description."]
pub struct UVREGE_R(crate::FieldReader<bool, bool>);
impl UVREGE_R {
    pub(crate) fn new(bits: bool) -> Self {
        UVREGE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for UVREGE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `UVREGE` writer - No Description."]
pub struct UVREGE_W<'a> {
    w: &'a mut W,
}
impl<'a> UVREGE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `UVCONE` reader - No Description."]
pub struct UVCONE_R(crate::FieldReader<bool, bool>);
impl UVCONE_R {
    pub(crate) fn new(bits: bool) -> Self {
        UVCONE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for UVCONE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `UVCONE` writer - No Description."]
pub struct UVCONE_W<'a> {
    w: &'a mut W,
}
impl<'a> UVCONE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `UIDE` reader - No Description."]
pub struct UIDE_R(crate::FieldReader<bool, bool>);
impl UIDE_R {
    pub(crate) fn new(bits: bool) -> Self {
        UIDE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for UIDE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `UIDE` writer - No Description."]
pub struct UIDE_W<'a> {
    w: &'a mut W,
}
impl<'a> UIDE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `UIMOD` reader - No Description."]
pub struct UIMOD_R(crate::FieldReader<bool, bool>);
impl UIMOD_R {
    pub(crate) fn new(bits: bool) -> Self {
        UIMOD_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for UIMOD_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `UIMOD` writer - No Description."]
pub struct UIMOD_W<'a> {
    w: &'a mut W,
}
impl<'a> UIMOD_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - No Description."]
    #[inline(always)]
    pub fn uvrege(&self) -> UVREGE_R {
        UVREGE_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 4 - No Description."]
    #[inline(always)]
    pub fn uvcone(&self) -> UVCONE_R {
        UVCONE_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 6 - No Description."]
    #[inline(always)]
    pub fn uide(&self) -> UIDE_R {
        UIDE_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - No Description."]
    #[inline(always)]
    pub fn uimod(&self) -> UIMOD_R {
        UIMOD_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - No Description."]
    #[inline(always)]
    pub fn uvrege(&mut self) -> UVREGE_W {
        UVREGE_W { w: self }
    }
    #[doc = "Bit 4 - No Description."]
    #[inline(always)]
    pub fn uvcone(&mut self) -> UVCONE_W {
        UVCONE_W { w: self }
    }
    #[doc = "Bit 6 - No Description."]
    #[inline(always)]
    pub fn uide(&mut self) -> UIDE_W {
        UIDE_W { w: self }
    }
    #[doc = "Bit 7 - No Description."]
    #[inline(always)]
    pub fn uimod(&mut self) -> UIMOD_W {
        UIMOD_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "USB Hardware Configuration Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [uhwcon](index.html) module"]
pub struct UHWCON_SPEC;
impl crate::RegisterSpec for UHWCON_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [uhwcon::R](R) reader structure"]
impl crate::Readable for UHWCON_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [uhwcon::W](W) writer structure"]
impl crate::Writable for UHWCON_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets UHWCON to value 0"]
impl crate::Resettable for UHWCON_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
