#[doc = "Register `TWCR` reader"]
pub struct R(crate::R<TWCR_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<TWCR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<TWCR_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<TWCR_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `TWCR` writer"]
pub struct W(crate::W<TWCR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<TWCR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<TWCR_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<TWCR_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `TWIE` reader - TWI Interrupt Enable"]
pub struct TWIE_R(crate::FieldReader<bool, bool>);
impl TWIE_R {
    pub(crate) fn new(bits: bool) -> Self {
        TWIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TWIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TWIE` writer - TWI Interrupt Enable"]
pub struct TWIE_W<'a> {
    w: &'a mut W,
}
impl<'a> TWIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `TWEN` reader - TWI Enable Bit"]
pub struct TWEN_R(crate::FieldReader<bool, bool>);
impl TWEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        TWEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TWEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TWEN` writer - TWI Enable Bit"]
pub struct TWEN_W<'a> {
    w: &'a mut W,
}
impl<'a> TWEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `TWWC` reader - TWI Write Collition Flag"]
pub struct TWWC_R(crate::FieldReader<bool, bool>);
impl TWWC_R {
    pub(crate) fn new(bits: bool) -> Self {
        TWWC_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TWWC_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TWSTO` reader - TWI Stop Condition Bit"]
pub struct TWSTO_R(crate::FieldReader<bool, bool>);
impl TWSTO_R {
    pub(crate) fn new(bits: bool) -> Self {
        TWSTO_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TWSTO_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TWSTO` writer - TWI Stop Condition Bit"]
pub struct TWSTO_W<'a> {
    w: &'a mut W,
}
impl<'a> TWSTO_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `TWSTA` reader - TWI Start Condition Bit"]
pub struct TWSTA_R(crate::FieldReader<bool, bool>);
impl TWSTA_R {
    pub(crate) fn new(bits: bool) -> Self {
        TWSTA_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TWSTA_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TWSTA` writer - TWI Start Condition Bit"]
pub struct TWSTA_W<'a> {
    w: &'a mut W,
}
impl<'a> TWSTA_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `TWEA` reader - TWI Enable Acknowledge Bit"]
pub struct TWEA_R(crate::FieldReader<bool, bool>);
impl TWEA_R {
    pub(crate) fn new(bits: bool) -> Self {
        TWEA_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TWEA_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TWEA` writer - TWI Enable Acknowledge Bit"]
pub struct TWEA_W<'a> {
    w: &'a mut W,
}
impl<'a> TWEA_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `TWINT` reader - TWI Interrupt Flag"]
pub struct TWINT_R(crate::FieldReader<bool, bool>);
impl TWINT_R {
    pub(crate) fn new(bits: bool) -> Self {
        TWINT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TWINT_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TWINT` writer - TWI Interrupt Flag"]
pub struct TWINT_W<'a> {
    w: &'a mut W,
}
impl<'a> TWINT_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - TWI Interrupt Enable"]
    #[inline(always)]
    pub fn twie(&self) -> TWIE_R {
        TWIE_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 2 - TWI Enable Bit"]
    #[inline(always)]
    pub fn twen(&self) -> TWEN_R {
        TWEN_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - TWI Write Collition Flag"]
    #[inline(always)]
    pub fn twwc(&self) -> TWWC_R {
        TWWC_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - TWI Stop Condition Bit"]
    #[inline(always)]
    pub fn twsto(&self) -> TWSTO_R {
        TWSTO_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - TWI Start Condition Bit"]
    #[inline(always)]
    pub fn twsta(&self) -> TWSTA_R {
        TWSTA_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - TWI Enable Acknowledge Bit"]
    #[inline(always)]
    pub fn twea(&self) -> TWEA_R {
        TWEA_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - TWI Interrupt Flag"]
    #[inline(always)]
    pub fn twint(&self) -> TWINT_R {
        TWINT_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - TWI Interrupt Enable"]
    #[inline(always)]
    pub fn twie(&mut self) -> TWIE_W {
        TWIE_W { w: self }
    }
    #[doc = "Bit 2 - TWI Enable Bit"]
    #[inline(always)]
    pub fn twen(&mut self) -> TWEN_W {
        TWEN_W { w: self }
    }
    #[doc = "Bit 4 - TWI Stop Condition Bit"]
    #[inline(always)]
    pub fn twsto(&mut self) -> TWSTO_W {
        TWSTO_W { w: self }
    }
    #[doc = "Bit 5 - TWI Start Condition Bit"]
    #[inline(always)]
    pub fn twsta(&mut self) -> TWSTA_W {
        TWSTA_W { w: self }
    }
    #[doc = "Bit 6 - TWI Enable Acknowledge Bit"]
    #[inline(always)]
    pub fn twea(&mut self) -> TWEA_W {
        TWEA_W { w: self }
    }
    #[doc = "Bit 7 - TWI Interrupt Flag"]
    #[inline(always)]
    pub fn twint(&mut self) -> TWINT_W {
        TWINT_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "TWI Control Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [twcr](index.html) module"]
pub struct TWCR_SPEC;
impl crate::RegisterSpec for TWCR_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [twcr::R](R) reader structure"]
impl crate::Readable for TWCR_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [twcr::W](W) writer structure"]
impl crate::Writable for TWCR_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets TWCR to value 0"]
impl crate::Resettable for TWCR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
