#[doc = "Register `TCCR0B` reader"]
pub struct R(crate::R<TCCR0B_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<TCCR0B_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<TCCR0B_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<TCCR0B_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `TCCR0B` writer"]
pub struct W(crate::W<TCCR0B_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<TCCR0B_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<TCCR0B_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<TCCR0B_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Clock Select\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum CS0_A {
    #[doc = "0: No Clock Source (Stopped)"]
    VAL_0X00 = 0,
    #[doc = "1: Running, No Prescaling"]
    VAL_0X01 = 1,
    #[doc = "2: Running, CLK/8"]
    VAL_0X02 = 2,
    #[doc = "3: Running, CLK/64"]
    VAL_0X03 = 3,
    #[doc = "4: Running, CLK/256"]
    VAL_0X04 = 4,
    #[doc = "5: Running, CLK/1024"]
    VAL_0X05 = 5,
    #[doc = "6: Running, ExtClk Tx Falling Edge"]
    VAL_0X06 = 6,
    #[doc = "7: Running, ExtClk Tx Rising Edge"]
    VAL_0X07 = 7,
}
impl From<CS0_A> for u8 {
    #[inline(always)]
    fn from(variant: CS0_A) -> Self {
        variant as _
    }
}
#[doc = "Field `CS0` reader - Clock Select"]
pub struct CS0_R(crate::FieldReader<u8, CS0_A>);
impl CS0_R {
    pub(crate) fn new(bits: u8) -> Self {
        CS0_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> CS0_A {
        match self.bits {
            0 => CS0_A::VAL_0X00,
            1 => CS0_A::VAL_0X01,
            2 => CS0_A::VAL_0X02,
            3 => CS0_A::VAL_0X03,
            4 => CS0_A::VAL_0X04,
            5 => CS0_A::VAL_0X05,
            6 => CS0_A::VAL_0X06,
            7 => CS0_A::VAL_0X07,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `VAL_0X00`"]
    #[inline(always)]
    pub fn is_val_0x00(&self) -> bool {
        **self == CS0_A::VAL_0X00
    }
    #[doc = "Checks if the value of the field is `VAL_0X01`"]
    #[inline(always)]
    pub fn is_val_0x01(&self) -> bool {
        **self == CS0_A::VAL_0X01
    }
    #[doc = "Checks if the value of the field is `VAL_0X02`"]
    #[inline(always)]
    pub fn is_val_0x02(&self) -> bool {
        **self == CS0_A::VAL_0X02
    }
    #[doc = "Checks if the value of the field is `VAL_0X03`"]
    #[inline(always)]
    pub fn is_val_0x03(&self) -> bool {
        **self == CS0_A::VAL_0X03
    }
    #[doc = "Checks if the value of the field is `VAL_0X04`"]
    #[inline(always)]
    pub fn is_val_0x04(&self) -> bool {
        **self == CS0_A::VAL_0X04
    }
    #[doc = "Checks if the value of the field is `VAL_0X05`"]
    #[inline(always)]
    pub fn is_val_0x05(&self) -> bool {
        **self == CS0_A::VAL_0X05
    }
    #[doc = "Checks if the value of the field is `VAL_0X06`"]
    #[inline(always)]
    pub fn is_val_0x06(&self) -> bool {
        **self == CS0_A::VAL_0X06
    }
    #[doc = "Checks if the value of the field is `VAL_0X07`"]
    #[inline(always)]
    pub fn is_val_0x07(&self) -> bool {
        **self == CS0_A::VAL_0X07
    }
}
impl core::ops::Deref for CS0_R {
    type Target = crate::FieldReader<u8, CS0_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CS0` writer - Clock Select"]
pub struct CS0_W<'a> {
    w: &'a mut W,
}
impl<'a> CS0_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: CS0_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "No Clock Source (Stopped)"]
    #[inline(always)]
    pub fn val_0x00(self) -> &'a mut W {
        self.variant(CS0_A::VAL_0X00)
    }
    #[doc = "Running, No Prescaling"]
    #[inline(always)]
    pub fn val_0x01(self) -> &'a mut W {
        self.variant(CS0_A::VAL_0X01)
    }
    #[doc = "Running, CLK/8"]
    #[inline(always)]
    pub fn val_0x02(self) -> &'a mut W {
        self.variant(CS0_A::VAL_0X02)
    }
    #[doc = "Running, CLK/64"]
    #[inline(always)]
    pub fn val_0x03(self) -> &'a mut W {
        self.variant(CS0_A::VAL_0X03)
    }
    #[doc = "Running, CLK/256"]
    #[inline(always)]
    pub fn val_0x04(self) -> &'a mut W {
        self.variant(CS0_A::VAL_0X04)
    }
    #[doc = "Running, CLK/1024"]
    #[inline(always)]
    pub fn val_0x05(self) -> &'a mut W {
        self.variant(CS0_A::VAL_0X05)
    }
    #[doc = "Running, ExtClk Tx Falling Edge"]
    #[inline(always)]
    pub fn val_0x06(self) -> &'a mut W {
        self.variant(CS0_A::VAL_0X06)
    }
    #[doc = "Running, ExtClk Tx Rising Edge"]
    #[inline(always)]
    pub fn val_0x07(self) -> &'a mut W {
        self.variant(CS0_A::VAL_0X07)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x07) | (value as u8 & 0x07);
        self.w
    }
}
#[doc = "Field `WGM02` reader - No Description."]
pub struct WGM02_R(crate::FieldReader<bool, bool>);
impl WGM02_R {
    pub(crate) fn new(bits: bool) -> Self {
        WGM02_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for WGM02_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `WGM02` writer - No Description."]
pub struct WGM02_W<'a> {
    w: &'a mut W,
}
impl<'a> WGM02_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `FOC0B` reader - Force Output Compare B"]
pub struct FOC0B_R(crate::FieldReader<bool, bool>);
impl FOC0B_R {
    pub(crate) fn new(bits: bool) -> Self {
        FOC0B_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FOC0B_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FOC0B` writer - Force Output Compare B"]
pub struct FOC0B_W<'a> {
    w: &'a mut W,
}
impl<'a> FOC0B_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `FOC0A` reader - Force Output Compare A"]
pub struct FOC0A_R(crate::FieldReader<bool, bool>);
impl FOC0A_R {
    pub(crate) fn new(bits: bool) -> Self {
        FOC0A_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FOC0A_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FOC0A` writer - Force Output Compare A"]
pub struct FOC0A_W<'a> {
    w: &'a mut W,
}
impl<'a> FOC0A_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:2 - Clock Select"]
    #[inline(always)]
    pub fn cs0(&self) -> CS0_R {
        CS0_R::new((self.bits & 0x07) as u8)
    }
    #[doc = "Bit 3 - No Description."]
    #[inline(always)]
    pub fn wgm02(&self) -> WGM02_R {
        WGM02_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Force Output Compare B"]
    #[inline(always)]
    pub fn foc0b(&self) -> FOC0B_R {
        FOC0B_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Force Output Compare A"]
    #[inline(always)]
    pub fn foc0a(&self) -> FOC0A_R {
        FOC0A_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:2 - Clock Select"]
    #[inline(always)]
    pub fn cs0(&mut self) -> CS0_W {
        CS0_W { w: self }
    }
    #[doc = "Bit 3 - No Description."]
    #[inline(always)]
    pub fn wgm02(&mut self) -> WGM02_W {
        WGM02_W { w: self }
    }
    #[doc = "Bit 6 - Force Output Compare B"]
    #[inline(always)]
    pub fn foc0b(&mut self) -> FOC0B_W {
        FOC0B_W { w: self }
    }
    #[doc = "Bit 7 - Force Output Compare A"]
    #[inline(always)]
    pub fn foc0a(&mut self) -> FOC0A_W {
        FOC0A_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Timer/Counter Control Register B\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [tccr0b](index.html) module"]
pub struct TCCR0B_SPEC;
impl crate::RegisterSpec for TCCR0B_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [tccr0b::R](R) reader structure"]
impl crate::Readable for TCCR0B_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [tccr0b::W](W) writer structure"]
impl crate::Writable for TCCR0B_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets TCCR0B to value 0"]
impl crate::Resettable for TCCR0B_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
