// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 <LICENSE-APACHE or
// https://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or https://opensource.org/licenses/MIT>, at your
// option. This file may not be copied, modified, or distributed
// except according to those terms.

use syn::Attribute;

/// Returns the attribute (if any) which contains a doc comment.
pub(super) fn get_doc_attr(attrs: &[Attribute]) -> Option<Attribute> {
    attrs
        .iter()
        .find(|a| a.path.get_ident().iter().any(|p| *p == "doc"))
        .cloned()
}
