#[derive(thiserror::Error, Debug)]
pub enum Error {
    #[error(transparent)]
    Any(#[from] anyhow::Error),
    #[error("{0} isn't found")]
    NotFound(String),
    #[error("{0} is invalid")]
    Invalid(String),
}

impl Error {
    #[inline]
    pub fn any<E>(err: E) -> Self
    where
        E: std::error::Error,
    {
        Self::Any(anyhow::format_err!("{}", err))
    }
}
