/*
 * File: error.rs
 * Project: src
 * Created Date: 27/05/2021
 * Author: Shun Suzuki
 * -----
 * Last Modified: 27/05/2021
 * Modified By: Shun Suzuki (suzuki@hapis.k.u-tokyo.ac.jp)
 * -----
 * Copyright (c) 2021 Hapis Lab. All rights reserved.
 *
 */

use thiserror::Error;

#[derive(Error, Debug)]
pub enum AdsError {
    #[error("Failed to open port")]
    FailedOpenPort,
    #[error("Failed to get local address: {0}")]
    FailedGetLocalAddress(i32),
    #[error("Failed to send data: {0}")]
    FailedSendData(i32),
    #[error("Failed to read data: {0}")]
    FailedReadData(i32),
}
