use glib::Value;
use gstreamer::{
	tags::{merge_strings_with_comma, CustomTag},
	Tag, TagFlag,
};

pub struct MbArtistId;

impl<'a> Tag<'a> for MbArtistId {
	type TagType = &'a str;

	fn tag_name<'b>() -> &'b str {
		"musicbrainz-artistid"
	}
}

impl CustomTag<'_> for MbArtistId {
	const FLAG: TagFlag = TagFlag::Meta;
	const NICK: &'static str = "artist ID";
	const DESCRIPTION: &'static str = "MusicBrainz artist ID";

	fn merge_func(src: &Value) -> Value {
		merge_strings_with_comma(src)
	}
}

pub struct MbAlbumArtistId;

impl<'a> Tag<'a> for MbAlbumArtistId {
	type TagType = &'a str;

	fn tag_name<'b>() -> &'b str {
		"musicbrainz-albumartistid"
	}
}

impl CustomTag<'_> for MbAlbumArtistId {
	const FLAG: TagFlag = TagFlag::Meta;
	const NICK: &'static str = "album artist ID";
	const DESCRIPTION: &'static str = "MusicBrainz album artist ID";

	fn merge_func(src: &Value) -> Value {
		merge_strings_with_comma(src)
	}
}
