/*!
# Unsafe _aubio_ library bindings

[![github](https://img.shields.io/badge/github-katyo/aubio--rs-8da0cb.svg?style=for-the-badge&logo=github)](https://github.com/katyo/aubio-rs)
[![crate](https://img.shields.io/crates/v/aubio-sys.svg?style=for-the-badge&color=fc8d62&logo=rust)](https://crates.io/crates/aubio-sys)
[![docs](https://img.shields.io/badge/docs.rs-aubio--sys-66c2a5?style=for-the-badge&logo=data:image/svg+xml;base64,PHN2ZyByb2xlPSJpbWciIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgdmlld0JveD0iMCAwIDUxMiA1MTIiPjxwYXRoIGZpbGw9IiNmNWY1ZjUiIGQ9Ik00ODguNiAyNTAuMkwzOTIgMjE0VjEwNS41YzAtMTUtOS4zLTI4LjQtMjMuNC0zMy43bC0xMDAtMzcuNWMtOC4xLTMuMS0xNy4xLTMuMS0yNS4zIDBsLTEwMCAzNy41Yy0xNC4xIDUuMy0yMy40IDE4LjctMjMuNCAzMy43VjIxNGwtOTYuNiAzNi4yQzkuMyAyNTUuNSAwIDI2OC45IDAgMjgzLjlWMzk0YzAgMTMuNiA3LjcgMjYuMSAxOS45IDMyLjJsMTAwIDUwYzEwLjEgNS4xIDIyLjEgNS4xIDMyLjIgMGwxMDMuOS01MiAxMDMuOSA1MmMxMC4xIDUuMSAyMi4xIDUuMSAzMi4yIDBsMTAwLTUwYzEyLjItNi4xIDE5LjktMTguNiAxOS45LTMyLjJWMjgzLjljMC0xNS05LjMtMjguNC0yMy40LTMzLjd6TTM1OCAyMTQuOGwtODUgMzEuOXYtNjguMmw4NS0zN3Y3My4zek0xNTQgMTA0LjFsMTAyLTM4LjIgMTAyIDM4LjJ2LjZsLTEwMiA0MS40LTEwMi00MS40di0uNnptODQgMjkxLjFsLTg1IDQyLjV2LTc5LjFsODUtMzguOHY3NS40em0wLTExMmwtMTAyIDQxLjQtMTAyLTQxLjR2LS42bDEwMi0zOC4yIDEwMiAzOC4ydi42em0yNDAgMTEybC04NSA0Mi41di03OS4xbDg1LTM4Ljh2NzUuNHptMC0xMTJsLTEwMiA0MS40LTEwMi00MS40di0uNmwxMDItMzguMiAxMDIgMzguMnYuNnoiPjwvcGF0aD48L3N2Zz4K)](https://docs.rs/aubio-sys)
[![GPL-3.0](https://img.shields.io/badge/License-GPL--3.0-brightgreen.svg?style=for-the-badge)](https://opensource.org/licenses/GPL-3.0)
[![CI](https://img.shields.io/github/workflow/status/katyo/aubio-rs/Rust?style=for-the-badge&logo=github-actions&logoColor=white)](https://github.com/katyo/aubio-rs/actions?query=workflow%3ARust)

This crate provides generated unsafe Rust bindings to [_aubio_](https://github.com/aubio/aubio) C library.

Probably this isn't that you really need. See [safe bindings](https://crates.io/crates/aubio-rs).
 */

#![allow(
    non_upper_case_globals,
    non_camel_case_types,
    non_snake_case,
    clippy::redundant_static_lifetimes // TODO: Remove later when bindgen resolve this issue
)]
#![cfg_attr(test, allow(deref_nullptr))]

#[cfg(feature = "bindgen")]
include!(concat!(env!("OUT_DIR"), "/bindings.rs"));

#[cfg(not(feature = "bindgen"))]
include!(concat!("bindings/", env!("AUBIO_BINDINGS")));
