/* automatically generated by rust-bindgen 0.58.1 */

pub const AUBIO_SMPL_FMT: &'static [u8; 4usize] = b"%lf\0";
pub const AUBIO_LSMP_FMT: &'static [u8; 4usize] = b"%Lf\0";
pub type smpl_t = f64;
pub type lsmp_t = f64;
#[doc = " unsigned integer"]
pub type uint_t = ::std::os::raw::c_uint;
#[doc = " signed integer"]
pub type sint_t = ::std::os::raw::c_int;
#[doc = " character"]
pub type char_t = ::std::os::raw::c_char;
#[doc = " Buffer for real data"]
#[doc = ""]
#[doc = "Vector of real-valued data"]
#[doc = ""]
#[doc = "::fvec_t is is the structure used to store vector of real-valued data, ::smpl_t ."]
#[doc = ""]
#[doc = "\\code"]
#[doc = ""]
#[doc = "uint_t buffer_size = 1024;"]
#[doc = ""]
#[doc = "fvec_t * input = new_fvec (buffer_size);"]
#[doc = ""]
#[doc = "input->data[23] = 2.;"]
#[doc = ""]
#[doc = "mean = fvec_mean(a_vector);"]
#[doc = ""]
#[doc = "del_fvec(a_vector);"]
#[doc = ""]
#[doc = "\\endcode"]
#[doc = ""]
#[doc = "See `examples/` and `tests/src` directories for more examples."]
#[doc = ""]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fvec_t {
    #[doc = "< length of buffer"]
    pub length: uint_t,
    #[doc = "< data vector of length ::fvec_t.length"]
    pub data: *mut smpl_t,
}
#[test]
fn bindgen_test_layout_fvec_t() {
    assert_eq!(
        ::std::mem::size_of::<fvec_t>(),
        16usize,
        concat!("Size of: ", stringify!(fvec_t))
    );
    assert_eq!(
        ::std::mem::align_of::<fvec_t>(),
        8usize,
        concat!("Alignment of ", stringify!(fvec_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fvec_t>())).length as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fvec_t),
            "::",
            stringify!(length)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fvec_t>())).data as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(fvec_t),
            "::",
            stringify!(data)
        )
    );
}
extern "C" {
    #[doc = " fvec_t buffer creation function"]
    #[doc = ""]
    #[doc = "\\param length the length of the buffer to create"]
    pub fn new_fvec(length: uint_t) -> *mut fvec_t;
}
extern "C" {
    #[doc = " fvec_t buffer deletion function"]
    #[doc = ""]
    #[doc = "\\param s buffer to delete as returned by new_fvec()"]
    pub fn del_fvec(s: *mut fvec_t);
}
extern "C" {
    #[doc = " read sample value in a buffer"]
    #[doc = ""]
    #[doc = "\\param s vector to read from"]
    #[doc = "\\param position sample position to read from"]
    pub fn fvec_get_sample(s: *const fvec_t, position: uint_t) -> smpl_t;
}
extern "C" {
    #[doc = " write sample value in a buffer"]
    #[doc = ""]
    #[doc = "\\param s vector to write to"]
    #[doc = "\\param data value to write in s->data[position]"]
    #[doc = "\\param position sample position to write to"]
    pub fn fvec_set_sample(s: *mut fvec_t, data: smpl_t, position: uint_t);
}
extern "C" {
    #[doc = " read data from a buffer"]
    #[doc = ""]
    #[doc = "\\param s vector to read from"]
    pub fn fvec_get_data(s: *const fvec_t) -> *mut smpl_t;
}
extern "C" {
    #[doc = " print out fvec data"]
    #[doc = ""]
    #[doc = "\\param s vector to print out"]
    pub fn fvec_print(s: *const fvec_t);
}
extern "C" {
    #[doc = " set all elements to a given value"]
    #[doc = ""]
    #[doc = "\\param s vector to modify"]
    #[doc = "\\param val value to set elements to"]
    pub fn fvec_set_all(s: *mut fvec_t, val: smpl_t);
}
extern "C" {
    #[doc = " set all elements to zero"]
    #[doc = ""]
    #[doc = "\\param s vector to modify"]
    pub fn fvec_zeros(s: *mut fvec_t);
}
extern "C" {
    #[doc = " set all elements to ones"]
    #[doc = ""]
    #[doc = "\\param s vector to modify"]
    pub fn fvec_ones(s: *mut fvec_t);
}
extern "C" {
    #[doc = " revert order of vector elements"]
    #[doc = ""]
    #[doc = "\\param s vector to revert"]
    pub fn fvec_rev(s: *mut fvec_t);
}
extern "C" {
    #[doc = " apply weight to vector"]
    #[doc = ""]
    #[doc = "If the weight vector is longer than s, only the first elements are used. If"]
    #[doc = "the weight vector is shorter than s, the last elements of s are not weighted."]
    #[doc = ""]
    #[doc = "\\param s vector to weight"]
    #[doc = "\\param weight weighting coefficients"]
    pub fn fvec_weight(s: *mut fvec_t, weight: *const fvec_t);
}
extern "C" {
    #[doc = " make a copy of a vector"]
    #[doc = ""]
    #[doc = "\\param s source vector"]
    #[doc = "\\param t vector to copy to"]
    pub fn fvec_copy(s: *const fvec_t, t: *mut fvec_t);
}
extern "C" {
    #[doc = " make a copy of a vector, applying weights to each element"]
    #[doc = ""]
    #[doc = "\\param in input vector"]
    #[doc = "\\param weight weights vector"]
    #[doc = "\\param out output vector"]
    pub fn fvec_weighted_copy(in_: *const fvec_t, weight: *const fvec_t, out: *mut fvec_t);
}
#[doc = " Vector of real-valued phase and spectrum data"]
#[doc = ""]
#[doc = "\\code"]
#[doc = ""]
#[doc = "uint_t buffer_size = 1024;"]
#[doc = ""]
#[doc = "cvec_t * input = new_cvec (buffer_size);"]
#[doc = ""]
#[doc = "input->norm[23] = 2.;"]
#[doc = "input->phas[23] = M_PI;"]
#[doc = ""]
#[doc = "mean = cvec_mean(input);"]
#[doc = ""]
#[doc = "del_cvec (input);"]
#[doc = ""]
#[doc = "\\endcode"]
#[doc = ""]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cvec_t {
    #[doc = "< length of buffer = (requested length)/2 + 1"]
    pub length: uint_t,
    #[doc = "< norm array of size ::cvec_t.length"]
    pub norm: *mut smpl_t,
    #[doc = "< phase array of size ::cvec_t.length"]
    pub phas: *mut smpl_t,
}
#[test]
fn bindgen_test_layout_cvec_t() {
    assert_eq!(
        ::std::mem::size_of::<cvec_t>(),
        24usize,
        concat!("Size of: ", stringify!(cvec_t))
    );
    assert_eq!(
        ::std::mem::align_of::<cvec_t>(),
        8usize,
        concat!("Alignment of ", stringify!(cvec_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cvec_t>())).length as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cvec_t),
            "::",
            stringify!(length)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cvec_t>())).norm as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(cvec_t),
            "::",
            stringify!(norm)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cvec_t>())).phas as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(cvec_t),
            "::",
            stringify!(phas)
        )
    );
}
extern "C" {
    #[doc = " cvec_t buffer creation function"]
    #[doc = ""]
    #[doc = "This function creates a cvec_t structure holding two arrays of size"]
    #[doc = "[length/2+1], corresponding to the norm and phase values of the"]
    #[doc = "spectral frame. The length stored in the structure is the actual size of both"]
    #[doc = "arrays, not the length of the complex and symmetrical vector, specified as"]
    #[doc = "creation argument."]
    #[doc = ""]
    #[doc = "\\param length the length of the buffer to create"]
    pub fn new_cvec(length: uint_t) -> *mut cvec_t;
}
extern "C" {
    #[doc = " cvec_t buffer deletion function"]
    #[doc = ""]
    #[doc = "\\param s buffer to delete as returned by new_cvec()"]
    pub fn del_cvec(s: *mut cvec_t);
}
extern "C" {
    #[doc = " write norm value in a complex buffer"]
    #[doc = ""]
    #[doc = "This is equivalent to:"]
    #[doc = "\\code"]
    #[doc = "s->norm[position] = val;"]
    #[doc = "\\endcode"]
    #[doc = ""]
    #[doc = "\\param s vector to write to"]
    #[doc = "\\param val norm value to write in s->norm[position]"]
    #[doc = "\\param position sample position to write to"]
    pub fn cvec_norm_set_sample(s: *mut cvec_t, val: smpl_t, position: uint_t);
}
extern "C" {
    #[doc = " write phase value in a complex buffer"]
    #[doc = ""]
    #[doc = "This is equivalent to:"]
    #[doc = "\\code"]
    #[doc = "s->phas[position] = val;"]
    #[doc = "\\endcode"]
    #[doc = ""]
    #[doc = "\\param s vector to write to"]
    #[doc = "\\param val phase value to write in s->phas[position]"]
    #[doc = "\\param position sample position to write to"]
    pub fn cvec_phas_set_sample(s: *mut cvec_t, val: smpl_t, position: uint_t);
}
extern "C" {
    #[doc = " read norm value from a complex buffer"]
    #[doc = ""]
    #[doc = "This is equivalent to:"]
    #[doc = "\\code"]
    #[doc = "smpl_t foo = s->norm[position];"]
    #[doc = "\\endcode"]
    #[doc = ""]
    #[doc = "\\param s vector to read from"]
    #[doc = "\\param position sample position to read from"]
    pub fn cvec_norm_get_sample(s: *mut cvec_t, position: uint_t) -> smpl_t;
}
extern "C" {
    #[doc = " read phase value from a complex buffer"]
    #[doc = ""]
    #[doc = "This is equivalent to:"]
    #[doc = "\\code"]
    #[doc = "smpl_t foo = s->phas[position];"]
    #[doc = "\\endcode"]
    #[doc = ""]
    #[doc = "\\param s vector to read from"]
    #[doc = "\\param position sample position to read from"]
    #[doc = "\\returns the value of the sample at position"]
    pub fn cvec_phas_get_sample(s: *mut cvec_t, position: uint_t) -> smpl_t;
}
extern "C" {
    #[doc = " read norm data from a complex buffer"]
    #[doc = ""]
    #[doc = "\\code"]
    #[doc = "smpl_t *data = s->norm;"]
    #[doc = "\\endcode"]
    #[doc = ""]
    #[doc = "\\param s vector to read from"]
    pub fn cvec_norm_get_data(s: *const cvec_t) -> *mut smpl_t;
}
extern "C" {
    #[doc = " read phase data from a complex buffer"]
    #[doc = ""]
    #[doc = "This is equivalent to:"]
    #[doc = "\\code"]
    #[doc = "smpl_t *data = s->phas;"]
    #[doc = "\\endcode"]
    #[doc = ""]
    #[doc = "\\param s vector to read from"]
    pub fn cvec_phas_get_data(s: *const cvec_t) -> *mut smpl_t;
}
extern "C" {
    #[doc = " print out cvec data"]
    #[doc = ""]
    #[doc = "\\param s vector to print out"]
    pub fn cvec_print(s: *const cvec_t);
}
extern "C" {
    #[doc = " make a copy of a vector"]
    #[doc = ""]
    #[doc = "\\param s source vector"]
    #[doc = "\\param t vector to copy to"]
    pub fn cvec_copy(s: *const cvec_t, t: *mut cvec_t);
}
extern "C" {
    #[doc = " set all norm elements to a given value"]
    #[doc = ""]
    #[doc = "\\param s vector to modify"]
    #[doc = "\\param val value to set elements to"]
    pub fn cvec_norm_set_all(s: *mut cvec_t, val: smpl_t);
}
extern "C" {
    #[doc = " set all norm elements to zero"]
    #[doc = ""]
    #[doc = "\\param s vector to modify"]
    pub fn cvec_norm_zeros(s: *mut cvec_t);
}
extern "C" {
    #[doc = " set all norm elements to one"]
    #[doc = ""]
    #[doc = "\\param s vector to modify"]
    pub fn cvec_norm_ones(s: *mut cvec_t);
}
extern "C" {
    #[doc = " set all phase elements to a given value"]
    #[doc = ""]
    #[doc = "\\param s vector to modify"]
    #[doc = "\\param val value to set elements to"]
    pub fn cvec_phas_set_all(s: *mut cvec_t, val: smpl_t);
}
extern "C" {
    #[doc = " set all phase elements to zero"]
    #[doc = ""]
    #[doc = "\\param s vector to modify"]
    pub fn cvec_phas_zeros(s: *mut cvec_t);
}
extern "C" {
    #[doc = " set all phase elements to one"]
    #[doc = ""]
    #[doc = "\\param s vector to modify"]
    pub fn cvec_phas_ones(s: *mut cvec_t);
}
extern "C" {
    #[doc = " set all norm and phas elements to zero"]
    #[doc = ""]
    #[doc = "\\param s vector to modify"]
    pub fn cvec_zeros(s: *mut cvec_t);
}
extern "C" {
    #[doc = " take logarithmic magnitude"]
    #[doc = ""]
    #[doc = "\\param s input cvec to compress"]
    #[doc = "\\param lambda value to use for normalisation"]
    #[doc = ""]
    #[doc = "\\f$ S_k = log( \\lambda * S_k + 1 ) \\f$"]
    pub fn cvec_logmag(s: *mut cvec_t, lambda: smpl_t);
}
#[doc = " Buffer for real data in double precision"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lvec_t {
    #[doc = "< length of buffer"]
    pub length: uint_t,
    #[doc = "< data array of size [length]"]
    pub data: *mut lsmp_t,
}
#[test]
fn bindgen_test_layout_lvec_t() {
    assert_eq!(
        ::std::mem::size_of::<lvec_t>(),
        16usize,
        concat!("Size of: ", stringify!(lvec_t))
    );
    assert_eq!(
        ::std::mem::align_of::<lvec_t>(),
        8usize,
        concat!("Alignment of ", stringify!(lvec_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<lvec_t>())).length as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lvec_t),
            "::",
            stringify!(length)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<lvec_t>())).data as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lvec_t),
            "::",
            stringify!(data)
        )
    );
}
extern "C" {
    #[doc = " lvec_t buffer creation function"]
    #[doc = ""]
    #[doc = "\\param length the length of the buffer to create"]
    pub fn new_lvec(length: uint_t) -> *mut lvec_t;
}
extern "C" {
    #[doc = " lvec_t buffer deletion function"]
    #[doc = ""]
    #[doc = "\\param s buffer to delete as returned by new_lvec()"]
    pub fn del_lvec(s: *mut lvec_t);
}
extern "C" {
    #[doc = " read sample value in a buffer"]
    #[doc = ""]
    #[doc = "\\param s vector to read from"]
    #[doc = "\\param position sample position to read from"]
    pub fn lvec_get_sample(s: *mut lvec_t, position: uint_t) -> lsmp_t;
}
extern "C" {
    #[doc = " write sample value in a buffer"]
    #[doc = ""]
    #[doc = "\\param s vector to write to"]
    #[doc = "\\param data value to write in s->data[position]"]
    #[doc = "\\param position sample position to write to"]
    pub fn lvec_set_sample(s: *mut lvec_t, data: lsmp_t, position: uint_t);
}
extern "C" {
    #[doc = " read data from a buffer"]
    #[doc = ""]
    #[doc = "\\param s vector to read from"]
    pub fn lvec_get_data(s: *const lvec_t) -> *mut lsmp_t;
}
extern "C" {
    #[doc = " print out lvec data"]
    #[doc = ""]
    #[doc = "\\param s vector to print out"]
    pub fn lvec_print(s: *const lvec_t);
}
extern "C" {
    #[doc = " set all elements to a given value"]
    #[doc = ""]
    #[doc = "\\param s vector to modify"]
    #[doc = "\\param val value to set elements to"]
    pub fn lvec_set_all(s: *mut lvec_t, val: smpl_t);
}
extern "C" {
    #[doc = " set all elements to zero"]
    #[doc = ""]
    #[doc = "\\param s vector to modify"]
    pub fn lvec_zeros(s: *mut lvec_t);
}
extern "C" {
    #[doc = " set all elements to ones"]
    #[doc = ""]
    #[doc = "\\param s vector to modify"]
    pub fn lvec_ones(s: *mut lvec_t);
}
#[doc = " Buffer for real data"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fmat_t {
    #[doc = "< length of matrix"]
    pub length: uint_t,
    #[doc = "< height of matrix"]
    pub height: uint_t,
    #[doc = "< data array of size [length] * [height]"]
    pub data: *mut *mut smpl_t,
}
#[test]
fn bindgen_test_layout_fmat_t() {
    assert_eq!(
        ::std::mem::size_of::<fmat_t>(),
        16usize,
        concat!("Size of: ", stringify!(fmat_t))
    );
    assert_eq!(
        ::std::mem::align_of::<fmat_t>(),
        8usize,
        concat!("Alignment of ", stringify!(fmat_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fmat_t>())).length as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fmat_t),
            "::",
            stringify!(length)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fmat_t>())).height as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(fmat_t),
            "::",
            stringify!(height)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fmat_t>())).data as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(fmat_t),
            "::",
            stringify!(data)
        )
    );
}
extern "C" {
    #[doc = " fmat_t buffer creation function"]
    #[doc = ""]
    #[doc = "\\param length the length of the matrix to create"]
    #[doc = "\\param height the height of the matrix to create"]
    pub fn new_fmat(height: uint_t, length: uint_t) -> *mut fmat_t;
}
extern "C" {
    #[doc = " fmat_t buffer deletion function"]
    #[doc = ""]
    #[doc = "\\param s buffer to delete as returned by new_fmat()"]
    pub fn del_fmat(s: *mut fmat_t);
}
extern "C" {
    #[doc = " read sample value in a buffer"]
    #[doc = ""]
    #[doc = "\\param s vector to read from"]
    #[doc = "\\param channel channel to read from"]
    #[doc = "\\param position sample position to read from"]
    pub fn fmat_get_sample(s: *const fmat_t, channel: uint_t, position: uint_t) -> smpl_t;
}
extern "C" {
    #[doc = " write sample value in a buffer"]
    #[doc = ""]
    #[doc = "\\param s vector to write to"]
    #[doc = "\\param data value to write in s->data[channel][position]"]
    #[doc = "\\param channel channel to write to"]
    #[doc = "\\param position sample position to write to"]
    pub fn fmat_set_sample(s: *mut fmat_t, data: smpl_t, channel: uint_t, position: uint_t);
}
extern "C" {
    #[doc = " read channel vector from a buffer"]
    #[doc = ""]
    #[doc = "\\param s vector to read from"]
    #[doc = "\\param channel channel to read from"]
    #[doc = "\\param output ::fvec_t to output to"]
    pub fn fmat_get_channel(s: *const fmat_t, channel: uint_t, output: *mut fvec_t);
}
extern "C" {
    #[doc = " get vector buffer from an fmat data"]
    #[doc = ""]
    #[doc = "\\param s vector to read from"]
    #[doc = "\\param channel channel to read from"]
    pub fn fmat_get_channel_data(s: *const fmat_t, channel: uint_t) -> *mut smpl_t;
}
extern "C" {
    #[doc = " read data from a buffer"]
    #[doc = ""]
    #[doc = "\\param s vector to read from"]
    pub fn fmat_get_data(s: *const fmat_t) -> *mut *mut smpl_t;
}
extern "C" {
    #[doc = " print out fmat data"]
    #[doc = ""]
    #[doc = "\\param s vector to print out"]
    pub fn fmat_print(s: *const fmat_t);
}
extern "C" {
    #[doc = " set all elements to a given value"]
    #[doc = ""]
    #[doc = "\\param s vector to modify"]
    #[doc = "\\param val value to set elements to"]
    pub fn fmat_set(s: *mut fmat_t, val: smpl_t);
}
extern "C" {
    #[doc = " set all elements to zero"]
    #[doc = ""]
    #[doc = "\\param s vector to modify"]
    pub fn fmat_zeros(s: *mut fmat_t);
}
extern "C" {
    #[doc = " set all elements to ones"]
    #[doc = ""]
    #[doc = "\\param s vector to modify"]
    pub fn fmat_ones(s: *mut fmat_t);
}
extern "C" {
    #[doc = " revert order of vector elements"]
    #[doc = ""]
    #[doc = "\\param s vector to revert"]
    pub fn fmat_rev(s: *mut fmat_t);
}
extern "C" {
    #[doc = " apply weight to vector"]
    #[doc = ""]
    #[doc = "If the weight vector is longer than s, only the first elements are used. If"]
    #[doc = "the weight vector is shorter than s, the last elements of s are not weighted."]
    #[doc = ""]
    #[doc = "\\param s vector to weight"]
    #[doc = "\\param weight weighting coefficients"]
    pub fn fmat_weight(s: *mut fmat_t, weight: *const fmat_t);
}
extern "C" {
    #[doc = " make a copy of a matrix"]
    #[doc = ""]
    #[doc = "\\param s source vector"]
    #[doc = "\\param t vector to copy to"]
    pub fn fmat_copy(s: *const fmat_t, t: *mut fmat_t);
}
extern "C" {
    #[doc = " compute the product of a matrix by a vector"]
    #[doc = ""]
    #[doc = "\\param s matrix to compute product with"]
    #[doc = "\\param scale vector to compute product with"]
    #[doc = "\\param output vector to store restults in"]
    pub fn fmat_vecmul(s: *const fmat_t, scale: *const fvec_t, output: *mut fvec_t);
}
extern "C" {
    #[doc = " create window"]
    #[doc = ""]
    #[doc = "\\param window_type type of the window to create"]
    #[doc = "\\param size length of the window to create (see fvec_set_window())"]
    pub fn new_aubio_window(window_type: *mut char_t, size: uint_t) -> *mut fvec_t;
}
extern "C" {
    #[doc = " set elements of a vector to window coefficients"]
    #[doc = ""]
    #[doc = "\\param window exsting ::fvec_t to use"]
    #[doc = "\\param window_type type of the window to create"]
    #[doc = ""]
    #[doc = "List of available window types: \"rectangle\", \"hamming\", \"hanning\","]
    #[doc = "\"hanningz\", \"blackman\", \"blackman_harris\", \"gaussian\", \"welch\", \"parzen\","]
    #[doc = "\"default\"."]
    #[doc = ""]
    #[doc = "\"default\" is equivalent to \"hanningz\"."]
    #[doc = ""]
    #[doc = "References:"]
    #[doc = ""]
    #[doc = "- <a href=\"http://en.wikipedia.org/wiki/Window_function\">Window"]
    #[doc = "function</a> on Wikipedia"]
    #[doc = "- Amalia de Götzen, Nicolas Bernardini, and Daniel Arfib. Traditional (?)"]
    #[doc = "implementations of a phase vocoder: the tricks of the trade. In Proceedings of"]
    #[doc = "the International Conference on Digital Audio Effects (DAFx-00), pages 37–44,"]
    #[doc = "Uni- versity of Verona, Italy, 2000."]
    #[doc = "(<a href=\"http://www.cs.princeton.edu/courses/archive/spr09/cos325/Bernardini.pdf\">"]
    #[doc = "pdf</a>)"]
    #[doc = ""]
    pub fn fvec_set_window(window: *mut fvec_t, window_type: *mut char_t) -> uint_t;
}
extern "C" {
    #[doc = " compute the principal argument"]
    #[doc = ""]
    #[doc = "This function maps the input phase to its corresponding value wrapped in the"]
    #[doc = "range \\f$ [-\\pi, \\pi] \\f$."]
    #[doc = ""]
    #[doc = "\\param phase unwrapped phase to map to the unit circle"]
    #[doc = ""]
    #[doc = "\\return equivalent phase wrapped to the unit circle"]
    pub fn aubio_unwrap2pi(phase: smpl_t) -> smpl_t;
}
extern "C" {
    #[doc = " convert frequency bin to midi value"]
    pub fn aubio_bintomidi(bin: smpl_t, samplerate: smpl_t, fftsize: smpl_t) -> smpl_t;
}
extern "C" {
    #[doc = " convert midi value to frequency bin"]
    pub fn aubio_miditobin(midi: smpl_t, samplerate: smpl_t, fftsize: smpl_t) -> smpl_t;
}
extern "C" {
    #[doc = " convert frequency bin to frequency (Hz)"]
    pub fn aubio_bintofreq(bin: smpl_t, samplerate: smpl_t, fftsize: smpl_t) -> smpl_t;
}
extern "C" {
    #[doc = " convert frequency (Hz) to frequency bin"]
    pub fn aubio_freqtobin(freq: smpl_t, samplerate: smpl_t, fftsize: smpl_t) -> smpl_t;
}
extern "C" {
    #[doc = " convert frequency (Hz) to mel"]
    #[doc = ""]
    #[doc = "\\param freq input frequency, in Hz"]
    #[doc = ""]
    #[doc = "\\return output mel"]
    #[doc = ""]
    #[doc = "Converts a scalar from the frequency domain to the mel scale using Slaney"]
    #[doc = "Auditory Toolbox's implementation:"]
    #[doc = ""]
    #[doc = "If \\f$ f < 1000 \\f$, \\f$ m = 3 f / 200 \\f$."]
    #[doc = ""]
    #[doc = "If \\f$ f >= 1000 \\f$, \\f$ m = 1000 + 27 \\frac{{ln}(f) - ln(1000))}"]
    #[doc = "{{ln}(6400) - ln(1000)}"]
    #[doc = "\\f$"]
    #[doc = ""]
    #[doc = "See also"]
    #[doc = "--------"]
    #[doc = ""]
    #[doc = "aubio_meltohz(), aubio_hztomel_htk()."]
    pub fn aubio_hztomel(freq: smpl_t) -> smpl_t;
}
extern "C" {
    #[doc = " convert mel to frequency (Hz)"]
    #[doc = ""]
    #[doc = "\\param mel input mel"]
    #[doc = ""]
    #[doc = "\\return output frequency, in Hz"]
    #[doc = ""]
    #[doc = "Converts a scalar from the mel scale to the frequency domain using Slaney"]
    #[doc = "Auditory Toolbox's implementation:"]
    #[doc = ""]
    #[doc = "If \\f$ f < 1000 \\f$, \\f$ f = 200 m/3 \\f$."]
    #[doc = ""]
    #[doc = "If \\f$ f \\geq 1000 \\f$, \\f$ f = 1000 + \\left(\\frac{6400}{1000}\\right)"]
    #[doc = "^{\\frac{m - 1000}{27}} \\f$"]
    #[doc = ""]
    #[doc = "See also"]
    #[doc = "--------"]
    #[doc = ""]
    #[doc = "aubio_hztomel(), aubio_meltohz_htk()."]
    #[doc = ""]
    #[doc = "References"]
    #[doc = "----------"]
    #[doc = ""]
    #[doc = "Malcolm Slaney, *Auditory Toolbox Version 2, Technical Report #1998-010*"]
    #[doc = "https://engineering.purdue.edu/~malcolm/interval/1998-010/"]
    pub fn aubio_meltohz(mel: smpl_t) -> smpl_t;
}
extern "C" {
    #[doc = " convert frequency (Hz) to mel"]
    #[doc = ""]
    #[doc = "\\param freq input frequency, in Hz"]
    #[doc = ""]
    #[doc = "\\return output mel"]
    #[doc = ""]
    #[doc = "Converts a scalar from the frequency domain to the mel scale, using the"]
    #[doc = "equation defined by O'Shaughnessy, as implemented in the HTK speech"]
    #[doc = "recognition toolkit:"]
    #[doc = ""]
    #[doc = "\\f$ m = 1127 + ln(1 + \\frac{f}{700}) \\f$"]
    #[doc = ""]
    #[doc = "See also"]
    #[doc = "--------"]
    #[doc = ""]
    #[doc = "aubio_meltohz_htk(), aubio_hztomel()."]
    #[doc = ""]
    #[doc = "References"]
    #[doc = "----------"]
    #[doc = ""]
    #[doc = "Douglas O'Shaughnessy (1987). *Speech communication: human and machine*."]
    #[doc = "Addison-Wesley. p. 150. ISBN 978-0-201-16520-3."]
    #[doc = ""]
    #[doc = "HTK Speech Recognition Toolkit: http://htk.eng.cam.ac.uk/"]
    #[doc = ""]
    pub fn aubio_hztomel_htk(freq: smpl_t) -> smpl_t;
}
extern "C" {
    #[doc = " convert mel to frequency (Hz)"]
    #[doc = ""]
    #[doc = "\\param mel input mel"]
    #[doc = ""]
    #[doc = "\\return output frequency, in Hz"]
    #[doc = ""]
    #[doc = "Converts a scalar from the mel scale to the frequency domain, using the"]
    #[doc = "equation defined by O'Shaughnessy, as implemented in the HTK speech"]
    #[doc = "recognition toolkit:"]
    #[doc = ""]
    #[doc = "\\f$ f = 700 * {e}^\\left(\\frac{f}{1127} - 1\\right) \\f$"]
    #[doc = ""]
    #[doc = "See also"]
    #[doc = "--------"]
    #[doc = ""]
    #[doc = "aubio_hztomel_htk(), aubio_meltohz()."]
    pub fn aubio_meltohz_htk(mel: smpl_t) -> smpl_t;
}
extern "C" {
    #[doc = " convert frequency (Hz) to midi value (0-128)"]
    pub fn aubio_freqtomidi(freq: smpl_t) -> smpl_t;
}
extern "C" {
    #[doc = " convert midi value (0-128) to frequency (Hz)"]
    pub fn aubio_miditofreq(midi: smpl_t) -> smpl_t;
}
extern "C" {
    #[doc = " clean up cached memory at the end of program"]
    #[doc = ""]
    #[doc = "This function should be used at the end of programs to purge all cached"]
    #[doc = "memory. So far it is only useful to clean FFTW's cache."]
    pub fn aubio_cleanup();
}
extern "C" {
    #[doc = " zero-crossing rate (ZCR)"]
    #[doc = ""]
    #[doc = "The zero-crossing rate is the number of times a signal changes sign,"]
    #[doc = "divided by the length of this signal."]
    #[doc = ""]
    #[doc = "\\param v vector to compute ZCR from"]
    #[doc = ""]
    #[doc = "\\return zero-crossing rate of v"]
    pub fn aubio_zero_crossing_rate(v: *mut fvec_t) -> smpl_t;
}
extern "C" {
    #[doc = " compute sound level on a linear scale"]
    #[doc = ""]
    #[doc = "This gives the average of the square amplitudes."]
    #[doc = ""]
    #[doc = "\\param v vector to compute level from"]
    #[doc = ""]
    #[doc = "\\return level of v"]
    pub fn aubio_level_lin(v: *const fvec_t) -> smpl_t;
}
extern "C" {
    #[doc = " compute sound pressure level (SPL) in dB"]
    #[doc = ""]
    #[doc = "This quantity is often wrongly called 'loudness'."]
    #[doc = ""]
    #[doc = "This gives ten times the log10 of the average of the square amplitudes."]
    #[doc = ""]
    #[doc = "\\param v vector to compute dB SPL from"]
    #[doc = ""]
    #[doc = "\\return level of v in dB SPL"]
    pub fn aubio_db_spl(v: *const fvec_t) -> smpl_t;
}
extern "C" {
    #[doc = " check if buffer level in dB SPL is under a given threshold"]
    #[doc = ""]
    #[doc = "\\param v vector to get level from"]
    #[doc = "\\param threshold threshold in dB SPL"]
    #[doc = ""]
    #[doc = "\\return 1 if level is under the given threshold, 0 otherwise"]
    pub fn aubio_silence_detection(v: *const fvec_t, threshold: smpl_t) -> uint_t;
}
extern "C" {
    #[doc = " get buffer level if level >= threshold, 1. otherwise"]
    #[doc = ""]
    #[doc = "\\param v vector to get level from"]
    #[doc = "\\param threshold threshold in dB SPL"]
    #[doc = ""]
    #[doc = "\\return level in dB SPL if level >= threshold, 1. otherwise"]
    pub fn aubio_level_detection(v: *const fvec_t, threshold: smpl_t) -> smpl_t;
}
extern "C" {
    #[doc = " clamp the values of a vector within the range [-abs(max), abs(max)]"]
    #[doc = ""]
    #[doc = "\\param in vector to clamp"]
    #[doc = "\\param absmax maximum value over which input vector elements should be clamped"]
    pub fn fvec_clamp(in_: *mut fvec_t, absmax: smpl_t);
}
extern "C" {
    #[doc = " compute \\f$e^x\\f$ of each vector elements"]
    #[doc = ""]
    #[doc = "\\param s vector to modify"]
    pub fn fvec_exp(s: *mut fvec_t);
}
extern "C" {
    #[doc = " compute \\f$cos(x)\\f$ of each vector elements"]
    #[doc = ""]
    #[doc = "\\param s vector to modify"]
    pub fn fvec_cos(s: *mut fvec_t);
}
extern "C" {
    #[doc = " compute \\f$sin(x)\\f$ of each vector elements"]
    #[doc = ""]
    #[doc = "\\param s vector to modify"]
    pub fn fvec_sin(s: *mut fvec_t);
}
extern "C" {
    #[doc = " compute the \\f$abs(x)\\f$ of each vector elements"]
    #[doc = ""]
    #[doc = "\\param s vector to modify"]
    pub fn fvec_abs(s: *mut fvec_t);
}
extern "C" {
    #[doc = " compute the \\f$sqrt(x)\\f$ of each vector elements"]
    #[doc = ""]
    #[doc = "\\param s vector to modify"]
    pub fn fvec_sqrt(s: *mut fvec_t);
}
extern "C" {
    #[doc = " compute the \\f$log10(x)\\f$ of each vector elements"]
    #[doc = ""]
    #[doc = "\\param s vector to modify"]
    pub fn fvec_log10(s: *mut fvec_t);
}
extern "C" {
    #[doc = " compute the \\f$log(x)\\f$ of each vector elements"]
    #[doc = ""]
    #[doc = "\\param s vector to modify"]
    pub fn fvec_log(s: *mut fvec_t);
}
extern "C" {
    #[doc = " compute the \\f$floor(x)\\f$ of each vector elements"]
    #[doc = ""]
    #[doc = "\\param s vector to modify"]
    pub fn fvec_floor(s: *mut fvec_t);
}
extern "C" {
    #[doc = " compute the \\f$ceil(x)\\f$ of each vector elements"]
    #[doc = ""]
    #[doc = "\\param s vector to modify"]
    pub fn fvec_ceil(s: *mut fvec_t);
}
extern "C" {
    #[doc = " compute the \\f$round(x)\\f$ of each vector elements"]
    #[doc = ""]
    #[doc = "\\param s vector to modify"]
    pub fn fvec_round(s: *mut fvec_t);
}
extern "C" {
    #[doc = " raise each vector elements to the power pow"]
    #[doc = ""]
    #[doc = "\\param s vector to modify"]
    #[doc = "\\param pow power to raise to"]
    pub fn fvec_pow(s: *mut fvec_t, pow: smpl_t);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _aubio_resampler_t {
    _unused: [u8; 0],
}
#[doc = " resampler object"]
pub type aubio_resampler_t = _aubio_resampler_t;
extern "C" {
    #[doc = " create resampler object"]
    #[doc = ""]
    #[doc = "\\param ratio output_sample_rate / input_sample_rate"]
    #[doc = "\\param type libsamplerate resampling type, see http://www.mega-nerd.com/SRC/api_misc.html#Converters"]
    pub fn new_aubio_resampler(ratio: smpl_t, type_: uint_t) -> *mut aubio_resampler_t;
}
extern "C" {
    #[doc = " delete resampler object"]
    pub fn del_aubio_resampler(s: *mut aubio_resampler_t);
}
extern "C" {
    #[doc = " resample input in output"]
    #[doc = ""]
    #[doc = "\\param s resampler object"]
    #[doc = "\\param input input buffer of size N"]
    #[doc = "\\param output output buffer of size N*ratio"]
    pub fn aubio_resampler_do(s: *mut aubio_resampler_t, input: *const fvec_t, output: *mut fvec_t);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _aubio_filter_t {
    _unused: [u8; 0],
}
#[doc = " Digital filter"]
pub type aubio_filter_t = _aubio_filter_t;
extern "C" {
    #[doc = " filter input vector (in-place)"]
    #[doc = ""]
    #[doc = "\\param f filter object as returned by new_aubio_filter()"]
    #[doc = "\\param in input vector to filter"]
    pub fn aubio_filter_do(f: *mut aubio_filter_t, in_: *mut fvec_t);
}
extern "C" {
    #[doc = " filter input vector (out-of-place)"]
    #[doc = ""]
    #[doc = "\\param f filter object as returned by new_aubio_filter()"]
    #[doc = "\\param in input vector to filter"]
    #[doc = "\\param out output vector to store filtered input"]
    pub fn aubio_filter_do_outplace(f: *mut aubio_filter_t, in_: *const fvec_t, out: *mut fvec_t);
}
extern "C" {
    #[doc = " filter input vector forward and backward"]
    #[doc = ""]
    #[doc = "\\param f ::aubio_filter_t object as returned by new_aubio_filter()"]
    #[doc = "\\param in ::fvec_t input vector to filter"]
    #[doc = "\\param tmp memory space to use for computation"]
    pub fn aubio_filter_do_filtfilt(f: *mut aubio_filter_t, in_: *mut fvec_t, tmp: *mut fvec_t);
}
extern "C" {
    #[doc = " returns a pointer to feedback coefficients \\f$ a_i \\f$"]
    #[doc = ""]
    #[doc = "\\param f filter object to get parameters from"]
    #[doc = ""]
    #[doc = "\\return a pointer to the \\f$ a_0 ... a_i ... a_P \\f$ coefficients"]
    pub fn aubio_filter_get_feedback(f: *const aubio_filter_t) -> *mut lvec_t;
}
extern "C" {
    #[doc = " returns a pointer to feedforward coefficients \\f$ b_i \\f$"]
    #[doc = ""]
    #[doc = "\\param f filter object to get coefficients from"]
    #[doc = ""]
    #[doc = "\\return a pointer to the \\f$ b_0 ... b_i ... b_P \\f$ coefficients"]
    pub fn aubio_filter_get_feedforward(f: *const aubio_filter_t) -> *mut lvec_t;
}
extern "C" {
    #[doc = " get order of the filter"]
    #[doc = ""]
    #[doc = "\\param f filter to get order from"]
    #[doc = ""]
    #[doc = "\\return the order of the filter"]
    pub fn aubio_filter_get_order(f: *const aubio_filter_t) -> uint_t;
}
extern "C" {
    #[doc = " get sampling rate of the filter"]
    #[doc = ""]
    #[doc = "\\param f filter to get sampling rate from"]
    #[doc = ""]
    #[doc = "\\return the sampling rate of the filter, in Hz"]
    pub fn aubio_filter_get_samplerate(f: *const aubio_filter_t) -> uint_t;
}
extern "C" {
    #[doc = " get sampling rate of the filter"]
    #[doc = ""]
    #[doc = "\\param f filter to get sampling rate from"]
    #[doc = "\\param samplerate sample rate to set the filter to"]
    #[doc = ""]
    #[doc = "\\return the sampling rate of the filter, in Hz"]
    pub fn aubio_filter_set_samplerate(f: *mut aubio_filter_t, samplerate: uint_t) -> uint_t;
}
extern "C" {
    #[doc = " reset filter memory"]
    #[doc = ""]
    #[doc = "\\param f filter object as returned by new_aubio_filter()"]
    pub fn aubio_filter_do_reset(f: *mut aubio_filter_t);
}
extern "C" {
    #[doc = " create new filter object"]
    #[doc = ""]
    #[doc = "This function creates a new ::aubio_filter_t object, given the order of the"]
    #[doc = "filter."]
    #[doc = ""]
    #[doc = "\\param order order of the filter (number of coefficients)"]
    #[doc = ""]
    #[doc = "\\return the newly created filter object"]
    pub fn new_aubio_filter(order: uint_t) -> *mut aubio_filter_t;
}
extern "C" {
    #[doc = " delete a filter object"]
    #[doc = ""]
    #[doc = "\\param f filter object to delete"]
    pub fn del_aubio_filter(f: *mut aubio_filter_t);
}
extern "C" {
    #[doc = " set coefficients of a biquad filter"]
    #[doc = ""]
    #[doc = "\\param f filter object as returned by new_aubio_filter()"]
    #[doc = "\\param b0 forward filter coefficient"]
    #[doc = "\\param b1 forward filter coefficient"]
    #[doc = "\\param b2 forward filter coefficient"]
    #[doc = "\\param a1 feedback filter coefficient"]
    #[doc = "\\param a2 feedback filter coefficient"]
    pub fn aubio_filter_set_biquad(
        f: *mut aubio_filter_t,
        b0: lsmp_t,
        b1: lsmp_t,
        b2: lsmp_t,
        a1: lsmp_t,
        a2: lsmp_t,
    ) -> uint_t;
}
extern "C" {
    #[doc = " create biquad filter with `b0`, `b1`, `b2`, `a1`, `a2` coeffs"]
    #[doc = ""]
    #[doc = "\\param b0 forward filter coefficient"]
    #[doc = "\\param b1 forward filter coefficient"]
    #[doc = "\\param b2 forward filter coefficient"]
    #[doc = "\\param a1 feedback filter coefficient"]
    #[doc = "\\param a2 feedback filter coefficient"]
    pub fn new_aubio_filter_biquad(
        b0: lsmp_t,
        b1: lsmp_t,
        b2: lsmp_t,
        a1: lsmp_t,
        a2: lsmp_t,
    ) -> *mut aubio_filter_t;
}
extern "C" {
    #[doc = " create new A-design filter"]
    #[doc = ""]
    #[doc = "\\param samplerate sampling frequency of the signal to filter. Should be one of"]
    #[doc = "8000, 11025, 16000, 22050, 24000, 32000, 44100, 48000, 88200, 96000, and"]
    #[doc = "192000 Hz"]
    #[doc = ""]
    #[doc = "\\return a new filter object"]
    pub fn new_aubio_filter_a_weighting(samplerate: uint_t) -> *mut aubio_filter_t;
}
extern "C" {
    #[doc = " set feedback and feedforward coefficients of a A-weighting filter"]
    #[doc = ""]
    #[doc = "\\param f filter object to get coefficients from"]
    #[doc = "\\param samplerate sampling frequency of the signal to filter. Should be one of"]
    #[doc = "8000, 11025, 16000, 22050, 24000, 32000, 44100, 48000, 88200, 96000, and"]
    #[doc = "192000 Hz"]
    pub fn aubio_filter_set_a_weighting(f: *mut aubio_filter_t, samplerate: uint_t) -> uint_t;
}
extern "C" {
    #[doc = " create new C-design filter"]
    #[doc = ""]
    #[doc = "\\param samplerate sampling frequency of the signal to filter. Should be one of"]
    #[doc = "8000, 11025, 16000, 22050, 24000, 32000, 44100, 48000, 88200, 96000, and"]
    #[doc = "192000 Hz"]
    #[doc = ""]
    #[doc = "\\return a new filter object"]
    pub fn new_aubio_filter_c_weighting(samplerate: uint_t) -> *mut aubio_filter_t;
}
extern "C" {
    #[doc = " set feedback and feedforward coefficients of a C-weighting filter"]
    #[doc = ""]
    #[doc = "\\param f filter object to get coefficients from"]
    #[doc = "\\param samplerate sampling frequency of the signal to filter. Should be one of"]
    #[doc = "8000, 11025, 16000, 22050, 24000, 32000, 44100, 48000, 88200, 96000, and"]
    #[doc = "192000 Hz"]
    pub fn aubio_filter_set_c_weighting(f: *mut aubio_filter_t, samplerate: uint_t) -> uint_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _aubio_fft_t {
    _unused: [u8; 0],
}
#[doc = " FFT object"]
#[doc = ""]
#[doc = "This object computes forward and backward FFTs."]
pub type aubio_fft_t = _aubio_fft_t;
extern "C" {
    #[doc = " create new FFT computation object"]
    #[doc = ""]
    #[doc = "\\param size length of the FFT"]
    pub fn new_aubio_fft(size: uint_t) -> *mut aubio_fft_t;
}
extern "C" {
    #[doc = " delete FFT object"]
    #[doc = ""]
    #[doc = "\\param s fft object as returned by new_aubio_fft"]
    pub fn del_aubio_fft(s: *mut aubio_fft_t);
}
extern "C" {
    #[doc = " compute forward FFT"]
    #[doc = ""]
    #[doc = "\\param s fft object as returned by new_aubio_fft"]
    #[doc = "\\param input input signal"]
    #[doc = "\\param spectrum output spectrum"]
    pub fn aubio_fft_do(s: *mut aubio_fft_t, input: *const fvec_t, spectrum: *mut cvec_t);
}
extern "C" {
    #[doc = " compute backward (inverse) FFT"]
    #[doc = ""]
    #[doc = "\\param s fft object as returned by new_aubio_fft"]
    #[doc = "\\param spectrum input spectrum"]
    #[doc = "\\param output output signal"]
    pub fn aubio_fft_rdo(s: *mut aubio_fft_t, spectrum: *const cvec_t, output: *mut fvec_t);
}
extern "C" {
    #[doc = " compute forward FFT"]
    #[doc = ""]
    #[doc = "\\param s fft object as returned by new_aubio_fft"]
    #[doc = "\\param input real input signal"]
    #[doc = "\\param compspec complex output fft real/imag"]
    pub fn aubio_fft_do_complex(s: *mut aubio_fft_t, input: *const fvec_t, compspec: *mut fvec_t);
}
extern "C" {
    #[doc = " compute backward (inverse) FFT from real/imag"]
    #[doc = ""]
    #[doc = "\\param s fft object as returned by new_aubio_fft"]
    #[doc = "\\param compspec real/imag input fft array"]
    #[doc = "\\param output real output array"]
    pub fn aubio_fft_rdo_complex(s: *mut aubio_fft_t, compspec: *const fvec_t, output: *mut fvec_t);
}
extern "C" {
    #[doc = " convert real/imag spectrum to norm/phas spectrum"]
    #[doc = ""]
    #[doc = "\\param compspec real/imag input fft array"]
    #[doc = "\\param spectrum cvec norm/phas output array"]
    pub fn aubio_fft_get_spectrum(compspec: *const fvec_t, spectrum: *mut cvec_t);
}
extern "C" {
    #[doc = " convert real/imag spectrum to norm/phas spectrum"]
    #[doc = ""]
    #[doc = "\\param compspec real/imag input fft array"]
    #[doc = "\\param spectrum cvec norm/phas output array"]
    pub fn aubio_fft_get_realimag(spectrum: *const cvec_t, compspec: *mut fvec_t);
}
extern "C" {
    #[doc = " compute phas spectrum from real/imag parts"]
    #[doc = ""]
    #[doc = "\\param compspec real/imag input fft array"]
    #[doc = "\\param spectrum cvec norm/phas output array"]
    pub fn aubio_fft_get_phas(compspec: *const fvec_t, spectrum: *mut cvec_t);
}
extern "C" {
    #[doc = " compute imaginary part from the norm/phas cvec"]
    #[doc = ""]
    #[doc = "\\param spectrum norm/phas input array"]
    #[doc = "\\param compspec real/imag output fft array"]
    pub fn aubio_fft_get_imag(spectrum: *const cvec_t, compspec: *mut fvec_t);
}
extern "C" {
    #[doc = " compute norm component from real/imag parts"]
    #[doc = ""]
    #[doc = "\\param compspec real/imag input fft array"]
    #[doc = "\\param spectrum cvec norm/phas output array"]
    pub fn aubio_fft_get_norm(compspec: *const fvec_t, spectrum: *mut cvec_t);
}
extern "C" {
    #[doc = " compute real part from norm/phas components"]
    #[doc = ""]
    #[doc = "\\param spectrum norm/phas input array"]
    #[doc = "\\param compspec real/imag output fft array"]
    pub fn aubio_fft_get_real(spectrum: *const cvec_t, compspec: *mut fvec_t);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _aubio_dct_t {
    _unused: [u8; 0],
}
#[doc = " DCT object"]
#[doc = ""]
#[doc = "This object computes forward and backward DCT type 2 with orthonormal"]
#[doc = "scaling."]
pub type aubio_dct_t = _aubio_dct_t;
extern "C" {
    #[doc = " create new DCT computation object"]
    #[doc = ""]
    #[doc = "\\param size length of the DCT"]
    pub fn new_aubio_dct(size: uint_t) -> *mut aubio_dct_t;
}
extern "C" {
    #[doc = " compute forward DCT"]
    #[doc = ""]
    #[doc = "\\param s dct object as returned by new_aubio_dct"]
    #[doc = "\\param input input signal"]
    #[doc = "\\param dct_output transformed input array"]
    pub fn aubio_dct_do(s: *mut aubio_dct_t, input: *const fvec_t, dct_output: *mut fvec_t);
}
extern "C" {
    #[doc = " compute backward DCT"]
    #[doc = ""]
    #[doc = "\\param s dct object as returned by new_aubio_dct"]
    #[doc = "\\param input input signal"]
    #[doc = "\\param idct_output transformed input array"]
    pub fn aubio_dct_rdo(s: *mut aubio_dct_t, input: *const fvec_t, idct_output: *mut fvec_t);
}
extern "C" {
    #[doc = " delete DCT object"]
    #[doc = ""]
    #[doc = "\\param s dct object as returned by new_aubio_dct"]
    pub fn del_aubio_dct(s: *mut aubio_dct_t);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _aubio_pvoc_t {
    _unused: [u8; 0],
}
#[doc = " phasevocoder object"]
pub type aubio_pvoc_t = _aubio_pvoc_t;
extern "C" {
    #[doc = " create phase vocoder object"]
    #[doc = ""]
    #[doc = "\\param win_s size of analysis buffer (and length the FFT transform)"]
    #[doc = "\\param hop_s step size between two consecutive analysis"]
    pub fn new_aubio_pvoc(win_s: uint_t, hop_s: uint_t) -> *mut aubio_pvoc_t;
}
extern "C" {
    #[doc = " delete phase vocoder object"]
    #[doc = ""]
    #[doc = "\\param pv phase vocoder object as returned by new_aubio_pvoc"]
    pub fn del_aubio_pvoc(pv: *mut aubio_pvoc_t);
}
extern "C" {
    #[doc = " compute spectral frame"]
    #[doc = ""]
    #[doc = "This function accepts an input vector of size [hop_s]. The"]
    #[doc = "analysis buffer is rotated and filled with the new data. After windowing of"]
    #[doc = "this signal window, the Fourier transform is computed and returned in"]
    #[doc = "fftgrain as two vectors, magnitude and phase."]
    #[doc = ""]
    #[doc = "\\param pv phase vocoder object as returned by new_aubio_pvoc"]
    #[doc = "\\param in new input signal (hop_s long)"]
    #[doc = "\\param fftgrain output spectral frame"]
    pub fn aubio_pvoc_do(pv: *mut aubio_pvoc_t, in_: *const fvec_t, fftgrain: *mut cvec_t);
}
extern "C" {
    #[doc = " compute signal from spectral frame"]
    #[doc = ""]
    #[doc = "This function takes an input spectral frame fftgrain of size"]
    #[doc = "[buf_s] and computes its inverse Fourier transform. Overlap-add"]
    #[doc = "synthesis is then computed using the previously synthetised frames, and the"]
    #[doc = "output stored in out."]
    #[doc = ""]
    #[doc = "\\param pv phase vocoder object as returned by new_aubio_pvoc"]
    #[doc = "\\param fftgrain input spectral frame"]
    #[doc = "\\param out output signal (hop_s long)"]
    pub fn aubio_pvoc_rdo(pv: *mut aubio_pvoc_t, fftgrain: *mut cvec_t, out: *mut fvec_t);
}
extern "C" {
    #[doc = " get window size"]
    #[doc = ""]
    #[doc = "\\param pv phase vocoder to get the window size from"]
    pub fn aubio_pvoc_get_win(pv: *mut aubio_pvoc_t) -> uint_t;
}
extern "C" {
    #[doc = " get hop size"]
    #[doc = ""]
    #[doc = "\\param pv phase vocoder to get the hop size from"]
    pub fn aubio_pvoc_get_hop(pv: *mut aubio_pvoc_t) -> uint_t;
}
extern "C" {
    #[doc = " set window type"]
    #[doc = ""]
    #[doc = "\\param pv phase vocoder to set the window type"]
    #[doc = "\\param window_type a string representing a window"]
    #[doc = ""]
    #[doc = "\\return 0 if successful, non-zero otherwise"]
    #[doc = ""]
    pub fn aubio_pvoc_set_window(pv: *mut aubio_pvoc_t, window_type: *const char_t) -> uint_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _aubio_filterbank_t {
    _unused: [u8; 0],
}
#[doc = " filterbank object"]
#[doc = ""]
#[doc = "This object stores a matrix of spectral filter coefficients."]
#[doc = ""]
pub type aubio_filterbank_t = _aubio_filterbank_t;
extern "C" {
    #[doc = " create filterbank object"]
    #[doc = ""]
    #[doc = "\\param n_filters number of filters to create"]
    #[doc = "\\param win_s size of analysis buffer (and length the FFT transform)"]
    pub fn new_aubio_filterbank(n_filters: uint_t, win_s: uint_t) -> *mut aubio_filterbank_t;
}
extern "C" {
    #[doc = " destroy filterbank object"]
    #[doc = ""]
    #[doc = "\\param f filterbank object, as returned by new_aubio_filterbank()"]
    pub fn del_aubio_filterbank(f: *mut aubio_filterbank_t);
}
extern "C" {
    #[doc = " compute filterbank"]
    #[doc = ""]
    #[doc = "\\param f filterbank object, as returned by new_aubio_filterbank()"]
    #[doc = "\\param in input spectrum containing an input spectrum of length `win_s`"]
    #[doc = "\\param out output vector containing the energy found in each band, `nfilt` output values"]
    pub fn aubio_filterbank_do(f: *mut aubio_filterbank_t, in_: *const cvec_t, out: *mut fvec_t);
}
extern "C" {
    #[doc = " return a pointer to the matrix object containing all filter coefficients"]
    #[doc = ""]
    #[doc = "\\param f filterbank object, as returned by new_aubio_filterbank()"]
    #[doc = ""]
    pub fn aubio_filterbank_get_coeffs(f: *const aubio_filterbank_t) -> *mut fmat_t;
}
extern "C" {
    #[doc = " copy filter coefficients to the filterbank"]
    #[doc = ""]
    #[doc = "\\param f filterbank object, as returned by new_aubio_filterbank()"]
    #[doc = "\\param filters filter bank coefficients to copy from"]
    #[doc = ""]
    pub fn aubio_filterbank_set_coeffs(
        f: *mut aubio_filterbank_t,
        filters: *const fmat_t,
    ) -> uint_t;
}
extern "C" {
    #[doc = " set norm parameter"]
    #[doc = ""]
    #[doc = "\\param f filterbank object, as returned by new_aubio_filterbank()"]
    #[doc = "\\param norm `1` to norm the filters, `0` otherwise."]
    #[doc = ""]
    #[doc = "If set to `0`, the filters will not be normalized. If set to `1`,"]
    #[doc = "each filter will be normalized to one. Defaults to `1`."]
    #[doc = ""]
    #[doc = "This function should be called *before* setting the filters with one of"]
    #[doc = "aubio_filterbank_set_triangle_bands(), aubio_filterbank_set_mel_coeffs(),"]
    #[doc = "aubio_filterbank_set_mel_coeffs_htk(), or"]
    #[doc = "aubio_filterbank_set_mel_coeffs_slaney()."]
    #[doc = ""]
    pub fn aubio_filterbank_set_norm(f: *mut aubio_filterbank_t, norm: smpl_t) -> uint_t;
}
extern "C" {
    #[doc = " get norm parameter"]
    #[doc = ""]
    #[doc = "\\param f filterbank object, as returned by new_aubio_filterbank()"]
    #[doc = "\\returns `1` if norm is set, `0` otherwise. Defaults to `1`."]
    #[doc = ""]
    pub fn aubio_filterbank_get_norm(f: *mut aubio_filterbank_t) -> smpl_t;
}
extern "C" {
    #[doc = " set power parameter"]
    #[doc = ""]
    #[doc = "\\param f filterbank object, as returned by new_aubio_filterbank()"]
    #[doc = "\\param power Raise norm of the input spectrum norm to this power before"]
    #[doc = "computing filterbank.  Defaults to `1`."]
    #[doc = ""]
    pub fn aubio_filterbank_set_power(f: *mut aubio_filterbank_t, power: smpl_t) -> uint_t;
}
extern "C" {
    #[doc = " get power parameter"]
    #[doc = ""]
    #[doc = "\\param f filterbank object, as returned by new_aubio_filterbank()"]
    #[doc = "\\return current power parameter. Defaults to `1`."]
    #[doc = ""]
    pub fn aubio_filterbank_get_power(f: *mut aubio_filterbank_t) -> smpl_t;
}
extern "C" {
    #[doc = " filterbank initialization with triangular and overlapping bands"]
    #[doc = ""]
    #[doc = "\\param fb filterbank object"]
    #[doc = "\\param freqs arbitrary array of boundary frequencies"]
    #[doc = "\\param samplerate audio sampling rate"]
    #[doc = ""]
    #[doc = "This function computes the coefficients of the filterbank based on the"]
    #[doc = "boundaries found in freqs, in Hz, and using triangular overlapping bands."]
    pub fn aubio_filterbank_set_triangle_bands(
        fb: *mut aubio_filterbank_t,
        freqs: *const fvec_t,
        samplerate: smpl_t,
    ) -> uint_t;
}
extern "C" {
    #[doc = " filterbank initialization for Mel filters using Slaney's coefficients"]
    #[doc = ""]
    #[doc = "\\param fb filterbank object"]
    #[doc = "\\param samplerate audio sampling rate, in Hz"]
    #[doc = ""]
    #[doc = "The filter coefficients are built to match exactly Malcolm Slaney's Auditory"]
    #[doc = "Toolbox implementation (see file mfcc.m). The number of filters should be 40."]
    #[doc = ""]
    #[doc = "References"]
    #[doc = "----------"]
    #[doc = ""]
    #[doc = "Malcolm Slaney, *Auditory Toolbox Version 2, Technical Report #1998-010*"]
    #[doc = "https://engineering.purdue.edu/~malcolm/interval/1998-010/"]
    pub fn aubio_filterbank_set_mel_coeffs_slaney(
        fb: *mut aubio_filterbank_t,
        samplerate: smpl_t,
    ) -> uint_t;
}
extern "C" {
    #[doc = " Mel filterbank initialization"]
    #[doc = ""]
    #[doc = "\\param fb filterbank object"]
    #[doc = "\\param samplerate audio sampling rate"]
    #[doc = "\\param fmin start frequency, in Hz"]
    #[doc = "\\param fmax end frequency, in Hz"]
    #[doc = ""]
    #[doc = "The filterbank will be initialized with bands linearly spaced in the mel"]
    #[doc = "scale, from `fmin` to `fmax`."]
    #[doc = ""]
    #[doc = "References"]
    #[doc = "----------"]
    #[doc = ""]
    #[doc = "Malcolm Slaney, *Auditory Toolbox Version 2, Technical Report #1998-010*"]
    #[doc = "https://engineering.purdue.edu/~malcolm/interval/1998-010/"]
    pub fn aubio_filterbank_set_mel_coeffs(
        fb: *mut aubio_filterbank_t,
        samplerate: smpl_t,
        fmin: smpl_t,
        fmax: smpl_t,
    ) -> uint_t;
}
extern "C" {
    #[doc = " Mel filterbank initialization"]
    #[doc = ""]
    #[doc = "\\param fb filterbank object"]
    #[doc = "\\param samplerate audio sampling rate"]
    #[doc = "\\param fmin start frequency, in Hz"]
    #[doc = "\\param fmax end frequency, in Hz"]
    #[doc = ""]
    #[doc = "The bank of filters will be initalized to to cover linearly spaced bands in"]
    #[doc = "the Htk mel scale, from `fmin` to `fmax`."]
    #[doc = ""]
    #[doc = "References"]
    #[doc = "----------"]
    #[doc = ""]
    #[doc = "Douglas O'Shaughnessy (1987). *Speech communication: human and machine*."]
    #[doc = "Addison-Wesley. p. 150. ISBN 978-0-201-16520-3."]
    #[doc = ""]
    #[doc = "HTK Speech Recognition Toolkit: http://htk.eng.cam.ac.uk/"]
    pub fn aubio_filterbank_set_mel_coeffs_htk(
        fb: *mut aubio_filterbank_t,
        samplerate: smpl_t,
        fmin: smpl_t,
        fmax: smpl_t,
    ) -> uint_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _aubio_mfcc_t {
    _unused: [u8; 0],
}
#[doc = " mfcc object"]
pub type aubio_mfcc_t = _aubio_mfcc_t;
extern "C" {
    #[doc = " create mfcc object"]
    #[doc = ""]
    #[doc = "\\param buf_size size of analysis buffer (and length the FFT transform)"]
    #[doc = "\\param samplerate audio sampling rate"]
    #[doc = "\\param n_coeffs number of desired coefficients"]
    #[doc = "\\param n_filters number of desired filters"]
    pub fn new_aubio_mfcc(
        buf_size: uint_t,
        n_filters: uint_t,
        n_coeffs: uint_t,
        samplerate: uint_t,
    ) -> *mut aubio_mfcc_t;
}
extern "C" {
    #[doc = " delete mfcc object"]
    #[doc = ""]
    #[doc = "\\param mf mfcc object as returned by new_aubio_mfcc"]
    pub fn del_aubio_mfcc(mf: *mut aubio_mfcc_t);
}
extern "C" {
    #[doc = " mfcc object processing"]
    #[doc = ""]
    #[doc = "\\param mf mfcc object as returned by new_aubio_mfcc"]
    #[doc = "\\param in input spectrum (buf_size long)"]
    #[doc = "\\param out output mel coefficients buffer (n_coeffs long)"]
    pub fn aubio_mfcc_do(mf: *mut aubio_mfcc_t, in_: *const cvec_t, out: *mut fvec_t);
}
extern "C" {
    #[doc = " set power parameter"]
    #[doc = ""]
    #[doc = "\\param mf mfcc object, as returned by new_aubio_mfcc()"]
    #[doc = "\\param power Raise norm of the input spectrum norm to this power before"]
    #[doc = "computing filterbank.  Defaults to `1`."]
    #[doc = ""]
    #[doc = "See aubio_filterbank_set_power()."]
    #[doc = ""]
    pub fn aubio_mfcc_set_power(mf: *mut aubio_mfcc_t, power: smpl_t) -> uint_t;
}
extern "C" {
    #[doc = " get power parameter"]
    #[doc = ""]
    #[doc = "\\param mf mfcc object, as returned by new_aubio_mfcc()"]
    #[doc = "\\return current power parameter. Defaults to `1`."]
    #[doc = ""]
    #[doc = "See aubio_filterbank_get_power()."]
    #[doc = ""]
    pub fn aubio_mfcc_get_power(mf: *mut aubio_mfcc_t) -> smpl_t;
}
extern "C" {
    #[doc = " set scaling parameter"]
    #[doc = ""]
    #[doc = "\\param mf mfcc object, as returned by new_aubio_mfcc()"]
    #[doc = "\\param scale Scaling value to apply."]
    #[doc = ""]
    #[doc = "Scales the output of the filterbank after taking its logarithm and before"]
    #[doc = "computing the DCT. Defaults to `1`."]
    pub fn aubio_mfcc_set_scale(mf: *mut aubio_mfcc_t, scale: smpl_t) -> uint_t;
}
extern "C" {
    #[doc = " get scaling parameter"]
    #[doc = ""]
    #[doc = "\\param mf mfcc object, as returned by new_aubio_mfcc()"]
    #[doc = "\\return current scaling parameter. Defaults to `1`."]
    #[doc = ""]
    pub fn aubio_mfcc_get_scale(mf: *mut aubio_mfcc_t) -> smpl_t;
}
extern "C" {
    #[doc = " Mel filterbank initialization"]
    #[doc = ""]
    #[doc = "\\param mf mfcc object"]
    #[doc = "\\param fmin start frequency, in Hz"]
    #[doc = "\\param fmax end frequency, in Hz"]
    #[doc = ""]
    #[doc = "The filterbank will be initialized with bands linearly spaced in the mel"]
    #[doc = "scale, from `fmin` to `fmax`."]
    #[doc = ""]
    #[doc = "See also"]
    #[doc = "--------"]
    #[doc = ""]
    #[doc = "aubio_filterbank_set_mel_coeffs()"]
    pub fn aubio_mfcc_set_mel_coeffs(mf: *mut aubio_mfcc_t, fmin: smpl_t, fmax: smpl_t) -> uint_t;
}
extern "C" {
    #[doc = " Mel filterbank initialization"]
    #[doc = ""]
    #[doc = "\\param mf mfcc object"]
    #[doc = "\\param fmin start frequency, in Hz"]
    #[doc = "\\param fmax end frequency, in Hz"]
    #[doc = ""]
    #[doc = "The bank of filters will be initalized to to cover linearly spaced bands in"]
    #[doc = "the Htk mel scale, from `fmin` to `fmax`."]
    #[doc = ""]
    #[doc = "See also"]
    #[doc = "--------"]
    #[doc = ""]
    #[doc = "aubio_filterbank_set_mel_coeffs_htk()"]
    pub fn aubio_mfcc_set_mel_coeffs_htk(
        mf: *mut aubio_mfcc_t,
        fmin: smpl_t,
        fmax: smpl_t,
    ) -> uint_t;
}
extern "C" {
    #[doc = " Mel filterbank initialization (Auditory Toolbox's parameters)"]
    #[doc = ""]
    #[doc = "\\param mf mfcc object"]
    #[doc = ""]
    #[doc = "The filter coefficients are built to match exactly Malcolm Slaney's Auditory"]
    #[doc = "Toolbox implementation. The number of filters should be 40."]
    #[doc = ""]
    #[doc = "This is the default filterbank when `mf` was created with `n_filters = 40`."]
    #[doc = ""]
    #[doc = "See also"]
    #[doc = "--------"]
    #[doc = ""]
    #[doc = "aubio_filterbank_set_mel_coeffs_slaney()"]
    pub fn aubio_mfcc_set_mel_coeffs_slaney(mf: *mut aubio_mfcc_t) -> uint_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _aubio_specdesc_t {
    _unused: [u8; 0],
}
#[doc = " spectral description structure"]
pub type aubio_specdesc_t = _aubio_specdesc_t;
extern "C" {
    #[doc = " execute spectral description function on a spectral frame"]
    #[doc = ""]
    #[doc = "Generic function to compute spectral description."]
    #[doc = ""]
    #[doc = "\\param o spectral description object as returned by new_aubio_specdesc()"]
    #[doc = "\\param fftgrain input signal spectrum as computed by aubio_pvoc_do"]
    #[doc = "\\param desc output vector (one sample long, to send to the peak picking)"]
    pub fn aubio_specdesc_do(o: *mut aubio_specdesc_t, fftgrain: *const cvec_t, desc: *mut fvec_t);
}
extern "C" {
    #[doc = " creation of a spectral description object"]
    #[doc = ""]
    #[doc = "\\param method spectral description method"]
    #[doc = "\\param buf_size length of the input spectrum frame"]
    #[doc = ""]
    #[doc = "The parameter \\p method is a string that can be any of:"]
    #[doc = ""]
    #[doc = "- onset novelty functions: `complex`, `energy`, `hfc`, `kl`, `mkl`,"]
    #[doc = "`phase`, `specdiff`, `specflux`, `wphase`,"]
    #[doc = ""]
    #[doc = "- spectral descriptors: `centroid`, `decrease`, `kurtosis`, `rolloff`,"]
    #[doc = "`skewness`, `slope`, `spread`."]
    pub fn new_aubio_specdesc(method: *const char_t, buf_size: uint_t) -> *mut aubio_specdesc_t;
}
extern "C" {
    #[doc = " deletion of a spectral descriptor"]
    #[doc = ""]
    #[doc = "\\param o spectral descriptor object as returned by new_aubio_specdesc()"]
    pub fn del_aubio_specdesc(o: *mut aubio_specdesc_t);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _aubio_spectral_whitening_t {
    _unused: [u8; 0],
}
#[doc = " spectral whitening structure"]
pub type aubio_spectral_whitening_t = _aubio_spectral_whitening_t;
extern "C" {
    #[doc = " execute spectral adaptive whitening, in-place"]
    #[doc = ""]
    #[doc = "\\param o spectral whitening object as returned by new_aubio_spectral_whitening()"]
    #[doc = "\\param fftgrain input signal spectrum as computed by aubio_pvoc_do() or aubio_fft_do()"]
    pub fn aubio_spectral_whitening_do(o: *mut aubio_spectral_whitening_t, fftgrain: *mut cvec_t);
}
extern "C" {
    #[doc = " creation of a spectral whitening object"]
    #[doc = ""]
    #[doc = "\\param buf_size window size of input grains"]
    #[doc = "\\param hop_size number of samples between two consecutive input grains"]
    #[doc = "\\param samplerate sampling rate of the input signal"]
    pub fn new_aubio_spectral_whitening(
        buf_size: uint_t,
        hop_size: uint_t,
        samplerate: uint_t,
    ) -> *mut aubio_spectral_whitening_t;
}
extern "C" {
    #[doc = " reset spectral whitening object"]
    #[doc = ""]
    #[doc = "\\param o spectral whitening object as returned by new_aubio_spectral_whitening()"]
    #[doc = ""]
    pub fn aubio_spectral_whitening_reset(o: *mut aubio_spectral_whitening_t);
}
extern "C" {
    #[doc = " set relaxation time for spectral whitening"]
    #[doc = ""]
    #[doc = "\\param o spectral whitening object as returned by new_aubio_spectral_whitening()"]
    #[doc = "\\param relax_time relaxation time in seconds between 20 and 500, defaults 250"]
    #[doc = ""]
    pub fn aubio_spectral_whitening_set_relax_time(
        o: *mut aubio_spectral_whitening_t,
        relax_time: smpl_t,
    ) -> uint_t;
}
extern "C" {
    #[doc = " get relaxation time of spectral whitening"]
    #[doc = ""]
    #[doc = "\\param o spectral whitening object as returned by new_aubio_spectral_whitening()"]
    #[doc = "\\return relaxation time in seconds"]
    pub fn aubio_spectral_whitening_get_relax_time(o: *mut aubio_spectral_whitening_t) -> smpl_t;
}
extern "C" {
    #[doc = " set floor for spectral whitening"]
    #[doc = ""]
    #[doc = "\\param o spectral whitening object as returned by new_aubio_spectral_whitening()"]
    #[doc = "\\param floor value (typically between 1.e-6 and .2, defaults to 1.e-4)"]
    #[doc = ""]
    pub fn aubio_spectral_whitening_set_floor(
        o: *mut aubio_spectral_whitening_t,
        floor: smpl_t,
    ) -> uint_t;
}
extern "C" {
    #[doc = " get floor of spectral whitening"]
    #[doc = ""]
    #[doc = "\\param o spectral whitening object as returned by new_aubio_spectral_whitening()"]
    #[doc = "\\return floor value"]
    pub fn aubio_spectral_whitening_get_floor(o: *mut aubio_spectral_whitening_t) -> smpl_t;
}
extern "C" {
    #[doc = " deletion of a spectral whitening"]
    #[doc = ""]
    #[doc = "\\param o spectral whitening object as returned by new_aubio_spectral_whitening()"]
    pub fn del_aubio_spectral_whitening(o: *mut aubio_spectral_whitening_t);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _aubio_tss_t {
    _unused: [u8; 0],
}
#[doc = " Transient / Steady-state Separation object"]
pub type aubio_tss_t = _aubio_tss_t;
extern "C" {
    #[doc = " create tss object"]
    #[doc = ""]
    #[doc = "\\param buf_size buffer size"]
    #[doc = "\\param hop_size step size"]
    pub fn new_aubio_tss(buf_size: uint_t, hop_size: uint_t) -> *mut aubio_tss_t;
}
extern "C" {
    #[doc = " delete tss object"]
    #[doc = ""]
    #[doc = "\\param o tss object as returned by new_aubio_tss()"]
    pub fn del_aubio_tss(o: *mut aubio_tss_t);
}
extern "C" {
    #[doc = " split input into transient and steady states components"]
    #[doc = ""]
    #[doc = "\\param o tss object as returned by new_aubio_tss()"]
    #[doc = "\\param input input spectral frame"]
    #[doc = "\\param trans output transient components"]
    #[doc = "\\param stead output steady state components"]
    pub fn aubio_tss_do(
        o: *mut aubio_tss_t,
        input: *const cvec_t,
        trans: *mut cvec_t,
        stead: *mut cvec_t,
    );
}
extern "C" {
    #[doc = " set transient / steady state separation threshold"]
    #[doc = ""]
    #[doc = "\\param o tss object as returned by new_aubio_tss()"]
    #[doc = "\\param thrs new threshold value"]
    pub fn aubio_tss_set_threshold(o: *mut aubio_tss_t, thrs: smpl_t) -> uint_t;
}
extern "C" {
    #[doc = " set parameter a, defaults to 3"]
    #[doc = ""]
    #[doc = "\\param o tss object as returned by new_aubio_tss()"]
    #[doc = "\\param alpha new value for alpha parameter"]
    pub fn aubio_tss_set_alpha(o: *mut aubio_tss_t, alpha: smpl_t) -> uint_t;
}
extern "C" {
    #[doc = " set parameter b, defaults to 3"]
    #[doc = ""]
    #[doc = "\\param o tss object as returned by new_aubio_tss()"]
    #[doc = "\\param beta new value for beta parameter"]
    pub fn aubio_tss_set_beta(o: *mut aubio_tss_t, beta: smpl_t) -> uint_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _aubio_pitch_t {
    _unused: [u8; 0],
}
#[doc = " pitch detection object"]
pub type aubio_pitch_t = _aubio_pitch_t;
extern "C" {
    #[doc = " execute pitch detection on an input signal frame"]
    #[doc = ""]
    #[doc = "\\param o pitch detection object as returned by new_aubio_pitch()"]
    #[doc = "\\param in input signal of size [hop_size]"]
    #[doc = "\\param out output pitch candidates of size [1]"]
    pub fn aubio_pitch_do(o: *mut aubio_pitch_t, in_: *const fvec_t, out: *mut fvec_t);
}
extern "C" {
    #[doc = " change yin or yinfft tolerance threshold"]
    #[doc = ""]
    #[doc = "\\param o pitch detection object as returned by new_aubio_pitch()"]
    #[doc = "\\param tol tolerance default is 0.15 for yin and 0.85 for yinfft"]
    pub fn aubio_pitch_set_tolerance(o: *mut aubio_pitch_t, tol: smpl_t) -> uint_t;
}
extern "C" {
    #[doc = " get yin or yinfft tolerance threshold"]
    #[doc = ""]
    #[doc = "\\param o pitch detection object as returned by new_aubio_pitch()"]
    #[doc = "\\return tolerance (default is 0.15 for yin and 0.85 for yinfft)"]
    pub fn aubio_pitch_get_tolerance(o: *mut aubio_pitch_t) -> smpl_t;
}
extern "C" {
    #[doc = " deletion of the pitch detection object"]
    #[doc = ""]
    #[doc = "\\param o pitch detection object as returned by new_aubio_pitch()"]
    pub fn del_aubio_pitch(o: *mut aubio_pitch_t);
}
extern "C" {
    #[doc = " creation of the pitch detection object"]
    #[doc = ""]
    #[doc = "\\param method set pitch detection algorithm"]
    #[doc = "\\param buf_size size of the input buffer to analyse"]
    #[doc = "\\param hop_size step size between two consecutive analysis instant"]
    #[doc = "\\param samplerate sampling rate of the signal"]
    #[doc = ""]
    #[doc = "\\return newly created ::aubio_pitch_t"]
    pub fn new_aubio_pitch(
        method: *const char_t,
        buf_size: uint_t,
        hop_size: uint_t,
        samplerate: uint_t,
    ) -> *mut aubio_pitch_t;
}
extern "C" {
    #[doc = " set the output unit of the pitch detection object"]
    #[doc = ""]
    #[doc = "\\param o pitch detection object as returned by new_aubio_pitch()"]
    #[doc = "\\param mode set pitch units for output"]
    #[doc = ""]
    #[doc = "mode can be one of \"Hz\", \"midi\", \"cent\", or \"bin\". Defaults to \"Hz\"."]
    #[doc = ""]
    #[doc = "\\return 0 if successfull, non-zero otherwise"]
    pub fn aubio_pitch_set_unit(o: *mut aubio_pitch_t, mode: *const char_t) -> uint_t;
}
extern "C" {
    #[doc = " set the silence threshold of the pitch detection object"]
    #[doc = ""]
    #[doc = "\\param o pitch detection object as returned by new_aubio_pitch()"]
    #[doc = "\\param silence level threshold under which pitch should be ignored, in dB"]
    #[doc = ""]
    #[doc = "\\return 0 if successfull, non-zero otherwise"]
    pub fn aubio_pitch_set_silence(o: *mut aubio_pitch_t, silence: smpl_t) -> uint_t;
}
extern "C" {
    #[doc = " set the silence threshold of the pitch detection object"]
    #[doc = ""]
    #[doc = "\\param o pitch detection object as returned by ::new_aubio_pitch()"]
    #[doc = ""]
    #[doc = "\\return level threshold under which pitch should be ignored, in dB"]
    pub fn aubio_pitch_get_silence(o: *mut aubio_pitch_t) -> smpl_t;
}
extern "C" {
    #[doc = " get the current confidence"]
    #[doc = ""]
    #[doc = "\\param o pitch detection object as returned by new_aubio_pitch()"]
    #[doc = ""]
    #[doc = "\\return the current confidence of the pitch algorithm"]
    pub fn aubio_pitch_get_confidence(o: *mut aubio_pitch_t) -> smpl_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _aubio_onset_t {
    _unused: [u8; 0],
}
#[doc = " onset detection object"]
pub type aubio_onset_t = _aubio_onset_t;
extern "C" {
    #[doc = " create onset detection object"]
    #[doc = ""]
    #[doc = "\\param method onset detection type as specified in specdesc.h"]
    #[doc = "\\param buf_size buffer size for phase vocoder"]
    #[doc = "\\param hop_size hop size for phase vocoder"]
    #[doc = "\\param samplerate sampling rate of the input signal"]
    #[doc = ""]
    #[doc = "\\return newly created ::aubio_onset_t"]
    pub fn new_aubio_onset(
        method: *const char_t,
        buf_size: uint_t,
        hop_size: uint_t,
        samplerate: uint_t,
    ) -> *mut aubio_onset_t;
}
extern "C" {
    #[doc = " execute onset detection"]
    #[doc = ""]
    #[doc = "\\param o onset detection object as returned by new_aubio_onset()"]
    #[doc = "\\param input new audio vector of length hop_size"]
    #[doc = "\\param onset output vector of length 1, containing 0 if no onset was found,"]
    #[doc = "and a value equal or greater than 1 otherwise"]
    #[doc = ""]
    #[doc = "When no onset was detected, the first element of the output vector `onset`"]
    #[doc = "is set to 0."]
    #[doc = ""]
    #[doc = "When an onset is found, the first element of the output vector `onset` is set"]
    #[doc = "to `offset = 1 + a` where `a` is a number in the range`[0, 1]`."]
    #[doc = ""]
    #[doc = "The final onset detection time, in samples, can be obtained with"]
    #[doc = "aubio_onset_get_last(). It can also be derived from `offset` as"]
    #[doc = "follows:"]
    #[doc = ""]
    #[doc = "\\code"]
    #[doc = "t = total_frames + offset * hop_size - delay"]
    #[doc = "\\endcode"]
    #[doc = ""]
    #[doc = "where `total_frames` is the total number of frames processed so far, and"]
    #[doc = "`delay` is the current delay of the onset object, as returned by"]
    #[doc = "aubio_onset_get_delay()."]
    pub fn aubio_onset_do(o: *mut aubio_onset_t, input: *const fvec_t, onset: *mut fvec_t);
}
extern "C" {
    #[doc = " get the time of the latest onset detected, in samples"]
    #[doc = ""]
    #[doc = "\\param o onset detection object as returned by new_aubio_onset()"]
    #[doc = ""]
    #[doc = "\\return onset detection timestamps (in samples)"]
    pub fn aubio_onset_get_last(o: *const aubio_onset_t) -> uint_t;
}
extern "C" {
    #[doc = " get the time of the latest onset detected, in seconds"]
    #[doc = ""]
    #[doc = "\\param o onset detection object as returned by new_aubio_onset()"]
    #[doc = ""]
    #[doc = "\\return onset detection timestamps (in seconds)"]
    pub fn aubio_onset_get_last_s(o: *const aubio_onset_t) -> smpl_t;
}
extern "C" {
    #[doc = " get the time of the latest onset detected, in milliseconds"]
    #[doc = ""]
    #[doc = "\\param o onset detection object as returned by new_aubio_onset()"]
    #[doc = ""]
    #[doc = "\\return onset detection timestamps (in milliseconds)"]
    pub fn aubio_onset_get_last_ms(o: *const aubio_onset_t) -> smpl_t;
}
extern "C" {
    #[doc = " set onset detection adaptive whitening"]
    #[doc = ""]
    #[doc = "\\param o onset detection object as returned by new_aubio_onset()"]
    #[doc = "\\param enable 1 to enable, 0 to disable"]
    #[doc = ""]
    #[doc = "\\return 0 if successful, 1 otherwise"]
    pub fn aubio_onset_set_awhitening(o: *mut aubio_onset_t, enable: uint_t) -> uint_t;
}
extern "C" {
    #[doc = " get onset detection adaptive whitening"]
    #[doc = ""]
    #[doc = "\\param o onset detection object as returned by new_aubio_onset()"]
    #[doc = ""]
    #[doc = "\\return 1 if enabled, 0 otherwise"]
    pub fn aubio_onset_get_awhitening(o: *mut aubio_onset_t) -> smpl_t;
}
extern "C" {
    #[doc = " set or disable log compression"]
    #[doc = ""]
    #[doc = "\\param o onset detection object as returned by new_aubio_onset()"]
    #[doc = "\\param lambda logarithmic compression factor, 0 to disable"]
    #[doc = ""]
    #[doc = "\\return 0 if successful, 1 otherwise"]
    #[doc = ""]
    pub fn aubio_onset_set_compression(o: *mut aubio_onset_t, lambda: smpl_t) -> uint_t;
}
extern "C" {
    #[doc = " get onset detection log compression"]
    #[doc = ""]
    #[doc = "\\param o onset detection object as returned by new_aubio_onset()"]
    #[doc = ""]
    #[doc = "\\returns 0 if disabled, compression factor otherwise"]
    #[doc = ""]
    pub fn aubio_onset_get_compression(o: *mut aubio_onset_t) -> smpl_t;
}
extern "C" {
    #[doc = " set onset detection silence threshold"]
    #[doc = ""]
    #[doc = "\\param o onset detection object as returned by new_aubio_onset()"]
    #[doc = "\\param silence new silence detection threshold"]
    pub fn aubio_onset_set_silence(o: *mut aubio_onset_t, silence: smpl_t) -> uint_t;
}
extern "C" {
    #[doc = " get onset detection silence threshold"]
    #[doc = ""]
    #[doc = "\\param o onset detection object as returned by new_aubio_onset()"]
    #[doc = ""]
    #[doc = "\\return current silence threshold"]
    pub fn aubio_onset_get_silence(o: *const aubio_onset_t) -> smpl_t;
}
extern "C" {
    #[doc = " get onset detection function"]
    #[doc = ""]
    #[doc = "\\param o onset detection object as returned by new_aubio_onset()"]
    #[doc = "\\return the current value of the descriptor"]
    pub fn aubio_onset_get_descriptor(o: *const aubio_onset_t) -> smpl_t;
}
extern "C" {
    #[doc = " get thresholded onset detection function"]
    #[doc = ""]
    #[doc = "\\param o onset detection object as returned by new_aubio_onset()"]
    #[doc = "\\return the value of the thresholded descriptor"]
    pub fn aubio_onset_get_thresholded_descriptor(o: *const aubio_onset_t) -> smpl_t;
}
extern "C" {
    #[doc = " set onset detection peak picking threshold"]
    #[doc = ""]
    #[doc = "\\param o onset detection object as returned by new_aubio_onset()"]
    #[doc = "\\param threshold new peak-picking threshold"]
    pub fn aubio_onset_set_threshold(o: *mut aubio_onset_t, threshold: smpl_t) -> uint_t;
}
extern "C" {
    #[doc = " set minimum inter onset interval in samples"]
    #[doc = ""]
    #[doc = "\\param o onset detection object as returned by new_aubio_onset()"]
    #[doc = "\\param minioi minimum interval between two consecutive onsets (in"]
    #[doc = "samples)"]
    pub fn aubio_onset_set_minioi(o: *mut aubio_onset_t, minioi: uint_t) -> uint_t;
}
extern "C" {
    #[doc = " set minimum inter onset interval in seconds"]
    #[doc = ""]
    #[doc = "\\param o onset detection object as returned by new_aubio_onset()"]
    #[doc = "\\param minioi minimum interval between two consecutive onsets (in"]
    #[doc = "seconds)"]
    pub fn aubio_onset_set_minioi_s(o: *mut aubio_onset_t, minioi: smpl_t) -> uint_t;
}
extern "C" {
    #[doc = " set minimum inter onset interval in milliseconds"]
    #[doc = ""]
    #[doc = "\\param o onset detection object as returned by new_aubio_onset()"]
    #[doc = "\\param minioi minimum interval between two consecutive onsets (in"]
    #[doc = "milliseconds)"]
    pub fn aubio_onset_set_minioi_ms(o: *mut aubio_onset_t, minioi: smpl_t) -> uint_t;
}
extern "C" {
    #[doc = " set delay in samples"]
    #[doc = ""]
    #[doc = "\\param o onset detection object as returned by new_aubio_onset()"]
    #[doc = "\\param delay constant system delay to take back from detection time"]
    #[doc = "(in samples)"]
    pub fn aubio_onset_set_delay(o: *mut aubio_onset_t, delay: uint_t) -> uint_t;
}
extern "C" {
    #[doc = " set delay in seconds"]
    #[doc = ""]
    #[doc = "\\param o onset detection object as returned by new_aubio_onset()"]
    #[doc = "\\param delay constant system delay to take back from detection time"]
    #[doc = "(in seconds)"]
    pub fn aubio_onset_set_delay_s(o: *mut aubio_onset_t, delay: smpl_t) -> uint_t;
}
extern "C" {
    #[doc = " set delay in milliseconds"]
    #[doc = ""]
    #[doc = "\\param o onset detection object as returned by new_aubio_onset()"]
    #[doc = "\\param delay constant system delay to take back from detection time"]
    #[doc = "(in milliseconds)"]
    pub fn aubio_onset_set_delay_ms(o: *mut aubio_onset_t, delay: smpl_t) -> uint_t;
}
extern "C" {
    #[doc = " get minimum inter onset interval in samples"]
    #[doc = ""]
    #[doc = "\\param o onset detection object as returned by new_aubio_onset()"]
    #[doc = "\\return minimum interval between two consecutive onsets (in"]
    #[doc = "samples)"]
    pub fn aubio_onset_get_minioi(o: *const aubio_onset_t) -> uint_t;
}
extern "C" {
    #[doc = " get minimum inter onset interval in seconds"]
    #[doc = ""]
    #[doc = "\\param o onset detection object as returned by new_aubio_onset()"]
    #[doc = "\\return minimum interval between two consecutive onsets (in"]
    #[doc = "seconds)"]
    pub fn aubio_onset_get_minioi_s(o: *const aubio_onset_t) -> smpl_t;
}
extern "C" {
    #[doc = " get minimum inter onset interval in milliseconds"]
    #[doc = ""]
    #[doc = "\\param o onset detection object as returned by new_aubio_onset()"]
    #[doc = "\\return minimum interval between two consecutive onsets (in"]
    #[doc = "milliseconds)"]
    pub fn aubio_onset_get_minioi_ms(o: *const aubio_onset_t) -> smpl_t;
}
extern "C" {
    #[doc = " get delay in samples"]
    #[doc = ""]
    #[doc = "\\param o onset detection object as returned by new_aubio_onset()"]
    #[doc = "\\return constant system delay to take back from detection time"]
    #[doc = "(in samples)"]
    pub fn aubio_onset_get_delay(o: *const aubio_onset_t) -> uint_t;
}
extern "C" {
    #[doc = " get delay in seconds"]
    #[doc = ""]
    #[doc = "\\param o onset detection object as returned by new_aubio_onset()"]
    #[doc = "\\return constant system delay to take back from detection time"]
    #[doc = "(in seconds)"]
    pub fn aubio_onset_get_delay_s(o: *const aubio_onset_t) -> smpl_t;
}
extern "C" {
    #[doc = " get delay in milliseconds"]
    #[doc = ""]
    #[doc = "\\param o onset detection object as returned by new_aubio_onset()"]
    #[doc = "\\return constant system delay to take back from detection time"]
    #[doc = "(in milliseconds)"]
    pub fn aubio_onset_get_delay_ms(o: *const aubio_onset_t) -> smpl_t;
}
extern "C" {
    #[doc = " get onset peak picking threshold"]
    #[doc = ""]
    #[doc = "\\param o onset detection object as returned by new_aubio_onset()"]
    #[doc = "\\return current onset detection threshold"]
    pub fn aubio_onset_get_threshold(o: *const aubio_onset_t) -> smpl_t;
}
extern "C" {
    #[doc = " set default parameters"]
    #[doc = ""]
    #[doc = "\\param o onset detection object as returned by new_aubio_onset()"]
    #[doc = "\\param onset_mode detection mode to adjust"]
    #[doc = ""]
    #[doc = "This function is called at the end of new_aubio_onset()."]
    #[doc = ""]
    pub fn aubio_onset_set_default_parameters(
        o: *mut aubio_onset_t,
        onset_mode: *const char_t,
    ) -> uint_t;
}
extern "C" {
    #[doc = " reset onset detection"]
    #[doc = ""]
    #[doc = "\\param o onset detection object as returned by new_aubio_onset()"]
    #[doc = ""]
    #[doc = "Reset current time and last onset to 0."]
    #[doc = ""]
    #[doc = "This function is called at the end of new_aubio_onset()."]
    #[doc = ""]
    pub fn aubio_onset_reset(o: *mut aubio_onset_t);
}
extern "C" {
    #[doc = " delete onset detection object"]
    #[doc = ""]
    #[doc = "\\param o onset detection object to delete"]
    pub fn del_aubio_onset(o: *mut aubio_onset_t);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _aubio_tempo_t {
    _unused: [u8; 0],
}
#[doc = " tempo detection structure"]
pub type aubio_tempo_t = _aubio_tempo_t;
extern "C" {
    #[doc = " create tempo detection object"]
    #[doc = ""]
    #[doc = "\\param method beat tracking method, unused for now (use \"default\")"]
    #[doc = "\\param buf_size length of FFT"]
    #[doc = "\\param hop_size number of frames between two consecutive runs"]
    #[doc = "\\param samplerate sampling rate of the signal to analyze"]
    #[doc = ""]
    #[doc = "\\return newly created ::aubio_tempo_t if successful, `NULL` otherwise"]
    pub fn new_aubio_tempo(
        method: *const char_t,
        buf_size: uint_t,
        hop_size: uint_t,
        samplerate: uint_t,
    ) -> *mut aubio_tempo_t;
}
extern "C" {
    #[doc = " execute tempo detection"]
    #[doc = ""]
    #[doc = "\\param o beat tracking object"]
    #[doc = "\\param input new samples"]
    #[doc = "\\param tempo output beats"]
    pub fn aubio_tempo_do(o: *mut aubio_tempo_t, input: *const fvec_t, tempo: *mut fvec_t);
}
extern "C" {
    #[doc = " get the time of the latest beat detected, in samples"]
    #[doc = ""]
    #[doc = "\\param o tempo detection object as returned by ::new_aubio_tempo"]
    pub fn aubio_tempo_get_last(o: *mut aubio_tempo_t) -> uint_t;
}
extern "C" {
    #[doc = " get the time of the latest beat detected, in seconds"]
    #[doc = ""]
    #[doc = "\\param o tempo detection object as returned by ::new_aubio_tempo"]
    pub fn aubio_tempo_get_last_s(o: *mut aubio_tempo_t) -> smpl_t;
}
extern "C" {
    #[doc = " get the time of the latest beat detected, in milliseconds"]
    #[doc = ""]
    #[doc = "\\param o tempo detection object as returned by ::new_aubio_tempo"]
    pub fn aubio_tempo_get_last_ms(o: *mut aubio_tempo_t) -> smpl_t;
}
extern "C" {
    #[doc = " set tempo detection silence threshold"]
    #[doc = ""]
    #[doc = "\\param o beat tracking object"]
    #[doc = "\\param silence new silence threshold, in dB"]
    #[doc = ""]
    #[doc = "\\return `0` if successful, non-zero otherwise"]
    pub fn aubio_tempo_set_silence(o: *mut aubio_tempo_t, silence: smpl_t) -> uint_t;
}
extern "C" {
    #[doc = " get tempo detection silence threshold"]
    #[doc = ""]
    #[doc = "\\param o tempo detection object as returned by new_aubio_tempo()"]
    #[doc = ""]
    #[doc = "\\return current silence threshold"]
    pub fn aubio_tempo_get_silence(o: *mut aubio_tempo_t) -> smpl_t;
}
extern "C" {
    #[doc = " set tempo detection peak picking threshold"]
    #[doc = ""]
    #[doc = "\\param o beat tracking object"]
    #[doc = "\\param threshold new threshold"]
    #[doc = ""]
    #[doc = "\\return `0` if successful, non-zero otherwise"]
    pub fn aubio_tempo_set_threshold(o: *mut aubio_tempo_t, threshold: smpl_t) -> uint_t;
}
extern "C" {
    #[doc = " get tempo peak picking threshold"]
    #[doc = ""]
    #[doc = "\\param o tempo detection object as returned by new_aubio_tempo()"]
    #[doc = ""]
    #[doc = "\\return current tempo detection threshold"]
    pub fn aubio_tempo_get_threshold(o: *mut aubio_tempo_t) -> smpl_t;
}
extern "C" {
    #[doc = " get current beat period in samples"]
    #[doc = ""]
    #[doc = "\\param bt beat tracking object"]
    #[doc = ""]
    #[doc = "Returns the currently observed period, in samples, or 0 if no consistent"]
    #[doc = "value is found."]
    pub fn aubio_tempo_get_period(bt: *mut aubio_tempo_t) -> smpl_t;
}
extern "C" {
    #[doc = " get current beat period in seconds"]
    #[doc = ""]
    #[doc = "\\param bt beat tracking object"]
    #[doc = ""]
    #[doc = "Returns the currently observed period, in seconds, or 0 if no consistent"]
    #[doc = "value is found."]
    pub fn aubio_tempo_get_period_s(bt: *mut aubio_tempo_t) -> smpl_t;
}
extern "C" {
    #[doc = " get current tempo"]
    #[doc = ""]
    #[doc = "\\param o beat tracking object"]
    #[doc = ""]
    #[doc = "\\return the currently observed tempo, or `0` if no consistent value is found"]
    pub fn aubio_tempo_get_bpm(o: *mut aubio_tempo_t) -> smpl_t;
}
extern "C" {
    #[doc = " get current tempo confidence"]
    #[doc = ""]
    #[doc = "\\param o beat tracking object"]
    #[doc = ""]
    #[doc = "\\return confidence with which the tempo has been observed, the higher the"]
    #[doc = "more confidence, `0` if no consistent value is found."]
    pub fn aubio_tempo_get_confidence(o: *mut aubio_tempo_t) -> smpl_t;
}
extern "C" {
    #[doc = " set number of tatum per beat"]
    #[doc = ""]
    #[doc = "\\param o beat tracking object"]
    #[doc = "\\param signature number of tatum per beat (between 1 and 64)"]
    pub fn aubio_tempo_set_tatum_signature(o: *mut aubio_tempo_t, signature: uint_t) -> uint_t;
}
extern "C" {
    #[doc = " check whether a tatum was detected in the current frame"]
    #[doc = ""]
    #[doc = "\\param o beat tracking object"]
    #[doc = ""]
    #[doc = "\\return 2 if a beat was detected, 1 if a tatum was detected, 0 otherwise"]
    pub fn aubio_tempo_was_tatum(o: *mut aubio_tempo_t) -> uint_t;
}
extern "C" {
    #[doc = " get position of last_tatum, in samples"]
    #[doc = ""]
    #[doc = "\\param o beat tracking object"]
    pub fn aubio_tempo_get_last_tatum(o: *mut aubio_tempo_t) -> smpl_t;
}
extern "C" {
    #[doc = " get current delay"]
    #[doc = ""]
    #[doc = "\\param o beat tracking object"]
    #[doc = ""]
    #[doc = "\\return current delay, in samples"]
    #[doc = ""]
    pub fn aubio_tempo_get_delay(o: *mut aubio_tempo_t) -> uint_t;
}
extern "C" {
    #[doc = " get current delay in seconds"]
    #[doc = ""]
    #[doc = "\\param o beat tracking object"]
    #[doc = ""]
    #[doc = "\\return current delay, in seconds"]
    #[doc = ""]
    pub fn aubio_tempo_get_delay_s(o: *mut aubio_tempo_t) -> smpl_t;
}
extern "C" {
    #[doc = " get current delay in ms"]
    #[doc = ""]
    #[doc = "\\param o beat tracking object"]
    #[doc = ""]
    #[doc = "\\return current delay, in milliseconds"]
    #[doc = ""]
    pub fn aubio_tempo_get_delay_ms(o: *mut aubio_tempo_t) -> smpl_t;
}
extern "C" {
    #[doc = " set current delay"]
    #[doc = ""]
    #[doc = "\\param o beat tracking object"]
    #[doc = "\\param delay delay to set tempo to, in samples"]
    #[doc = ""]
    #[doc = "\\return `0` if successful, non-zero otherwise"]
    #[doc = ""]
    pub fn aubio_tempo_set_delay(o: *mut aubio_tempo_t, delay: sint_t) -> uint_t;
}
extern "C" {
    #[doc = " set current delay in seconds"]
    #[doc = ""]
    #[doc = "\\param o beat tracking object"]
    #[doc = "\\param delay delay to set tempo to, in seconds"]
    #[doc = ""]
    #[doc = "\\return `0` if successful, non-zero otherwise"]
    #[doc = ""]
    pub fn aubio_tempo_set_delay_s(o: *mut aubio_tempo_t, delay: smpl_t) -> uint_t;
}
extern "C" {
    #[doc = " set current delay"]
    #[doc = ""]
    #[doc = "\\param o beat tracking object"]
    #[doc = "\\param delay delay to set tempo to, in samples"]
    #[doc = ""]
    #[doc = "\\return `0` if successful, non-zero otherwise"]
    #[doc = ""]
    pub fn aubio_tempo_set_delay_ms(o: *mut aubio_tempo_t, delay: smpl_t) -> uint_t;
}
extern "C" {
    #[doc = " delete tempo detection object"]
    #[doc = ""]
    #[doc = "\\param o beat tracking object"]
    pub fn del_aubio_tempo(o: *mut aubio_tempo_t);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _aubio_notes_t {
    _unused: [u8; 0],
}
#[doc = " notes detection object"]
pub type aubio_notes_t = _aubio_notes_t;
extern "C" {
    #[doc = " create notes detection object"]
    #[doc = ""]
    #[doc = "\\param method notes detection type as specified in specdesc.h"]
    #[doc = "\\param buf_size buffer size for phase vocoder"]
    #[doc = "\\param hop_size hop size for phase vocoder"]
    #[doc = "\\param samplerate sampling rate of the input signal"]
    #[doc = ""]
    #[doc = "\\return newly created ::aubio_notes_t"]
    pub fn new_aubio_notes(
        method: *const char_t,
        buf_size: uint_t,
        hop_size: uint_t,
        samplerate: uint_t,
    ) -> *mut aubio_notes_t;
}
extern "C" {
    #[doc = " delete notes detection object"]
    #[doc = ""]
    #[doc = "\\param o notes detection object to delete"]
    pub fn del_aubio_notes(o: *mut aubio_notes_t);
}
extern "C" {
    #[doc = " execute note detection on an input signal frame"]
    #[doc = ""]
    #[doc = "\\param o note detection object as returned by new_aubio_notes()"]
    #[doc = "\\param input input signal of size [hop_size]"]
    #[doc = "\\param output output notes, fvec of length 3"]
    #[doc = ""]
    #[doc = "The notes output is a vector of length 3 containing:"]
    #[doc = "- 0. the midi note value, or 0 if no note was found"]
    #[doc = "- 1. the note velocity"]
    #[doc = "- 2. the midi note to turn off"]
    pub fn aubio_notes_do(o: *mut aubio_notes_t, input: *const fvec_t, output: *mut fvec_t);
}
extern "C" {
    #[doc = " set notes detection silence threshold"]
    #[doc = ""]
    #[doc = "\\param o notes detection object as returned by new_aubio_notes()"]
    #[doc = "\\param silence new silence detection threshold"]
    #[doc = ""]
    #[doc = "\\return 0 on success, non-zero otherwise"]
    pub fn aubio_notes_set_silence(o: *mut aubio_notes_t, silence: smpl_t) -> uint_t;
}
extern "C" {
    #[doc = " get notes detection silence threshold"]
    #[doc = ""]
    #[doc = "\\param o notes detection object as returned by new_aubio_notes()"]
    #[doc = ""]
    #[doc = "\\return current silence threshold"]
    pub fn aubio_notes_get_silence(o: *const aubio_notes_t) -> smpl_t;
}
extern "C" {
    #[doc = " get notes detection minimum inter-onset interval, in millisecond"]
    #[doc = ""]
    #[doc = "\\param o notes detection object as returned by new_aubio_notes()"]
    #[doc = ""]
    #[doc = "\\return current minimum inter onset interval"]
    #[doc = ""]
    pub fn aubio_notes_get_minioi_ms(o: *const aubio_notes_t) -> smpl_t;
}
extern "C" {
    #[doc = " set notes detection minimum inter-onset interval, in millisecond"]
    #[doc = ""]
    #[doc = "\\param o notes detection object as returned by new_aubio_notes()"]
    #[doc = "\\param minioi_ms new inter-onset interval"]
    #[doc = ""]
    #[doc = "\\return 0 on success, non-zero otherwise"]
    pub fn aubio_notes_set_minioi_ms(o: *mut aubio_notes_t, minioi_ms: smpl_t) -> uint_t;
}
extern "C" {
    #[doc = " get notes object release drop level, in dB"]
    #[doc = ""]
    #[doc = "\\param o notes detection object as returned by new_aubio_notes()"]
    #[doc = ""]
    #[doc = "\\return current release drop level, in dB"]
    #[doc = ""]
    pub fn aubio_notes_get_release_drop(o: *const aubio_notes_t) -> smpl_t;
}
extern "C" {
    #[doc = " set note release drop level, in dB"]
    #[doc = ""]
    #[doc = "This function sets the release_drop_level parameter, in dB. When a new note"]
    #[doc = "is found, the current level in dB is measured. If the measured level drops"]
    #[doc = "under that initial level - release_drop_level, then a note-off will be"]
    #[doc = "emitted."]
    #[doc = ""]
    #[doc = "Defaults to `10`, in dB."]
    #[doc = ""]
    #[doc = "\\note This parameter was added in version `0.4.8`. Results obtained with"]
    #[doc = "earlier versions can be reproduced by setting this value to `100`, so that"]
    #[doc = "note-off will not be played until the next note."]
    #[doc = ""]
    #[doc = "\\param o notes detection object as returned by new_aubio_notes()"]
    #[doc = "\\param release_drop new release drop level, in dB"]
    #[doc = ""]
    #[doc = "\\return 0 on success, non-zero otherwise"]
    pub fn aubio_notes_set_release_drop(o: *mut aubio_notes_t, release_drop: smpl_t) -> uint_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _aubio_source_t {
    _unused: [u8; 0],
}
#[doc = " media source object"]
pub type aubio_source_t = _aubio_source_t;
extern "C" {
    #[doc = "create new ::aubio_source_t"]
    #[doc = ""]
    #[doc = "\\param uri the file path or uri to read from"]
    #[doc = "\\param samplerate sampling rate to view the fie at"]
    #[doc = "\\param hop_size the size of the blocks to read from"]
    #[doc = ""]
    #[doc = "Creates a new source object. If `0` is passed as `samplerate`, the sample"]
    #[doc = "rate of the original file is used."]
    #[doc = ""]
    #[doc = "The samplerate of newly created source can be obtained using"]
    #[doc = "::aubio_source_get_samplerate."]
    pub fn new_aubio_source(
        uri: *const char_t,
        samplerate: uint_t,
        hop_size: uint_t,
    ) -> *mut aubio_source_t;
}
extern "C" {
    #[doc = "read monophonic vector of length hop_size from source object"]
    #[doc = ""]
    #[doc = "\\param s source object, created with ::new_aubio_source"]
    #[doc = "\\param read_to ::fvec_t of data to read to"]
    #[doc = "\\param read upon returns, equals to number of frames actually read"]
    #[doc = ""]
    #[doc = "Upon returns, `read` contains the number of frames actually read from the"]
    #[doc = "source. `hop_size` if enough frames could be read, less otherwise."]
    pub fn aubio_source_do(s: *mut aubio_source_t, read_to: *mut fvec_t, read: *mut uint_t);
}
extern "C" {
    #[doc = "read polyphonic vector of length hop_size from source object"]
    #[doc = ""]
    #[doc = "\\param s source object, created with ::new_aubio_source"]
    #[doc = "\\param read_to ::fmat_t of data to read to"]
    #[doc = "\\param[out] read upon returns, equals to number of frames actually read"]
    #[doc = ""]
    #[doc = "Upon returns, `read` contains the number of frames actually read from the"]
    #[doc = "source. `hop_size` if enough frames could be read, less otherwise."]
    pub fn aubio_source_do_multi(s: *mut aubio_source_t, read_to: *mut fmat_t, read: *mut uint_t);
}
extern "C" {
    #[doc = "get samplerate of source object"]
    #[doc = ""]
    #[doc = "\\param s source object, created with ::new_aubio_source"]
    #[doc = "\\return samplerate, in Hz"]
    pub fn aubio_source_get_samplerate(s: *mut aubio_source_t) -> uint_t;
}
extern "C" {
    #[doc = "get channels of source object"]
    #[doc = ""]
    #[doc = "\\param s source object, created with ::new_aubio_source"]
    #[doc = "\\return channels"]
    pub fn aubio_source_get_channels(s: *mut aubio_source_t) -> uint_t;
}
extern "C" {
    #[doc = "seek source object"]
    #[doc = ""]
    #[doc = "\\param s source object, created with ::new_aubio_source"]
    #[doc = "\\param pos position to seek to, in frames"]
    #[doc = ""]
    #[doc = "\\return 0 if sucessful, non-zero on failure"]
    pub fn aubio_source_seek(s: *mut aubio_source_t, pos: uint_t) -> uint_t;
}
extern "C" {
    #[doc = "get the duration of source object, in frames"]
    #[doc = ""]
    #[doc = "\\param s source object, created with ::new_aubio_source"]
    #[doc = "\\return number of frames in file"]
    pub fn aubio_source_get_duration(s: *mut aubio_source_t) -> uint_t;
}
extern "C" {
    #[doc = "close source object"]
    #[doc = ""]
    #[doc = "\\param s source object, created with ::new_aubio_source"]
    #[doc = ""]
    #[doc = "\\return 0 if sucessful, non-zero on failure"]
    #[doc = ""]
    pub fn aubio_source_close(s: *mut aubio_source_t) -> uint_t;
}
extern "C" {
    #[doc = "close source and cleanup memory"]
    #[doc = ""]
    #[doc = "\\param s source object, created with ::new_aubio_source"]
    pub fn del_aubio_source(s: *mut aubio_source_t);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _aubio_sink_t {
    _unused: [u8; 0],
}
#[doc = " media sink object"]
pub type aubio_sink_t = _aubio_sink_t;
extern "C" {
    #[doc = "create new ::aubio_sink_t"]
    #[doc = ""]
    #[doc = "\\param uri the file path or uri to write to"]
    #[doc = "\\param samplerate sample rate to write the file at"]
    #[doc = ""]
    #[doc = "\\return newly created ::aubio_sink_t"]
    #[doc = ""]
    #[doc = "Creates a new sink object."]
    #[doc = ""]
    #[doc = "If samplerate is set to 0, the creation of the file will be delayed until"]
    #[doc = "both ::aubio_sink_preset_samplerate and ::aubio_sink_preset_channels have"]
    #[doc = "been called."]
    pub fn new_aubio_sink(uri: *const char_t, samplerate: uint_t) -> *mut aubio_sink_t;
}
extern "C" {
    #[doc = "preset sink samplerate"]
    #[doc = ""]
    #[doc = "\\param s sink, created with ::new_aubio_sink"]
    #[doc = "\\param samplerate samplerate to preset the sink to, in Hz"]
    #[doc = ""]
    #[doc = "\\return 0 on success, 1 on error"]
    #[doc = ""]
    #[doc = "Preset the samplerate of the sink. The file should have been created using a"]
    #[doc = "samplerate of 0."]
    #[doc = ""]
    #[doc = "The file will be opened only when both samplerate and channels have been set."]
    pub fn aubio_sink_preset_samplerate(s: *mut aubio_sink_t, samplerate: uint_t) -> uint_t;
}
extern "C" {
    #[doc = "preset sink channels"]
    #[doc = ""]
    #[doc = "\\param s sink, created with ::new_aubio_sink"]
    #[doc = "\\param channels number of channels to preset the sink to"]
    #[doc = ""]
    #[doc = "\\return 0 on success, 1 on error"]
    #[doc = ""]
    #[doc = "Preset the samplerate of the sink. The file should have been created using a"]
    #[doc = "samplerate of 0."]
    #[doc = ""]
    #[doc = "The file will be opened only when both samplerate and channels have been set."]
    pub fn aubio_sink_preset_channels(s: *mut aubio_sink_t, channels: uint_t) -> uint_t;
}
extern "C" {
    #[doc = "get samplerate of sink object"]
    #[doc = ""]
    #[doc = "\\param s sink object, created with ::new_aubio_sink"]
    #[doc = "\\return samplerate, in Hz"]
    pub fn aubio_sink_get_samplerate(s: *const aubio_sink_t) -> uint_t;
}
extern "C" {
    #[doc = "get channels of sink object"]
    #[doc = ""]
    #[doc = "\\param s sink object, created with ::new_aubio_sink"]
    #[doc = "\\return number of channels"]
    pub fn aubio_sink_get_channels(s: *const aubio_sink_t) -> uint_t;
}
extern "C" {
    #[doc = "write monophonic vector of length hop_size to sink"]
    #[doc = ""]
    #[doc = "\\param s sink, created with ::new_aubio_sink"]
    #[doc = "\\param write_data ::fvec_t samples to write to sink"]
    #[doc = "\\param write number of frames to write"]
    pub fn aubio_sink_do(s: *mut aubio_sink_t, write_data: *mut fvec_t, write: uint_t);
}
extern "C" {
    #[doc = "write polyphonic vector of length hop_size to sink"]
    #[doc = ""]
    #[doc = "\\param s sink, created with ::new_aubio_sink"]
    #[doc = "\\param write_data ::fmat_t samples to write to sink"]
    #[doc = "\\param write number of frames to write"]
    pub fn aubio_sink_do_multi(s: *mut aubio_sink_t, write_data: *mut fmat_t, write: uint_t);
}
extern "C" {
    #[doc = "close sink"]
    #[doc = ""]
    #[doc = "\\param s sink object, created with ::new_aubio_sink"]
    #[doc = ""]
    #[doc = "\\return 0 on success, non-zero on failure"]
    pub fn aubio_sink_close(s: *mut aubio_sink_t) -> uint_t;
}
extern "C" {
    #[doc = "close sink and cleanup memory"]
    #[doc = ""]
    #[doc = "\\param s sink object, created with ::new_aubio_sink"]
    pub fn del_aubio_sink(s: *mut aubio_sink_t);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _aubio_sampler_t {
    _unused: [u8; 0],
}
#[doc = " sampler object"]
pub type aubio_sampler_t = _aubio_sampler_t;
extern "C" {
    #[doc = " create new sampler object"]
    #[doc = ""]
    #[doc = "\\param samplerate the sampling rate of the new sampler"]
    #[doc = "\\param hop_size the block size of the new sampler"]
    #[doc = ""]
    #[doc = "\\return the newly created ::aubio_sampler_t"]
    pub fn new_aubio_sampler(samplerate: uint_t, hop_size: uint_t) -> *mut aubio_sampler_t;
}
extern "C" {
    #[doc = " load source in sampler"]
    #[doc = ""]
    #[doc = "\\param o sampler, created by new_aubio_sampler()"]
    #[doc = "\\param uri the uri of the source to load"]
    #[doc = ""]
    #[doc = "\\return 0 if successful, non-zero otherwise"]
    pub fn aubio_sampler_load(o: *mut aubio_sampler_t, uri: *const char_t) -> uint_t;
}
extern "C" {
    #[doc = " process sampler function"]
    #[doc = ""]
    #[doc = "\\param o sampler, created by new_aubio_sampler()"]
    #[doc = "\\param input input of the sampler, to be added to the output"]
    #[doc = "\\param output output of the sampler"]
    #[doc = ""]
    #[doc = "This function adds the new samples from the playing source to the output."]
    #[doc = ""]
    #[doc = "If `input` is not NULL and different from `output`, then the samples from `input`"]
    #[doc = "are added to the output."]
    pub fn aubio_sampler_do(o: *mut aubio_sampler_t, input: *const fvec_t, output: *mut fvec_t);
}
extern "C" {
    #[doc = " process sampler function, multiple channels"]
    #[doc = ""]
    #[doc = "\\param o sampler, created by new_aubio_sampler()"]
    #[doc = "\\param input input of the sampler, to be added to the output"]
    #[doc = "\\param output output of the sampler"]
    #[doc = ""]
    #[doc = "This function adds the new samples from the playing source to the output."]
    #[doc = ""]
    #[doc = "If `input` is not NULL and different from `output`, then the samples from `input`"]
    #[doc = "are added to the output."]
    pub fn aubio_sampler_do_multi(
        o: *mut aubio_sampler_t,
        input: *const fmat_t,
        output: *mut fmat_t,
    );
}
extern "C" {
    #[doc = " get current playing state"]
    #[doc = ""]
    #[doc = "\\param o sampler, created by new_aubio_sampler()"]
    #[doc = ""]
    #[doc = "\\return 0 if not playing, 1 if playing"]
    pub fn aubio_sampler_get_playing(o: *const aubio_sampler_t) -> uint_t;
}
extern "C" {
    #[doc = " set current playing state"]
    #[doc = ""]
    #[doc = "\\param o sampler, created by new_aubio_sampler()"]
    #[doc = "\\param playing 0 for not playing, 1 for playing"]
    #[doc = ""]
    #[doc = "\\return 0 if successful, 1 otherwise"]
    pub fn aubio_sampler_set_playing(o: *mut aubio_sampler_t, playing: uint_t) -> uint_t;
}
extern "C" {
    #[doc = " play sample from start"]
    #[doc = ""]
    #[doc = "\\param o sampler, created by new_aubio_sampler()"]
    #[doc = ""]
    #[doc = "\\return 0 if successful, 1 otherwise"]
    pub fn aubio_sampler_play(o: *mut aubio_sampler_t) -> uint_t;
}
extern "C" {
    #[doc = " stop sample"]
    #[doc = ""]
    #[doc = "\\param o sampler, created by new_aubio_sampler()"]
    #[doc = ""]
    #[doc = "\\return 0 if successful, 1 otherwise"]
    pub fn aubio_sampler_stop(o: *mut aubio_sampler_t) -> uint_t;
}
extern "C" {
    #[doc = " destroy ::aubio_sampler_t object"]
    #[doc = ""]
    #[doc = "\\param o sampler, created by new_aubio_sampler()"]
    pub fn del_aubio_sampler(o: *mut aubio_sampler_t);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _aubio_wavetable_t {
    _unused: [u8; 0],
}
#[doc = " wavetable object"]
pub type aubio_wavetable_t = _aubio_wavetable_t;
extern "C" {
    #[doc = " create new wavetable object"]
    #[doc = ""]
    #[doc = "\\param samplerate the sampling rate of the new wavetable"]
    #[doc = "\\param hop_size the block size of the new wavetable"]
    #[doc = ""]
    #[doc = "\\return the newly created aubio_wavetable_t"]
    pub fn new_aubio_wavetable(samplerate: uint_t, hop_size: uint_t) -> *mut aubio_wavetable_t;
}
extern "C" {
    #[doc = " load source in wavetable"]
    #[doc = ""]
    #[doc = "TODO: This function is not implemented yet. See new_aubio_sampler() instead."]
    #[doc = ""]
    #[doc = "\\param o wavetable, created by new_aubio_wavetable()"]
    #[doc = "\\param uri the uri of the source to load"]
    #[doc = ""]
    #[doc = "\\return 0 if successful, non-zero otherwise"]
    pub fn aubio_wavetable_load(o: *mut aubio_wavetable_t, uri: *const char_t) -> uint_t;
}
extern "C" {
    #[doc = " process wavetable function"]
    #[doc = ""]
    #[doc = "\\param o wavetable, created by new_aubio_wavetable()"]
    #[doc = "\\param input input of the wavetable, to be added to the output"]
    #[doc = "\\param output output of the wavetable"]
    #[doc = ""]
    #[doc = "This function adds the new samples from the playing wavetable to the output."]
    #[doc = ""]
    #[doc = "If `input` is not NULL and different from `output`, then the samples from `input`"]
    #[doc = "are added to the output."]
    pub fn aubio_wavetable_do(o: *mut aubio_wavetable_t, input: *const fvec_t, output: *mut fvec_t);
}
extern "C" {
    #[doc = " process wavetable function, multiple channels"]
    #[doc = ""]
    #[doc = "\\param o wavetable, created by new_aubio_wavetable()"]
    #[doc = "\\param input input of the wavetable, to be added to the output"]
    #[doc = "\\param output output of the wavetable"]
    #[doc = ""]
    #[doc = "This function adds the new samples from the playing wavetable to the output."]
    #[doc = ""]
    #[doc = "If `input` is not NULL and different from `output`, then the samples from `input`"]
    #[doc = "are added to the output."]
    pub fn aubio_wavetable_do_multi(
        o: *mut aubio_wavetable_t,
        input: *const fmat_t,
        output: *mut fmat_t,
    );
}
extern "C" {
    #[doc = " get current playing state"]
    #[doc = ""]
    #[doc = "\\param o wavetable, created by new_aubio_wavetable()"]
    #[doc = ""]
    #[doc = "\\return 0 if not playing, 1 if playing"]
    pub fn aubio_wavetable_get_playing(o: *const aubio_wavetable_t) -> uint_t;
}
extern "C" {
    #[doc = " set current playing state"]
    #[doc = ""]
    #[doc = "\\param o wavetable, created by new_aubio_wavetable()"]
    #[doc = "\\param playing 0 for not playing, 1 for playing"]
    #[doc = ""]
    #[doc = "\\return 0 if successful, 1 otherwise"]
    pub fn aubio_wavetable_set_playing(o: *mut aubio_wavetable_t, playing: uint_t) -> uint_t;
}
extern "C" {
    #[doc = " play sample from start"]
    #[doc = ""]
    #[doc = "\\param o wavetable, created by new_aubio_wavetable()"]
    #[doc = ""]
    #[doc = "\\return 0 if successful, 1 otherwise"]
    pub fn aubio_wavetable_play(o: *mut aubio_wavetable_t) -> uint_t;
}
extern "C" {
    #[doc = " stop wavetable"]
    #[doc = ""]
    #[doc = "\\param o wavetable, created by new_aubio_wavetable()"]
    #[doc = ""]
    #[doc = "\\return 0 if successful, 1 otherwise"]
    pub fn aubio_wavetable_stop(o: *mut aubio_wavetable_t) -> uint_t;
}
extern "C" {
    #[doc = " set wavetable frequency"]
    #[doc = ""]
    #[doc = "\\param o wavetable, created by new_aubio_wavetable()"]
    #[doc = "\\param freq new frequency value for the wavetable"]
    #[doc = ""]
    #[doc = "\\return 0 if successful, 1 otherwise"]
    pub fn aubio_wavetable_set_freq(o: *mut aubio_wavetable_t, freq: smpl_t) -> uint_t;
}
extern "C" {
    #[doc = " get wavetable frequency"]
    #[doc = ""]
    #[doc = "\\param o wavetable, created by new_aubio_wavetable()"]
    #[doc = ""]
    #[doc = "\\return current frequency, in Hz"]
    pub fn aubio_wavetable_get_freq(o: *const aubio_wavetable_t) -> smpl_t;
}
extern "C" {
    #[doc = " set wavetable amplitude"]
    #[doc = ""]
    #[doc = "\\param o wavetable, created by new_aubio_wavetable()"]
    #[doc = "\\param amp new amplitude value for the wavetable"]
    #[doc = ""]
    #[doc = "\\return 0 if successful, 1 otherwise"]
    pub fn aubio_wavetable_set_amp(o: *mut aubio_wavetable_t, amp: smpl_t) -> uint_t;
}
extern "C" {
    #[doc = " get wavetable amplitude"]
    #[doc = ""]
    #[doc = "\\param o wavetable, created by new_aubio_wavetable()"]
    #[doc = ""]
    #[doc = "\\return current amplitude"]
    pub fn aubio_wavetable_get_amp(o: *const aubio_wavetable_t) -> smpl_t;
}
extern "C" {
    #[doc = " destroy aubio_wavetable_t object"]
    #[doc = ""]
    #[doc = "\\param o wavetable, created by new_aubio_wavetable()"]
    pub fn del_aubio_wavetable(o: *mut aubio_wavetable_t);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _aubio_parameter_t {
    _unused: [u8; 0],
}
#[doc = " parameter object"]
pub type aubio_parameter_t = _aubio_parameter_t;
extern "C" {
    #[doc = " create new parameter object"]
    #[doc = ""]
    #[doc = "\\param min_value the minimum value of the new parameter"]
    #[doc = "\\param max_value the maximum value of the new parameter"]
    #[doc = "\\param steps the number of steps to interpolate from the old value to the target value"]
    #[doc = ""]
    #[doc = "\\return the newly created ::aubio_parameter_t"]
    pub fn new_aubio_parameter(
        min_value: smpl_t,
        max_value: smpl_t,
        steps: uint_t,
    ) -> *mut aubio_parameter_t;
}
extern "C" {
    #[doc = " set target value of the parameter"]
    #[doc = ""]
    #[doc = "\\param param parameter, created by ::new_aubio_parameter"]
    #[doc = "\\param value new target value"]
    #[doc = ""]
    #[doc = "\\return 0 if successful, 1 otherwise"]
    pub fn aubio_parameter_set_target_value(param: *mut aubio_parameter_t, value: smpl_t)
        -> uint_t;
}
extern "C" {
    #[doc = " get next parameter"]
    #[doc = ""]
    #[doc = "\\param param parameter, created by ::new_aubio_parameter"]
    #[doc = ""]
    #[doc = "\\return new interpolated parameter value"]
    pub fn aubio_parameter_get_next_value(param: *mut aubio_parameter_t) -> smpl_t;
}
extern "C" {
    #[doc = " get current parameter value, without interpolation"]
    #[doc = ""]
    #[doc = "\\param param parameter, created by ::new_aubio_parameter"]
    #[doc = ""]
    #[doc = "\\return current value"]
    pub fn aubio_parameter_get_current_value(param: *const aubio_parameter_t) -> smpl_t;
}
extern "C" {
    #[doc = " set current parameter value, skipping interpolation"]
    #[doc = ""]
    #[doc = "\\param param parameter, created by ::new_aubio_parameter"]
    #[doc = "\\param value new parameter value"]
    #[doc = ""]
    #[doc = "\\return 0 if successful, 1 otherwise"]
    pub fn aubio_parameter_set_current_value(
        param: *mut aubio_parameter_t,
        value: smpl_t,
    ) -> uint_t;
}
extern "C" {
    #[doc = " set number of steps used for interpolation"]
    #[doc = ""]
    #[doc = "\\param param parameter, created by ::new_aubio_parameter"]
    #[doc = "\\param steps new number of steps"]
    #[doc = ""]
    #[doc = "\\return 0 if successful, 1 otherwise"]
    pub fn aubio_parameter_set_steps(param: *mut aubio_parameter_t, steps: uint_t) -> uint_t;
}
extern "C" {
    #[doc = " get number of steps of this parameter"]
    #[doc = ""]
    #[doc = "\\param param parameter, created by ::new_aubio_parameter"]
    #[doc = ""]
    #[doc = "\\return number of steps"]
    pub fn aubio_parameter_get_steps(param: *const aubio_parameter_t) -> uint_t;
}
extern "C" {
    #[doc = " set minimum value of this parameter"]
    #[doc = ""]
    #[doc = "\\param param parameter, created by ::new_aubio_parameter"]
    #[doc = "\\param min_value new minimum value"]
    #[doc = ""]
    #[doc = "\\return 0 if successful, 1 otherwise"]
    pub fn aubio_parameter_set_min_value(
        param: *mut aubio_parameter_t,
        min_value: smpl_t,
    ) -> uint_t;
}
extern "C" {
    #[doc = " get minimum value of this parameter"]
    #[doc = ""]
    #[doc = "\\param param parameter, created by ::new_aubio_parameter"]
    #[doc = ""]
    #[doc = "\\return minimum value"]
    pub fn aubio_parameter_get_min_value(param: *const aubio_parameter_t) -> smpl_t;
}
extern "C" {
    #[doc = " set maximum value of this parameter"]
    #[doc = ""]
    #[doc = "\\param param parameter, created by ::new_aubio_parameter"]
    #[doc = "\\param max_value new maximum value"]
    #[doc = ""]
    #[doc = "\\return 0 if successful, 1 otherwise"]
    pub fn aubio_parameter_set_max_value(
        param: *mut aubio_parameter_t,
        max_value: smpl_t,
    ) -> uint_t;
}
extern "C" {
    #[doc = " get maximum value of this parameter"]
    #[doc = ""]
    #[doc = "\\param param parameter, created by ::new_aubio_parameter"]
    #[doc = ""]
    #[doc = "\\return maximum value"]
    pub fn aubio_parameter_get_max_value(param: *const aubio_parameter_t) -> smpl_t;
}
extern "C" {
    #[doc = " destroy ::aubio_parameter_t object"]
    #[doc = ""]
    #[doc = "\\param param parameter, created by ::new_aubio_parameter"]
    pub fn del_aubio_parameter(param: *mut aubio_parameter_t);
}
#[doc = "< critical errors"]
pub const aubio_log_level_AUBIO_LOG_ERR: aubio_log_level = 0;
#[doc = "< infos"]
pub const aubio_log_level_AUBIO_LOG_INF: aubio_log_level = 1;
#[doc = "< general messages"]
pub const aubio_log_level_AUBIO_LOG_MSG: aubio_log_level = 2;
#[doc = "< debug messages"]
pub const aubio_log_level_AUBIO_LOG_DBG: aubio_log_level = 3;
#[doc = "< warnings"]
pub const aubio_log_level_AUBIO_LOG_WRN: aubio_log_level = 4;
#[doc = "< number of valid levels"]
pub const aubio_log_level_AUBIO_LOG_LAST_LEVEL: aubio_log_level = 5;
#[doc = " list of logging levels"]
pub type aubio_log_level = ::std::os::raw::c_int;
#[doc = " Logging function prototype, to be passed to ::aubio_log_set_function"]
#[doc = ""]
#[doc = "\\param level log level"]
#[doc = "\\param message text to log"]
#[doc = "\\param data optional closure used by the callback"]
#[doc = ""]
#[doc = "See @ref utils/test-log.c for an example of logging function."]
#[doc = ""]
pub type aubio_log_function_t = ::std::option::Option<
    unsafe extern "C" fn(level: sint_t, message: *const char_t, data: *mut ::std::os::raw::c_void),
>;
extern "C" {
    #[doc = " Set logging function for all levels"]
    #[doc = ""]
    #[doc = "\\param fun the function to be used to log, of type ::aubio_log_function_t"]
    #[doc = "\\param data optional closure to be passed to the function (can be NULL if"]
    #[doc = "nothing to pass)"]
    #[doc = ""]
    pub fn aubio_log_set_function(fun: aubio_log_function_t, data: *mut ::std::os::raw::c_void);
}
extern "C" {
    #[doc = " Set logging function for a given level"]
    #[doc = ""]
    #[doc = "\\param level the level for which to set the logging function"]
    #[doc = "\\param fun the function to be used to log, of type ::aubio_log_function_t"]
    #[doc = "\\param data optional closure to be passed to the function (can be NULL if"]
    #[doc = "nothing to pass)"]
    pub fn aubio_log_set_level_function(
        level: sint_t,
        fun: aubio_log_function_t,
        data: *mut ::std::os::raw::c_void,
    ) -> aubio_log_function_t;
}
extern "C" {
    #[doc = " Reset all logging functions to the default one"]
    #[doc = ""]
    #[doc = "After calling this function, the default logging function will be used to"]
    #[doc = "print error, warning, normal, and debug messages to `stdout` or `stderr`."]
    #[doc = ""]
    pub fn aubio_log_reset();
}
