#[doc = "Register `DACC_IER` writer"]
pub struct W(crate::W<DACC_IER_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<DACC_IER_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<DACC_IER_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<DACC_IER_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `TXRDY0` writer - Transmit Ready Interrupt Enable of channel 0"]
pub struct TXRDY0_W<'a> {
    w: &'a mut W,
}
impl<'a> TXRDY0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u32 & 0x01);
        self.w
    }
}
#[doc = "Field `TXRDY1` writer - Transmit Ready Interrupt Enable of channel 1"]
pub struct TXRDY1_W<'a> {
    w: &'a mut W,
}
impl<'a> TXRDY1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u32 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `EOC0` writer - End of Conversion Interrupt Enable of channel 0"]
pub struct EOC0_W<'a> {
    w: &'a mut W,
}
impl<'a> EOC0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u32 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `EOC1` writer - End of Conversion Interrupt Enable of channel 1"]
pub struct EOC1_W<'a> {
    w: &'a mut W,
}
impl<'a> EOC1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u32 & 0x01) << 5);
        self.w
    }
}
impl W {
    #[doc = "Bit 0 - Transmit Ready Interrupt Enable of channel 0"]
    #[inline(always)]
    pub fn txrdy0(&mut self) -> TXRDY0_W {
        TXRDY0_W { w: self }
    }
    #[doc = "Bit 1 - Transmit Ready Interrupt Enable of channel 1"]
    #[inline(always)]
    pub fn txrdy1(&mut self) -> TXRDY1_W {
        TXRDY1_W { w: self }
    }
    #[doc = "Bit 4 - End of Conversion Interrupt Enable of channel 0"]
    #[inline(always)]
    pub fn eoc0(&mut self) -> EOC0_W {
        EOC0_W { w: self }
    }
    #[doc = "Bit 5 - End of Conversion Interrupt Enable of channel 1"]
    #[inline(always)]
    pub fn eoc1(&mut self) -> EOC1_W {
        EOC1_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Interrupt Enable Register\n\nThis register you can [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [dacc_ier](index.html) module"]
pub struct DACC_IER_SPEC;
impl crate::RegisterSpec for DACC_IER_SPEC {
    type Ux = u32;
}
#[doc = "`write(|w| ..)` method takes [dacc_ier::W](W) writer structure"]
impl crate::Writable for DACC_IER_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets DACC_IER to value 0"]
impl crate::Resettable for DACC_IER_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
