#[doc = "Register `MATRIX_PRBS` reader"]
pub struct R(crate::R<MATRIX_PRBS_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<MATRIX_PRBS_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<MATRIX_PRBS_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<MATRIX_PRBS_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `MATRIX_PRBS` writer"]
pub struct W(crate::W<MATRIX_PRBS_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<MATRIX_PRBS_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<MATRIX_PRBS_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<MATRIX_PRBS_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `M8PR` reader - Master 8 Priority"]
pub struct M8PR_R(crate::FieldReader<u8, u8>);
impl M8PR_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        M8PR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for M8PR_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `M8PR` writer - Master 8 Priority"]
pub struct M8PR_W<'a> {
    w: &'a mut W,
}
impl<'a> M8PR_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x03) | (value as u32 & 0x03);
        self.w
    }
}
#[doc = "Field `M12PR` reader - Master 12 Priority"]
pub struct M12PR_R(crate::FieldReader<u8, u8>);
impl M12PR_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        M12PR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for M12PR_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `M12PR` writer - Master 12 Priority"]
pub struct M12PR_W<'a> {
    w: &'a mut W,
}
impl<'a> M12PR_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 16)) | ((value as u32 & 0x03) << 16);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:1 - Master 8 Priority"]
    #[inline(always)]
    pub fn m8pr(&self) -> M8PR_R {
        M8PR_R::new((self.bits & 0x03) as u8)
    }
    #[doc = "Bits 16:17 - Master 12 Priority"]
    #[inline(always)]
    pub fn m12pr(&self) -> M12PR_R {
        M12PR_R::new(((self.bits >> 16) & 0x03) as u8)
    }
}
impl W {
    #[doc = "Bits 0:1 - Master 8 Priority"]
    #[inline(always)]
    pub fn m8pr(&mut self) -> M8PR_W {
        M8PR_W { w: self }
    }
    #[doc = "Bits 16:17 - Master 12 Priority"]
    #[inline(always)]
    pub fn m12pr(&mut self) -> M12PR_W {
        M12PR_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Priority Register B for Slave 0\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [matrix_prbs](index.html) module"]
pub struct MATRIX_PRBS_SPEC;
impl crate::RegisterSpec for MATRIX_PRBS_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [matrix_prbs::R](R) reader structure"]
impl crate::Readable for MATRIX_PRBS_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [matrix_prbs::W](W) writer structure"]
impl crate::Writable for MATRIX_PRBS_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets MATRIX_PRBS to value 0"]
impl crate::Resettable for MATRIX_PRBS_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
