#[doc = r"Register block"]
#[repr(C)]
pub struct RegisterBlock {
    #[doc = "0x00 - Control A"]
    pub ctrla: CTRLA,
    #[doc = "0x04 - Control B"]
    pub ctrlb: CTRLB,
    #[doc = "0x08 - Baud Rate"]
    pub baud: BAUD,
    #[doc = "0x0c - Receive Data"]
    pub rxdata: RXDATA,
    #[doc = "0x10 - Transmit Data"]
    pub txdata: TXDATA,
    #[doc = "0x14 - Interrupt Enable Clear"]
    pub intenclr: INTENCLR,
    #[doc = "0x18 - Interrupt Enable Set"]
    pub intenset: INTENSET,
    #[doc = "0x1c - Interrupt Flag Status and Clear"]
    pub intflag: INTFLAG,
    #[doc = "0x20 - Status Register"]
    pub status: STATUS,
    _reserved9: [u8; 12usize],
    #[doc = "0x30 - Instruction Address"]
    pub instraddr: INSTRADDR,
    #[doc = "0x34 - Instruction Code"]
    pub instrctrl: INSTRCTRL,
    #[doc = "0x38 - Instruction Frame"]
    pub instrframe: INSTRFRAME,
    _reserved12: [u8; 4usize],
    #[doc = "0x40 - Scrambling Mode"]
    pub scrambctrl: SCRAMBCTRL,
    #[doc = "0x44 - Scrambling Key"]
    pub scrambkey: SCRAMBKEY,
}
#[doc = "Control A\n\nThis register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [ctrla](ctrla) module"]
pub type CTRLA = crate::Reg<u32, _CTRLA>;
#[allow(missing_docs)]
#[doc(hidden)]
pub struct _CTRLA;
#[doc = "`read()` method returns [ctrla::R](ctrla::R) reader structure"]
impl crate::Readable for CTRLA {}
#[doc = "`write(|w| ..)` method takes [ctrla::W](ctrla::W) writer structure"]
impl crate::Writable for CTRLA {}
#[doc = "Control A"]
pub mod ctrla;
#[doc = "Control B\n\nThis register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [ctrlb](ctrlb) module"]
pub type CTRLB = crate::Reg<u32, _CTRLB>;
#[allow(missing_docs)]
#[doc(hidden)]
pub struct _CTRLB;
#[doc = "`read()` method returns [ctrlb::R](ctrlb::R) reader structure"]
impl crate::Readable for CTRLB {}
#[doc = "`write(|w| ..)` method takes [ctrlb::W](ctrlb::W) writer structure"]
impl crate::Writable for CTRLB {}
#[doc = "Control B"]
pub mod ctrlb;
#[doc = "Baud Rate\n\nThis register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [baud](baud) module"]
pub type BAUD = crate::Reg<u32, _BAUD>;
#[allow(missing_docs)]
#[doc(hidden)]
pub struct _BAUD;
#[doc = "`read()` method returns [baud::R](baud::R) reader structure"]
impl crate::Readable for BAUD {}
#[doc = "`write(|w| ..)` method takes [baud::W](baud::W) writer structure"]
impl crate::Writable for BAUD {}
#[doc = "Baud Rate"]
pub mod baud;
#[doc = "Receive Data\n\nThis register you can [`read`](crate::generic::Reg::read). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [rxdata](rxdata) module"]
pub type RXDATA = crate::Reg<u32, _RXDATA>;
#[allow(missing_docs)]
#[doc(hidden)]
pub struct _RXDATA;
#[doc = "`read()` method returns [rxdata::R](rxdata::R) reader structure"]
impl crate::Readable for RXDATA {}
#[doc = "Receive Data"]
pub mod rxdata;
#[doc = "Transmit Data\n\nThis register you can [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [txdata](txdata) module"]
pub type TXDATA = crate::Reg<u32, _TXDATA>;
#[allow(missing_docs)]
#[doc(hidden)]
pub struct _TXDATA;
#[doc = "`write(|w| ..)` method takes [txdata::W](txdata::W) writer structure"]
impl crate::Writable for TXDATA {}
#[doc = "Transmit Data"]
pub mod txdata;
#[doc = "Interrupt Enable Clear\n\nThis register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [intenclr](intenclr) module"]
pub type INTENCLR = crate::Reg<u32, _INTENCLR>;
#[allow(missing_docs)]
#[doc(hidden)]
pub struct _INTENCLR;
#[doc = "`read()` method returns [intenclr::R](intenclr::R) reader structure"]
impl crate::Readable for INTENCLR {}
#[doc = "`write(|w| ..)` method takes [intenclr::W](intenclr::W) writer structure"]
impl crate::Writable for INTENCLR {}
#[doc = "Interrupt Enable Clear"]
pub mod intenclr;
#[doc = "Interrupt Enable Set\n\nThis register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [intenset](intenset) module"]
pub type INTENSET = crate::Reg<u32, _INTENSET>;
#[allow(missing_docs)]
#[doc(hidden)]
pub struct _INTENSET;
#[doc = "`read()` method returns [intenset::R](intenset::R) reader structure"]
impl crate::Readable for INTENSET {}
#[doc = "`write(|w| ..)` method takes [intenset::W](intenset::W) writer structure"]
impl crate::Writable for INTENSET {}
#[doc = "Interrupt Enable Set"]
pub mod intenset;
#[doc = "Interrupt Flag Status and Clear\n\nThis register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [intflag](intflag) module"]
pub type INTFLAG = crate::Reg<u32, _INTFLAG>;
#[allow(missing_docs)]
#[doc(hidden)]
pub struct _INTFLAG;
#[doc = "`read()` method returns [intflag::R](intflag::R) reader structure"]
impl crate::Readable for INTFLAG {}
#[doc = "`write(|w| ..)` method takes [intflag::W](intflag::W) writer structure"]
impl crate::Writable for INTFLAG {}
#[doc = "Interrupt Flag Status and Clear"]
pub mod intflag;
#[doc = "Status Register\n\nThis register you can [`read`](crate::generic::Reg::read). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [status](status) module"]
pub type STATUS = crate::Reg<u32, _STATUS>;
#[allow(missing_docs)]
#[doc(hidden)]
pub struct _STATUS;
#[doc = "`read()` method returns [status::R](status::R) reader structure"]
impl crate::Readable for STATUS {}
#[doc = "Status Register"]
pub mod status;
#[doc = "Instruction Address\n\nThis register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [instraddr](instraddr) module"]
pub type INSTRADDR = crate::Reg<u32, _INSTRADDR>;
#[allow(missing_docs)]
#[doc(hidden)]
pub struct _INSTRADDR;
#[doc = "`read()` method returns [instraddr::R](instraddr::R) reader structure"]
impl crate::Readable for INSTRADDR {}
#[doc = "`write(|w| ..)` method takes [instraddr::W](instraddr::W) writer structure"]
impl crate::Writable for INSTRADDR {}
#[doc = "Instruction Address"]
pub mod instraddr;
#[doc = "Instruction Code\n\nThis register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [instrctrl](instrctrl) module"]
pub type INSTRCTRL = crate::Reg<u32, _INSTRCTRL>;
#[allow(missing_docs)]
#[doc(hidden)]
pub struct _INSTRCTRL;
#[doc = "`read()` method returns [instrctrl::R](instrctrl::R) reader structure"]
impl crate::Readable for INSTRCTRL {}
#[doc = "`write(|w| ..)` method takes [instrctrl::W](instrctrl::W) writer structure"]
impl crate::Writable for INSTRCTRL {}
#[doc = "Instruction Code"]
pub mod instrctrl;
#[doc = "Instruction Frame\n\nThis register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [instrframe](instrframe) module"]
pub type INSTRFRAME = crate::Reg<u32, _INSTRFRAME>;
#[allow(missing_docs)]
#[doc(hidden)]
pub struct _INSTRFRAME;
#[doc = "`read()` method returns [instrframe::R](instrframe::R) reader structure"]
impl crate::Readable for INSTRFRAME {}
#[doc = "`write(|w| ..)` method takes [instrframe::W](instrframe::W) writer structure"]
impl crate::Writable for INSTRFRAME {}
#[doc = "Instruction Frame"]
pub mod instrframe;
#[doc = "Scrambling Mode\n\nThis register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [scrambctrl](scrambctrl) module"]
pub type SCRAMBCTRL = crate::Reg<u32, _SCRAMBCTRL>;
#[allow(missing_docs)]
#[doc(hidden)]
pub struct _SCRAMBCTRL;
#[doc = "`read()` method returns [scrambctrl::R](scrambctrl::R) reader structure"]
impl crate::Readable for SCRAMBCTRL {}
#[doc = "`write(|w| ..)` method takes [scrambctrl::W](scrambctrl::W) writer structure"]
impl crate::Writable for SCRAMBCTRL {}
#[doc = "Scrambling Mode"]
pub mod scrambctrl;
#[doc = "Scrambling Key\n\nThis register you can [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [scrambkey](scrambkey) module"]
pub type SCRAMBKEY = crate::Reg<u32, _SCRAMBKEY>;
#[allow(missing_docs)]
#[doc(hidden)]
pub struct _SCRAMBKEY;
#[doc = "`write(|w| ..)` method takes [scrambkey::W](scrambkey::W) writer structure"]
impl crate::Writable for SCRAMBKEY {}
#[doc = "Scrambling Key"]
pub mod scrambkey;
