#![doc = "Peripheral access API for ATSAMD51P microcontrollers (generated using svd2rust v0.20.0 ( ))\n\nYou can find an overview of the generated API [here].\n\nAPI features to be included in the [next]
svd2rust release can be generated by cloning the svd2rust [repository], checking out the above commit, and running `cargo doc --open`.\n\n[here]: https://docs.rs/svd2rust/0.20.0/svd2rust/#peripheral-api\n[next]: https://github.com/rust-embedded/svd2rust/blob/master/CHANGELOG.md#unreleased\n[repository]: https://github.com/rust-embedded/svd2rust"]
#![deny(const_err)]
#![deny(dead_code)]
#![deny(improper_ctypes)]
#![deny(missing_docs)]
#![deny(no_mangle_generic_items)]
#![deny(non_shorthand_field_patterns)]
#![deny(overflowing_literals)]
#![deny(path_statements)]
#![deny(patterns_in_fns_without_body)]
#![deny(private_in_public)]
#![deny(unconditional_recursion)]
#![deny(unused_allocation)]
#![deny(unused_comparisons)]
#![deny(unused_parens)]
#![deny(while_true)]
#![allow(non_camel_case_types)]
#![allow(non_snake_case)]
#![allow(clippy::all)]
#![no_std]
use core::marker::PhantomData;
use core::ops::Deref;
#[doc = r"Number available in the NVIC for configuring priority"]
pub const NVIC_PRIO_BITS: u8 = 3;
#[cfg(feature = "rt")]
pub use self::Interrupt as interrupt;
pub use cortex_m::peripheral::Peripherals as CorePeripherals;
pub use cortex_m::peripheral::{CBP, CPUID, DCB, DWT, FPB, FPU, ITM, MPU, NVIC, SCB, SYST, TPIU};
#[cfg(feature = "rt")]
pub use cortex_m_rt::interrupt;
#[allow(unused_imports)]
use generic::*;
#[doc = r"Common register and bit access and modify traits"]
pub mod generic;
#[cfg(feature = "rt")]
extern "C" {
    fn PM();
    fn MCLK();
    fn OSCCTRL_XOSC0();
    fn OSCCTRL_XOSC1();
    fn OSCCTRL_DFLL();
    fn OSCCTRL_DPLL0();
    fn OSCCTRL_DPLL1();
    fn OSC32KCTRL();
    fn SUPC_OTHER();
    fn SUPC_BODDET();
    fn WDT();
    fn RTC();
    fn EIC_EXTINT_0();
    fn EIC_EXTINT_1();
    fn EIC_EXTINT_2();
    fn EIC_EXTINT_3();
    fn EIC_EXTINT_4();
    fn EIC_EXTINT_5();
    fn EIC_EXTINT_6();
    fn EIC_EXTINT_7();
    fn EIC_EXTINT_8();
    fn EIC_EXTINT_9();
    fn EIC_EXTINT_10();
    fn EIC_EXTINT_11();
    fn EIC_EXTINT_12();
    fn EIC_EXTINT_13();
    fn EIC_EXTINT_14();
    fn EIC_EXTINT_15();
    fn FREQM();
    fn NVMCTRL_0();
    fn NVMCTRL_1();
    fn DMAC_0();
    fn DMAC_1();
    fn DMAC_2();
    fn DMAC_3();
    fn DMAC_OTHER();
    fn EVSYS_0();
    fn EVSYS_1();
    fn EVSYS_2();
    fn EVSYS_3();
    fn EVSYS_OTHER();
    fn PAC();
    fn RAMECC();
    fn SERCOM0_0();
    fn SERCOM0_1();
    fn SERCOM0_2();
    fn SERCOM0_OTHER();
    fn SERCOM1_0();
    fn SERCOM1_1();
    fn SERCOM1_2();
    fn SERCOM1_OTHER();
    fn SERCOM2_0();
    fn SERCOM2_1();
    fn SERCOM2_2();
    fn SERCOM2_OTHER();
    fn SERCOM3_0();
    fn SERCOM3_1();
    fn SERCOM3_2();
    fn SERCOM3_OTHER();
    fn SERCOM4_0();
    fn SERCOM4_1();
    fn SERCOM4_2();
    fn SERCOM4_OTHER();
    fn SERCOM5_0();
    fn SERCOM5_1();
    fn SERCOM5_2();
    fn SERCOM5_OTHER();
    fn SERCOM6_0();
    fn SERCOM6_1();
    fn SERCOM6_2();
    fn SERCOM6_OTHER();
    fn SERCOM7_0();
    fn SERCOM7_1();
    fn SERCOM7_2();
    fn SERCOM7_OTHER();
    fn USB_OTHER();
    fn USB_SOF_HSOF();
    fn USB_TRCPT0();
    fn USB_TRCPT1();
    fn TCC0_OTHER();
    fn TCC0_MC0();
    fn TCC0_MC1();
    fn TCC0_MC2();
    fn TCC0_MC3();
    fn TCC0_MC4();
    fn TCC0_MC5();
    fn TCC1_OTHER();
    fn TCC1_MC0();
    fn TCC1_MC1();
    fn TCC1_MC2();
    fn TCC1_MC3();
    fn TCC2_OTHER();
    fn TCC2_MC0();
    fn TCC2_MC1();
    fn TCC2_MC2();
    fn TCC3_OTHER();
    fn TCC3_MC0();
    fn TCC3_MC1();
    fn TCC4_OTHER();
    fn TCC4_MC0();
    fn TCC4_MC1();
    fn TC0();
    fn TC1();
    fn TC2();
    fn TC3();
    fn TC4();
    fn TC5();
    fn TC6();
    fn TC7();
    fn PDEC_OTHER();
    fn PDEC_MC0();
    fn PDEC_MC1();
    fn ADC0_OTHER();
    fn ADC0_RESRDY();
    fn ADC1_OTHER();
    fn ADC1_RESRDY();
    fn AC();
    fn DAC_OTHER();
    fn DAC_EMPTY_0();
    fn DAC_EMPTY_1();
    fn DAC_RESRDY_0();
    fn DAC_RESRDY_1();
    fn I2S();
    fn PCC();
    fn AES();
    fn TRNG();
    fn ICM();
    fn QSPI();
    fn SDHC0();
    fn SDHC1();
}
#[doc(hidden)]
pub union Vector {
    _handler: unsafe extern "C" fn(),
    _reserved: u32,
}
#[cfg(feature = "rt")]
#[doc(hidden)]
#[link_section = ".vector_table.interrupts"]
#[no_mangle]
pub static __INTERRUPTS: [Vector; 137] = [
    Vector { _handler: PM },
    Vector { _handler: MCLK },
    Vector {
        _handler: OSCCTRL_XOSC0,
    },
    Vector {
        _handler: OSCCTRL_XOSC1,
    },
    Vector {
        _handler: OSCCTRL_DFLL,
    },
    Vector {
        _handler: OSCCTRL_DPLL0,
    },
    Vector {
        _handler: OSCCTRL_DPLL1,
    },
    Vector {
        _handler: OSC32KCTRL,
    },
    Vector {
        _handler: SUPC_OTHER,
    },
    Vector {
        _handler: SUPC_BODDET,
    },
    Vector { _handler: WDT },
    Vector { _handler: RTC },
    Vector {
        _handler: EIC_EXTINT_0,
    },
    Vector {
        _handler: EIC_EXTINT_1,
    },
    Vector {
        _handler: EIC_EXTINT_2,
    },
    Vector {
        _handler: EIC_EXTINT_3,
    },
    Vector {
        _handler: EIC_EXTINT_4,
    },
    Vector {
        _handler: EIC_EXTINT_5,
    },
    Vector {
        _handler: EIC_EXTINT_6,
    },
    Vector {
        _handler: EIC_EXTINT_7,
    },
    Vector {
        _handler: EIC_EXTINT_8,
    },
    Vector {
        _handler: EIC_EXTINT_9,
    },
    Vector {
        _handler: EIC_EXTINT_10,
    },
    Vector {
        _handler: EIC_EXTINT_11,
    },
    Vector {
        _handler: EIC_EXTINT_12,
    },
    Vector {
        _handler: EIC_EXTINT_13,
    },
    Vector {
        _handler: EIC_EXTINT_14,
    },
    Vector {
        _handler: EIC_EXTINT_15,
    },
    Vector { _handler: FREQM },
    Vector {
        _handler: NVMCTRL_0,
    },
    Vector {
        _handler: NVMCTRL_1,
    },
    Vector { _handler: DMAC_0 },
    Vector { _handler: DMAC_1 },
    Vector { _handler: DMAC_2 },
    Vector { _handler: DMAC_3 },
    Vector {
        _handler: DMAC_OTHER,
    },
    Vector { _handler: EVSYS_0 },
    Vector { _handler: EVSYS_1 },
    Vector { _handler: EVSYS_2 },
    Vector { _handler: EVSYS_3 },
    Vector {
        _handler: EVSYS_OTHER,
    },
    Vector { _handler: PAC },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _handler: RAMECC },
    Vector {
        _handler: SERCOM0_0,
    },
    Vector {
        _handler: SERCOM0_1,
    },
    Vector {
        _handler: SERCOM0_2,
    },
    Vector {
        _handler: SERCOM0_OTHER,
    },
    Vector {
        _handler: SERCOM1_0,
    },
    Vector {
        _handler: SERCOM1_1,
    },
    Vector {
        _handler: SERCOM1_2,
    },
    Vector {
        _handler: SERCOM1_OTHER,
    },
    Vector {
        _handler: SERCOM2_0,
    },
    Vector {
        _handler: SERCOM2_1,
    },
    Vector {
        _handler: SERCOM2_2,
    },
    Vector {
        _handler: SERCOM2_OTHER,
    },
    Vector {
        _handler: SERCOM3_0,
    },
    Vector {
        _handler: SERCOM3_1,
    },
    Vector {
        _handler: SERCOM3_2,
    },
    Vector {
        _handler: SERCOM3_OTHER,
    },
    Vector {
        _handler: SERCOM4_0,
    },
    Vector {
        _handler: SERCOM4_1,
    },
    Vector {
        _handler: SERCOM4_2,
    },
    Vector {
        _handler: SERCOM4_OTHER,
    },
    Vector {
        _handler: SERCOM5_0,
    },
    Vector {
        _handler: SERCOM5_1,
    },
    Vector {
        _handler: SERCOM5_2,
    },
    Vector {
        _handler: SERCOM5_OTHER,
    },
    Vector {
        _handler: SERCOM6_0,
    },
    Vector {
        _handler: SERCOM6_1,
    },
    Vector {
        _handler: SERCOM6_2,
    },
    Vector {
        _handler: SERCOM6_OTHER,
    },
    Vector {
        _handler: SERCOM7_0,
    },
    Vector {
        _handler: SERCOM7_1,
    },
    Vector {
        _handler: SERCOM7_2,
    },
    Vector {
        _handler: SERCOM7_OTHER,
    },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector {
        _handler: USB_OTHER,
    },
    Vector {
        _handler: USB_SOF_HSOF,
    },
    Vector {
        _handler: USB_TRCPT0,
    },
    Vector {
        _handler: USB_TRCPT1,
    },
    Vector { _reserved: 0 },
    Vector {
        _handler: TCC0_OTHER,
    },
    Vector { _handler: TCC0_MC0 },
    Vector { _handler: TCC0_MC1 },
    Vector { _handler: TCC0_MC2 },
    Vector { _handler: TCC0_MC3 },
    Vector { _handler: TCC0_MC4 },
    Vector { _handler: TCC0_MC5 },
    Vector {
        _handler: TCC1_OTHER,
    },
    Vector { _handler: TCC1_MC0 },
    Vector { _handler: TCC1_MC1 },
    Vector { _handler: TCC1_MC2 },
    Vector { _handler: TCC1_MC3 },
    Vector {
        _handler: TCC2_OTHER,
    },
    Vector { _handler: TCC2_MC0 },
    Vector { _handler: TCC2_MC1 },
    Vector { _handler: TCC2_MC2 },
    Vector {
        _handler: TCC3_OTHER,
    },
    Vector { _handler: TCC3_MC0 },
    Vector { _handler: TCC3_MC1 },
    Vector {
        _handler: TCC4_OTHER,
    },
    Vector { _handler: TCC4_MC0 },
    Vector { _handler: TCC4_MC1 },
    Vector { _handler: TC0 },
    Vector { _handler: TC1 },
    Vector { _handler: TC2 },
    Vector { _handler: TC3 },
    Vector { _handler: TC4 },
    Vector { _handler: TC5 },
    Vector { _handler: TC6 },
    Vector { _handler: TC7 },
    Vector {
        _handler: PDEC_OTHER,
    },
    Vector { _handler: PDEC_MC0 },
    Vector { _handler: PDEC_MC1 },
    Vector {
        _handler: ADC0_OTHER,
    },
    Vector {
        _handler: ADC0_RESRDY,
    },
    Vector {
        _handler: ADC1_OTHER,
    },
    Vector {
        _handler: ADC1_RESRDY,
    },
    Vector { _handler: AC },
    Vector {
        _handler: DAC_OTHER,
    },
    Vector {
        _handler: DAC_EMPTY_0,
    },
    Vector {
        _handler: DAC_EMPTY_1,
    },
    Vector {
        _handler: DAC_RESRDY_0,
    },
    Vector {
        _handler: DAC_RESRDY_1,
    },
    Vector { _handler: I2S },
    Vector { _handler: PCC },
    Vector { _handler: AES },
    Vector { _handler: TRNG },
    Vector { _handler: ICM },
    Vector { _reserved: 0 },
    Vector { _handler: QSPI },
    Vector { _handler: SDHC0 },
    Vector { _handler: SDHC1 },
];
#[doc = r"Enumeration of all the interrupts."]
#[derive(Copy, Clone, Debug, PartialEq, Eq)]
#[repr(u16)]
pub enum Interrupt {
    #[doc = "0 - PM"]
    PM = 0,
    #[doc = "1 - MCLK"]
    MCLK = 1,
    #[doc = "2 - OSCCTRL_XOSC0"]
    OSCCTRL_XOSC0 = 2,
    #[doc = "3 - OSCCTRL_XOSC1"]
    OSCCTRL_XOSC1 = 3,
    #[doc = "4 - OSCCTRL_DFLL"]
    OSCCTRL_DFLL = 4,
    #[doc = "5 - OSCCTRL_DPLL0"]
    OSCCTRL_DPLL0 = 5,
    #[doc = "6 - OSCCTRL_DPLL1"]
    OSCCTRL_DPLL1 = 6,
    #[doc = "7 - OSC32KCTRL"]
    OSC32KCTRL = 7,
    #[doc = "8 - SUPC_OTHER"]
    SUPC_OTHER = 8,
    #[doc = "9 - SUPC_BODDET"]
    SUPC_BODDET = 9,
    #[doc = "10 - WDT"]
    WDT = 10,
    #[doc = "11 - RTC"]
    RTC = 11,
    #[doc = "12 - EIC_EXTINT_0"]
    EIC_EXTINT_0 = 12,
    #[doc = "13 - EIC_EXTINT_1"]
    EIC_EXTINT_1 = 13,
    #[doc = "14 - EIC_EXTINT_2"]
    EIC_EXTINT_2 = 14,
    #[doc = "15 - EIC_EXTINT_3"]
    EIC_EXTINT_3 = 15,
    #[doc = "16 - EIC_EXTINT_4"]
    EIC_EXTINT_4 = 16,
    #[doc = "17 - EIC_EXTINT_5"]
    EIC_EXTINT_5 = 17,
    #[doc = "18 - EIC_EXTINT_6"]
    EIC_EXTINT_6 = 18,
    #[doc = "19 - EIC_EXTINT_7"]
    EIC_EXTINT_7 = 19,
    #[doc = "20 - EIC_EXTINT_8"]
    EIC_EXTINT_8 = 20,
    #[doc = "21 - EIC_EXTINT_9"]
    EIC_EXTINT_9 = 21,
    #[doc = "22 - EIC_EXTINT_10"]
    EIC_EXTINT_10 = 22,
    #[doc = "23 - EIC_EXTINT_11"]
    EIC_EXTINT_11 = 23,
    #[doc = "24 - EIC_EXTINT_12"]
    EIC_EXTINT_12 = 24,
    #[doc = "25 - EIC_EXTINT_13"]
    EIC_EXTINT_13 = 25,
    #[doc = "26 - EIC_EXTINT_14"]
    EIC_EXTINT_14 = 26,
    #[doc = "27 - EIC_EXTINT_15"]
    EIC_EXTINT_15 = 27,
    #[doc = "28 - FREQM"]
    FREQM = 28,
    #[doc = "29 - NVMCTRL_0"]
    NVMCTRL_0 = 29,
    #[doc = "30 - NVMCTRL_1"]
    NVMCTRL_1 = 30,
    #[doc = "31 - DMAC_0"]
    DMAC_0 = 31,
    #[doc = "32 - DMAC_1"]
    DMAC_1 = 32,
    #[doc = "33 - DMAC_2"]
    DMAC_2 = 33,
    #[doc = "34 - DMAC_3"]
    DMAC_3 = 34,
    #[doc = "35 - DMAC_OTHER"]
    DMAC_OTHER = 35,
    #[doc = "36 - EVSYS_0"]
    EVSYS_0 = 36,
    #[doc = "37 - EVSYS_1"]
    EVSYS_1 = 37,
    #[doc = "38 - EVSYS_2"]
    EVSYS_2 = 38,
    #[doc = "39 - EVSYS_3"]
    EVSYS_3 = 39,
    #[doc = "40 - EVSYS_OTHER"]
    EVSYS_OTHER = 40,
    #[doc = "41 - PAC"]
    PAC = 41,
    #[doc = "45 - RAMECC"]
    RAMECC = 45,
    #[doc = "46 - SERCOM0_0"]
    SERCOM0_0 = 46,
    #[doc = "47 - SERCOM0_1"]
    SERCOM0_1 = 47,
    #[doc = "48 - SERCOM0_2"]
    SERCOM0_2 = 48,
    #[doc = "49 - SERCOM0_OTHER"]
    SERCOM0_OTHER = 49,
    #[doc = "50 - SERCOM1_0"]
    SERCOM1_0 = 50,
    #[doc = "51 - SERCOM1_1"]
    SERCOM1_1 = 51,
    #[doc = "52 - SERCOM1_2"]
    SERCOM1_2 = 52,
    #[doc = "53 - SERCOM1_OTHER"]
    SERCOM1_OTHER = 53,
    #[doc = "54 - SERCOM2_0"]
    SERCOM2_0 = 54,
    #[doc = "55 - SERCOM2_1"]
    SERCOM2_1 = 55,
    #[doc = "56 - SERCOM2_2"]
    SERCOM2_2 = 56,
    #[doc = "57 - SERCOM2_OTHER"]
    SERCOM2_OTHER = 57,
    #[doc = "58 - SERCOM3_0"]
    SERCOM3_0 = 58,
    #[doc = "59 - SERCOM3_1"]
    SERCOM3_1 = 59,
    #[doc = "60 - SERCOM3_2"]
    SERCOM3_2 = 60,
    #[doc = "61 - SERCOM3_OTHER"]
    SERCOM3_OTHER = 61,
    #[doc = "62 - SERCOM4_0"]
    SERCOM4_0 = 62,
    #[doc = "63 - SERCOM4_1"]
    SERCOM4_1 = 63,
    #[doc = "64 - SERCOM4_2"]
    SERCOM4_2 = 64,
    #[doc = "65 - SERCOM4_OTHER"]
    SERCOM4_OTHER = 65,
    #[doc = "66 - SERCOM5_0"]
    SERCOM5_0 = 66,
    #[doc = "67 - SERCOM5_1"]
    SERCOM5_1 = 67,
    #[doc = "68 - SERCOM5_2"]
    SERCOM5_2 = 68,
    #[doc = "69 - SERCOM5_OTHER"]
    SERCOM5_OTHER = 69,
    #[doc = "70 - SERCOM6_0"]
    SERCOM6_0 = 70,
    #[doc = "71 - SERCOM6_1"]
    SERCOM6_1 = 71,
    #[doc = "72 - SERCOM6_2"]
    SERCOM6_2 = 72,
    #[doc = "73 - SERCOM6_OTHER"]
    SERCOM6_OTHER = 73,
    #[doc = "74 - SERCOM7_0"]
    SERCOM7_0 = 74,
    #[doc = "75 - SERCOM7_1"]
    SERCOM7_1 = 75,
    #[doc = "76 - SERCOM7_2"]
    SERCOM7_2 = 76,
    #[doc = "77 - SERCOM7_OTHER"]
    SERCOM7_OTHER = 77,
    #[doc = "80 - USB_OTHER"]
    USB_OTHER = 80,
    #[doc = "81 - USB_SOF_HSOF"]
    USB_SOF_HSOF = 81,
    #[doc = "82 - USB_TRCPT0"]
    USB_TRCPT0 = 82,
    #[doc = "83 - USB_TRCPT1"]
    USB_TRCPT1 = 83,
    #[doc = "85 - TCC0_OTHER"]
    TCC0_OTHER = 85,
    #[doc = "86 - TCC0_MC0"]
    TCC0_MC0 = 86,
    #[doc = "87 - TCC0_MC1"]
    TCC0_MC1 = 87,
    #[doc = "88 - TCC0_MC2"]
    TCC0_MC2 = 88,
    #[doc = "89 - TCC0_MC3"]
    TCC0_MC3 = 89,
    #[doc = "90 - TCC0_MC4"]
    TCC0_MC4 = 90,
    #[doc = "91 - TCC0_MC5"]
    TCC0_MC5 = 91,
    #[doc = "92 - TCC1_OTHER"]
    TCC1_OTHER = 92,
    #[doc = "93 - TCC1_MC0"]
    TCC1_MC0 = 93,
    #[doc = "94 - TCC1_MC1"]
    TCC1_MC1 = 94,
    #[doc = "95 - TCC1_MC2"]
    TCC1_MC2 = 95,
    #[doc = "96 - TCC1_MC3"]
    TCC1_MC3 = 96,
    #[doc = "97 - TCC2_OTHER"]
    TCC2_OTHER = 97,
    #[doc = "98 - TCC2_MC0"]
    TCC2_MC0 = 98,
    #[doc = "99 - TCC2_MC1"]
    TCC2_MC1 = 99,
    #[doc = "100 - TCC2_MC2"]
    TCC2_MC2 = 100,
    #[doc = "101 - TCC3_OTHER"]
    TCC3_OTHER = 101,
    #[doc = "102 - TCC3_MC0"]
    TCC3_MC0 = 102,
    #[doc = "103 - TCC3_MC1"]
    TCC3_MC1 = 103,
    #[doc = "104 - TCC4_OTHER"]
    TCC4_OTHER = 104,
    #[doc = "105 - TCC4_MC0"]
    TCC4_MC0 = 105,
    #[doc = "106 - TCC4_MC1"]
    TCC4_MC1 = 106,
    #[doc = "107 - TC0"]
    TC0 = 107,
    #[doc = "108 - TC1"]
    TC1 = 108,
    #[doc = "109 - TC2"]
    TC2 = 109,
    #[doc = "110 - TC3"]
    TC3 = 110,
    #[doc = "111 - TC4"]
    TC4 = 111,
    #[doc = "112 - TC5"]
    TC5 = 112,
    #[doc = "113 - TC6"]
    TC6 = 113,
    #[doc = "114 - TC7"]
    TC7 = 114,
    #[doc = "115 - PDEC_OTHER"]
    PDEC_OTHER = 115,
    #[doc = "116 - PDEC_MC0"]
    PDEC_MC0 = 116,
    #[doc = "117 - PDEC_MC1"]
    PDEC_MC1 = 117,
    #[doc = "118 - ADC0_OTHER"]
    ADC0_OTHER = 118,
    #[doc = "119 - ADC0_RESRDY"]
    ADC0_RESRDY = 119,
    #[doc = "120 - ADC1_OTHER"]
    ADC1_OTHER = 120,
    #[doc = "121 - ADC1_RESRDY"]
    ADC1_RESRDY = 121,
    #[doc = "122 - AC"]
    AC = 122,
    #[doc = "123 - DAC_OTHER"]
    DAC_OTHER = 123,
    #[doc = "124 - DAC_EMPTY_0"]
    DAC_EMPTY_0 = 124,
    #[doc = "125 - DAC_EMPTY_1"]
    DAC_EMPTY_1 = 125,
    #[doc = "126 - DAC_RESRDY_0"]
    DAC_RESRDY_0 = 126,
    #[doc = "127 - DAC_RESRDY_1"]
    DAC_RESRDY_1 = 127,
    #[doc = "128 - I2S"]
    I2S = 128,
    #[doc = "129 - PCC"]
    PCC = 129,
    #[doc = "130 - AES"]
    AES = 130,
    #[doc = "131 - TRNG"]
    TRNG = 131,
    #[doc = "132 - ICM"]
    ICM = 132,
    #[doc = "134 - QSPI"]
    QSPI = 134,
    #[doc = "135 - SDHC0"]
    SDHC0 = 135,
    #[doc = "136 - SDHC1"]
    SDHC1 = 136,
}
unsafe impl cortex_m::interrupt::InterruptNumber for Interrupt {
    #[inline(always)]
    fn number(self) -> u16 {
        self as u16
    }
}
#[doc = "Analog Comparators"]
pub struct AC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for AC {}
impl AC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const ac::RegisterBlock = 0x4200_2000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const ac::RegisterBlock {
        Self::PTR
    }
}
impl Deref for AC {
    type Target = ac::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for AC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("AC").finish()
    }
}
#[doc = "Analog Comparators"]
pub mod ac;
#[doc = "Analog Digital Converter"]
pub struct ADC0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for ADC0 {}
impl ADC0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const adc0::RegisterBlock = 0x4300_1c00 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const adc0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for ADC0 {
    type Target = adc0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for ADC0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("ADC0").finish()
    }
}
#[doc = "Analog Digital Converter"]
pub mod adc0;
#[doc = "Analog Digital Converter"]
pub struct ADC1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for ADC1 {}
impl ADC1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const adc0::RegisterBlock = 0x4300_2000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const adc0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for ADC1 {
    type Target = adc0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for ADC1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("ADC1").finish()
    }
}
#[doc = "Analog Digital Converter"]
pub use adc0 as adc1;
#[doc = "Advanced Encryption Standard"]
pub struct AES {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for AES {}
impl AES {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const aes::RegisterBlock = 0x4200_2400 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const aes::RegisterBlock {
        Self::PTR
    }
}
impl Deref for AES {
    type Target = aes::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for AES {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("AES").finish()
    }
}
#[doc = "Advanced Encryption Standard"]
pub mod aes;
#[doc = "Configurable Custom Logic"]
pub struct CCL {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CCL {}
impl CCL {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const ccl::RegisterBlock = 0x4200_3800 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const ccl::RegisterBlock {
        Self::PTR
    }
}
impl Deref for CCL {
    type Target = ccl::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for CCL {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("CCL").finish()
    }
}
#[doc = "Configurable Custom Logic"]
pub mod ccl;
#[doc = "Cortex M Cache Controller"]
pub struct CMCC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CMCC {}
impl CMCC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const cmcc::RegisterBlock = 0x4100_6000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const cmcc::RegisterBlock {
        Self::PTR
    }
}
impl Deref for CMCC {
    type Target = cmcc::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for CMCC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("CMCC").finish()
    }
}
#[doc = "Cortex M Cache Controller"]
pub mod cmcc;
#[doc = "Digital-to-Analog Converter"]
pub struct DAC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for DAC {}
impl DAC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const dac::RegisterBlock = 0x4300_2400 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const dac::RegisterBlock {
        Self::PTR
    }
}
impl Deref for DAC {
    type Target = dac::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for DAC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("DAC").finish()
    }
}
#[doc = "Digital-to-Analog Converter"]
pub mod dac;
#[doc = "Direct Memory Access Controller"]
pub struct DMAC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for DMAC {}
impl DMAC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const dmac::RegisterBlock = 0x4100_a000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const dmac::RegisterBlock {
        Self::PTR
    }
}
impl Deref for DMAC {
    type Target = dmac::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for DMAC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("DMAC").finish()
    }
}
#[doc = "Direct Memory Access Controller"]
pub mod dmac;
#[doc = "Device Service Unit"]
pub struct DSU {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for DSU {}
impl DSU {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const dsu::RegisterBlock = 0x4100_2000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const dsu::RegisterBlock {
        Self::PTR
    }
}
impl Deref for DSU {
    type Target = dsu::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for DSU {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("DSU").finish()
    }
}
#[doc = "Device Service Unit"]
pub mod dsu;
#[doc = "External Interrupt Controller"]
pub struct EIC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for EIC {}
impl EIC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const eic::RegisterBlock = 0x4000_2800 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const eic::RegisterBlock {
        Self::PTR
    }
}
impl Deref for EIC {
    type Target = eic::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for EIC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("EIC").finish()
    }
}
#[doc = "External Interrupt Controller"]
pub mod eic;
#[doc = "Event System Interface"]
pub struct EVSYS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for EVSYS {}
impl EVSYS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const evsys::RegisterBlock = 0x4100_e000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const evsys::RegisterBlock {
        Self::PTR
    }
}
impl Deref for EVSYS {
    type Target = evsys::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for EVSYS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("EVSYS").finish()
    }
}
#[doc = "Event System Interface"]
pub mod evsys;
#[doc = "Frequency Meter"]
pub struct FREQM {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for FREQM {}
impl FREQM {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const freqm::RegisterBlock = 0x4000_2c00 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const freqm::RegisterBlock {
        Self::PTR
    }
}
impl Deref for FREQM {
    type Target = freqm::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for FREQM {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("FREQM").finish()
    }
}
#[doc = "Frequency Meter"]
pub mod freqm;
#[doc = "Generic Clock Generator"]
pub struct GCLK {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for GCLK {}
impl GCLK {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const gclk::RegisterBlock = 0x4000_1c00 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const gclk::RegisterBlock {
        Self::PTR
    }
}
impl Deref for GCLK {
    type Target = gclk::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for GCLK {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("GCLK").finish()
    }
}
#[doc = "Generic Clock Generator"]
pub mod gclk;
#[doc = "HSB Matrix"]
pub struct HMATRIX {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for HMATRIX {}
impl HMATRIX {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const hmatrix::RegisterBlock = 0x4100_c000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const hmatrix::RegisterBlock {
        Self::PTR
    }
}
impl Deref for HMATRIX {
    type Target = hmatrix::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for HMATRIX {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("HMATRIX").finish()
    }
}
#[doc = "HSB Matrix"]
pub mod hmatrix;
#[doc = "Integrity Check Monitor"]
pub struct ICM {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for ICM {}
impl ICM {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const icm::RegisterBlock = 0x4200_2c00 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const icm::RegisterBlock {
        Self::PTR
    }
}
impl Deref for ICM {
    type Target = icm::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for ICM {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("ICM").finish()
    }
}
#[doc = "Integrity Check Monitor"]
pub mod icm;
#[doc = "Inter-IC Sound Interface"]
pub struct I2S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for I2S {}
impl I2S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const i2s::RegisterBlock = 0x4300_2800 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const i2s::RegisterBlock {
        Self::PTR
    }
}
impl Deref for I2S {
    type Target = i2s::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for I2S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("I2S").finish()
    }
}
#[doc = "Inter-IC Sound Interface"]
pub mod i2s;
#[doc = "Main Clock"]
pub struct MCLK {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for MCLK {}
impl MCLK {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const mclk::RegisterBlock = 0x4000_0800 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const mclk::RegisterBlock {
        Self::PTR
    }
}
impl Deref for MCLK {
    type Target = mclk::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for MCLK {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("MCLK").finish()
    }
}
#[doc = "Main Clock"]
pub mod mclk;
#[doc = "Non-Volatile Memory Controller"]
pub struct NVMCTRL {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for NVMCTRL {}
impl NVMCTRL {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const nvmctrl::RegisterBlock = 0x4100_4000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const nvmctrl::RegisterBlock {
        Self::PTR
    }
}
impl Deref for NVMCTRL {
    type Target = nvmctrl::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for NVMCTRL {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("NVMCTRL").finish()
    }
}
#[doc = "Non-Volatile Memory Controller"]
pub mod nvmctrl;
#[doc = "Oscillators Control"]
pub struct OSCCTRL {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for OSCCTRL {}
impl OSCCTRL {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const oscctrl::RegisterBlock = 0x4000_1000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const oscctrl::RegisterBlock {
        Self::PTR
    }
}
impl Deref for OSCCTRL {
    type Target = oscctrl::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for OSCCTRL {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("OSCCTRL").finish()
    }
}
#[doc = "Oscillators Control"]
pub mod oscctrl;
#[doc = "32kHz Oscillators Control"]
pub struct OSC32KCTRL {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for OSC32KCTRL {}
impl OSC32KCTRL {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const osc32kctrl::RegisterBlock = 0x4000_1400 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const osc32kctrl::RegisterBlock {
        Self::PTR
    }
}
impl Deref for OSC32KCTRL {
    type Target = osc32kctrl::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for OSC32KCTRL {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("OSC32KCTRL").finish()
    }
}
#[doc = "32kHz Oscillators Control"]
pub mod osc32kctrl;
#[doc = "Peripheral Access Controller"]
pub struct PAC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PAC {}
impl PAC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pac::RegisterBlock = 0x4000_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pac::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PAC {
    type Target = pac::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PAC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PAC").finish()
    }
}
#[doc = "Peripheral Access Controller"]
pub mod pac;
#[doc = "Parallel Capture Controller"]
pub struct PCC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PCC {}
impl PCC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pcc::RegisterBlock = 0x4300_2c00 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pcc::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PCC {
    type Target = pcc::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PCC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PCC").finish()
    }
}
#[doc = "Parallel Capture Controller"]
pub mod pcc;
#[doc = "Quadrature Decodeur"]
pub struct PDEC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PDEC {}
impl PDEC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pdec::RegisterBlock = 0x4200_1c00 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pdec::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PDEC {
    type Target = pdec::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PDEC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PDEC").finish()
    }
}
#[doc = "Quadrature Decodeur"]
pub mod pdec;
#[doc = "Power Manager"]
pub struct PM {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PM {}
impl PM {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pm::RegisterBlock = 0x4000_0400 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pm::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PM {
    type Target = pm::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PM {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PM").finish()
    }
}
#[doc = "Power Manager"]
pub mod pm;
#[doc = "Port Module"]
pub struct PORT {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PORT {}
impl PORT {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const port::RegisterBlock = 0x4100_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const port::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PORT {
    type Target = port::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PORT {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PORT").finish()
    }
}
#[doc = "Port Module"]
pub mod port;
#[doc = "Quad SPI interface"]
pub struct QSPI {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for QSPI {}
impl QSPI {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const qspi::RegisterBlock = 0x4200_3400 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const qspi::RegisterBlock {
        Self::PTR
    }
}
impl Deref for QSPI {
    type Target = qspi::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for QSPI {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("QSPI").finish()
    }
}
#[doc = "Quad SPI interface"]
pub mod qspi;
#[doc = "RAM ECC"]
pub struct RAMECC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for RAMECC {}
impl RAMECC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const ramecc::RegisterBlock = 0x4102_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const ramecc::RegisterBlock {
        Self::PTR
    }
}
impl Deref for RAMECC {
    type Target = ramecc::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for RAMECC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("RAMECC").finish()
    }
}
#[doc = "RAM ECC"]
pub mod ramecc;
#[doc = "Reset Controller"]
pub struct RSTC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for RSTC {}
impl RSTC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const rstc::RegisterBlock = 0x4000_0c00 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const rstc::RegisterBlock {
        Self::PTR
    }
}
impl Deref for RSTC {
    type Target = rstc::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for RSTC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("RSTC").finish()
    }
}
#[doc = "Reset Controller"]
pub mod rstc;
#[doc = "Real-Time Counter"]
pub struct RTC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for RTC {}
impl RTC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const rtc::RegisterBlock = 0x4000_2400 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const rtc::RegisterBlock {
        Self::PTR
    }
}
impl Deref for RTC {
    type Target = rtc::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for RTC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("RTC").finish()
    }
}
#[doc = "Real-Time Counter"]
pub mod rtc;
#[doc = "SD/MMC Host Controller"]
pub struct SDHC0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SDHC0 {}
impl SDHC0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const sdhc0::RegisterBlock = 0x4500_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const sdhc0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SDHC0 {
    type Target = sdhc0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SDHC0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SDHC0").finish()
    }
}
#[doc = "SD/MMC Host Controller"]
pub mod sdhc0;
#[doc = "SD/MMC Host Controller"]
pub struct SDHC1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SDHC1 {}
impl SDHC1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const sdhc0::RegisterBlock = 0x4600_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const sdhc0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SDHC1 {
    type Target = sdhc0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SDHC1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SDHC1").finish()
    }
}
#[doc = "SD/MMC Host Controller"]
pub use sdhc0 as sdhc1;
#[doc = "Serial Communication Interface"]
pub struct SERCOM0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SERCOM0 {}
impl SERCOM0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const sercom0::RegisterBlock = 0x4000_3000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const sercom0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SERCOM0 {
    type Target = sercom0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SERCOM0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SERCOM0").finish()
    }
}
#[doc = "Serial Communication Interface"]
pub mod sercom0;
#[doc = "Serial Communication Interface"]
pub struct SERCOM1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SERCOM1 {}
impl SERCOM1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const sercom0::RegisterBlock = 0x4000_3400 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const sercom0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SERCOM1 {
    type Target = sercom0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SERCOM1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SERCOM1").finish()
    }
}
#[doc = "Serial Communication Interface"]
pub use sercom0 as sercom1;
#[doc = "Serial Communication Interface"]
pub struct SERCOM2 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SERCOM2 {}
impl SERCOM2 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const sercom0::RegisterBlock = 0x4101_2000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const sercom0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SERCOM2 {
    type Target = sercom0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SERCOM2 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SERCOM2").finish()
    }
}
#[doc = "Serial Communication Interface"]
pub use sercom0 as sercom2;
#[doc = "Serial Communication Interface"]
pub struct SERCOM3 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SERCOM3 {}
impl SERCOM3 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const sercom0::RegisterBlock = 0x4101_4000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const sercom0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SERCOM3 {
    type Target = sercom0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SERCOM3 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SERCOM3").finish()
    }
}
#[doc = "Serial Communication Interface"]
pub use sercom0 as sercom3;
#[doc = "Serial Communication Interface"]
pub struct SERCOM4 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SERCOM4 {}
impl SERCOM4 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const sercom0::RegisterBlock = 0x4300_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const sercom0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SERCOM4 {
    type Target = sercom0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SERCOM4 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SERCOM4").finish()
    }
}
#[doc = "Serial Communication Interface"]
pub use sercom0 as sercom4;
#[doc = "Serial Communication Interface"]
pub struct SERCOM5 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SERCOM5 {}
impl SERCOM5 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const sercom0::RegisterBlock = 0x4300_0400 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const sercom0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SERCOM5 {
    type Target = sercom0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SERCOM5 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SERCOM5").finish()
    }
}
#[doc = "Serial Communication Interface"]
pub use sercom0 as sercom5;
#[doc = "Serial Communication Interface"]
pub struct SERCOM6 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SERCOM6 {}
impl SERCOM6 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const sercom0::RegisterBlock = 0x4300_0800 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const sercom0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SERCOM6 {
    type Target = sercom0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SERCOM6 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SERCOM6").finish()
    }
}
#[doc = "Serial Communication Interface"]
pub use sercom0 as sercom6;
#[doc = "Serial Communication Interface"]
pub struct SERCOM7 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SERCOM7 {}
impl SERCOM7 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const sercom0::RegisterBlock = 0x4300_0c00 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const sercom0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SERCOM7 {
    type Target = sercom0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SERCOM7 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SERCOM7").finish()
    }
}
#[doc = "Serial Communication Interface"]
pub use sercom0 as sercom7;
#[doc = "Supply Controller"]
pub struct SUPC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SUPC {}
impl SUPC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const supc::RegisterBlock = 0x4000_1800 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const supc::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SUPC {
    type Target = supc::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SUPC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SUPC").finish()
    }
}
#[doc = "Supply Controller"]
pub mod supc;
#[doc = "Basic Timer Counter"]
pub struct TC0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TC0 {}
impl TC0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tc0::RegisterBlock = 0x4000_3800 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tc0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TC0 {
    type Target = tc0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TC0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TC0").finish()
    }
}
#[doc = "Basic Timer Counter"]
pub mod tc0;
#[doc = "Basic Timer Counter"]
pub struct TC1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TC1 {}
impl TC1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tc0::RegisterBlock = 0x4000_3c00 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tc0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TC1 {
    type Target = tc0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TC1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TC1").finish()
    }
}
#[doc = "Basic Timer Counter"]
pub use tc0 as tc1;
#[doc = "Basic Timer Counter"]
pub struct TC2 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TC2 {}
impl TC2 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tc0::RegisterBlock = 0x4101_a000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tc0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TC2 {
    type Target = tc0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TC2 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TC2").finish()
    }
}
#[doc = "Basic Timer Counter"]
pub use tc0 as tc2;
#[doc = "Basic Timer Counter"]
pub struct TC3 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TC3 {}
impl TC3 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tc0::RegisterBlock = 0x4101_c000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tc0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TC3 {
    type Target = tc0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TC3 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TC3").finish()
    }
}
#[doc = "Basic Timer Counter"]
pub use tc0 as tc3;
#[doc = "Basic Timer Counter"]
pub struct TC4 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TC4 {}
impl TC4 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tc0::RegisterBlock = 0x4200_1400 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tc0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TC4 {
    type Target = tc0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TC4 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TC4").finish()
    }
}
#[doc = "Basic Timer Counter"]
pub use tc0 as tc4;
#[doc = "Basic Timer Counter"]
pub struct TC5 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TC5 {}
impl TC5 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tc0::RegisterBlock = 0x4200_1800 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tc0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TC5 {
    type Target = tc0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TC5 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TC5").finish()
    }
}
#[doc = "Basic Timer Counter"]
pub use tc0 as tc5;
#[doc = "Basic Timer Counter"]
pub struct TC6 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TC6 {}
impl TC6 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tc0::RegisterBlock = 0x4300_1400 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tc0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TC6 {
    type Target = tc0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TC6 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TC6").finish()
    }
}
#[doc = "Basic Timer Counter"]
pub use tc0 as tc6;
#[doc = "Basic Timer Counter"]
pub struct TC7 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TC7 {}
impl TC7 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tc0::RegisterBlock = 0x4300_1800 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tc0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TC7 {
    type Target = tc0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TC7 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TC7").finish()
    }
}
#[doc = "Basic Timer Counter"]
pub use tc0 as tc7;
#[doc = "Timer Counter Control"]
pub struct TCC0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TCC0 {}
impl TCC0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tcc0::RegisterBlock = 0x4101_6000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tcc0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TCC0 {
    type Target = tcc0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TCC0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TCC0").finish()
    }
}
#[doc = "Timer Counter Control"]
pub mod tcc0;
#[doc = "Timer Counter Control"]
pub struct TCC1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TCC1 {}
impl TCC1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tcc0::RegisterBlock = 0x4101_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tcc0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TCC1 {
    type Target = tcc0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TCC1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TCC1").finish()
    }
}
#[doc = "Timer Counter Control"]
pub use tcc0 as tcc1;
#[doc = "Timer Counter Control"]
pub struct TCC2 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TCC2 {}
impl TCC2 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tcc0::RegisterBlock = 0x4200_0c00 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tcc0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TCC2 {
    type Target = tcc0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TCC2 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TCC2").finish()
    }
}
#[doc = "Timer Counter Control"]
pub use tcc0 as tcc2;
#[doc = "Timer Counter Control"]
pub struct TCC3 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TCC3 {}
impl TCC3 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tcc0::RegisterBlock = 0x4200_1000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tcc0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TCC3 {
    type Target = tcc0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TCC3 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TCC3").finish()
    }
}
#[doc = "Timer Counter Control"]
pub use tcc0 as tcc3;
#[doc = "Timer Counter Control"]
pub struct TCC4 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TCC4 {}
impl TCC4 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tcc0::RegisterBlock = 0x4300_1000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tcc0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TCC4 {
    type Target = tcc0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TCC4 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TCC4").finish()
    }
}
#[doc = "Timer Counter Control"]
pub use tcc0 as tcc4;
#[doc = "True Random Generator"]
pub struct TRNG {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TRNG {}
impl TRNG {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const trng::RegisterBlock = 0x4200_2800 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const trng::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TRNG {
    type Target = trng::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TRNG {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TRNG").finish()
    }
}
#[doc = "True Random Generator"]
pub mod trng;
#[doc = "Universal Serial Bus"]
pub struct USB {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for USB {}
impl USB {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const usb::RegisterBlock = 0x4100_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const usb::RegisterBlock {
        Self::PTR
    }
}
impl Deref for USB {
    type Target = usb::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for USB {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("USB").finish()
    }
}
#[doc = "Universal Serial Bus"]
pub mod usb;
#[doc = "Watchdog Timer"]
pub struct WDT {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for WDT {}
impl WDT {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const wdt::RegisterBlock = 0x4000_2000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const wdt::RegisterBlock {
        Self::PTR
    }
}
impl Deref for WDT {
    type Target = wdt::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for WDT {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("WDT").finish()
    }
}
#[doc = "Watchdog Timer"]
pub mod wdt;
#[doc = "Core Debug Register"]
pub struct COREDEBUG {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for COREDEBUG {}
impl COREDEBUG {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const core_debug::RegisterBlock = 0xe000_edf0 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const core_debug::RegisterBlock {
        Self::PTR
    }
}
impl Deref for COREDEBUG {
    type Target = core_debug::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for COREDEBUG {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("COREDEBUG").finish()
    }
}
#[doc = "Core Debug Register"]
pub mod core_debug;
#[doc = "Embedded Trace Macrocell"]
pub struct ETM {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for ETM {}
impl ETM {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const etm::RegisterBlock = 0xe004_1000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const etm::RegisterBlock {
        Self::PTR
    }
}
impl Deref for ETM {
    type Target = etm::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for ETM {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("ETM").finish()
    }
}
#[doc = "Embedded Trace Macrocell"]
pub mod etm;
#[doc = "System timer"]
pub struct SYSTICK {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SYSTICK {}
impl SYSTICK {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const sys_tick::RegisterBlock = 0xe000_e010 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const sys_tick::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SYSTICK {
    type Target = sys_tick::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SYSTICK {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SYSTICK").finish()
    }
}
#[doc = "System timer"]
pub mod sys_tick;
#[doc = "System Control Registers"]
pub struct SYSTEMCONTROL {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SYSTEMCONTROL {}
impl SYSTEMCONTROL {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const system_control::RegisterBlock = 0xe000_e000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const system_control::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SYSTEMCONTROL {
    type Target = system_control::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SYSTEMCONTROL {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SYSTEMCONTROL").finish()
    }
}
#[doc = "System Control Registers"]
pub mod system_control;
#[doc = "Trace Port Interface Register"]
pub struct TPI {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TPI {}
impl TPI {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tpi::RegisterBlock = 0xe004_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tpi::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TPI {
    type Target = tpi::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TPI {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TPI").finish()
    }
}
#[doc = "Trace Port Interface Register"]
pub mod tpi;
#[no_mangle]
static mut DEVICE_PERIPHERALS: bool = false;
#[doc = r"All the peripherals"]
#[allow(non_snake_case)]
pub struct Peripherals {
    #[doc = "AC"]
    pub AC: AC,
    #[doc = "ADC0"]
    pub ADC0: ADC0,
    #[doc = "ADC1"]
    pub ADC1: ADC1,
    #[doc = "AES"]
    pub AES: AES,
    #[doc = "CCL"]
    pub CCL: CCL,
    #[doc = "CMCC"]
    pub CMCC: CMCC,
    #[doc = "DAC"]
    pub DAC: DAC,
    #[doc = "DMAC"]
    pub DMAC: DMAC,
    #[doc = "DSU"]
    pub DSU: DSU,
    #[doc = "EIC"]
    pub EIC: EIC,
    #[doc = "EVSYS"]
    pub EVSYS: EVSYS,
    #[doc = "FREQM"]
    pub FREQM: FREQM,
    #[doc = "GCLK"]
    pub GCLK: GCLK,
    #[doc = "HMATRIX"]
    pub HMATRIX: HMATRIX,
    #[doc = "ICM"]
    pub ICM: ICM,
    #[doc = "I2S"]
    pub I2S: I2S,
    #[doc = "MCLK"]
    pub MCLK: MCLK,
    #[doc = "NVMCTRL"]
    pub NVMCTRL: NVMCTRL,
    #[doc = "OSCCTRL"]
    pub OSCCTRL: OSCCTRL,
    #[doc = "OSC32KCTRL"]
    pub OSC32KCTRL: OSC32KCTRL,
    #[doc = "PAC"]
    pub PAC: PAC,
    #[doc = "PCC"]
    pub PCC: PCC,
    #[doc = "PDEC"]
    pub PDEC: PDEC,
    #[doc = "PM"]
    pub PM: PM,
    #[doc = "PORT"]
    pub PORT: PORT,
    #[doc = "QSPI"]
    pub QSPI: QSPI,
    #[doc = "RAMECC"]
    pub RAMECC: RAMECC,
    #[doc = "RSTC"]
    pub RSTC: RSTC,
    #[doc = "RTC"]
    pub RTC: RTC,
    #[doc = "SDHC0"]
    pub SDHC0: SDHC0,
    #[doc = "SDHC1"]
    pub SDHC1: SDHC1,
    #[doc = "SERCOM0"]
    pub SERCOM0: SERCOM0,
    #[doc = "SERCOM1"]
    pub SERCOM1: SERCOM1,
    #[doc = "SERCOM2"]
    pub SERCOM2: SERCOM2,
    #[doc = "SERCOM3"]
    pub SERCOM3: SERCOM3,
    #[doc = "SERCOM4"]
    pub SERCOM4: SERCOM4,
    #[doc = "SERCOM5"]
    pub SERCOM5: SERCOM5,
    #[doc = "SERCOM6"]
    pub SERCOM6: SERCOM6,
    #[doc = "SERCOM7"]
    pub SERCOM7: SERCOM7,
    #[doc = "SUPC"]
    pub SUPC: SUPC,
    #[doc = "TC0"]
    pub TC0: TC0,
    #[doc = "TC1"]
    pub TC1: TC1,
    #[doc = "TC2"]
    pub TC2: TC2,
    #[doc = "TC3"]
    pub TC3: TC3,
    #[doc = "TC4"]
    pub TC4: TC4,
    #[doc = "TC5"]
    pub TC5: TC5,
    #[doc = "TC6"]
    pub TC6: TC6,
    #[doc = "TC7"]
    pub TC7: TC7,
    #[doc = "TCC0"]
    pub TCC0: TCC0,
    #[doc = "TCC1"]
    pub TCC1: TCC1,
    #[doc = "TCC2"]
    pub TCC2: TCC2,
    #[doc = "TCC3"]
    pub TCC3: TCC3,
    #[doc = "TCC4"]
    pub TCC4: TCC4,
    #[doc = "TRNG"]
    pub TRNG: TRNG,
    #[doc = "USB"]
    pub USB: USB,
    #[doc = "WDT"]
    pub WDT: WDT,
    #[doc = "COREDEBUG"]
    pub COREDEBUG: COREDEBUG,
    #[doc = "ETM"]
    pub ETM: ETM,
    #[doc = "SYSTICK"]
    pub SYSTICK: SYSTICK,
    #[doc = "SYSTEMCONTROL"]
    pub SYSTEMCONTROL: SYSTEMCONTROL,
    #[doc = "TPI"]
    pub TPI: TPI,
}
impl Peripherals {
    #[doc = r"Returns all the peripherals *once*"]
    #[inline]
    pub fn take() -> Option<Self> {
        cortex_m::interrupt::free(|_| {
            if unsafe { DEVICE_PERIPHERALS } {
                None
            } else {
                Some(unsafe { Peripherals::steal() })
            }
        })
    }
    #[doc = r"Unchecked version of `Peripherals::take`"]
    #[inline]
    pub unsafe fn steal() -> Self {
        DEVICE_PERIPHERALS = true;
        Peripherals {
            AC: AC {
                _marker: PhantomData,
            },
            ADC0: ADC0 {
                _marker: PhantomData,
            },
            ADC1: ADC1 {
                _marker: PhantomData,
            },
            AES: AES {
                _marker: PhantomData,
            },
            CCL: CCL {
                _marker: PhantomData,
            },
            CMCC: CMCC {
                _marker: PhantomData,
            },
            DAC: DAC {
                _marker: PhantomData,
            },
            DMAC: DMAC {
                _marker: PhantomData,
            },
            DSU: DSU {
                _marker: PhantomData,
            },
            EIC: EIC {
                _marker: PhantomData,
            },
            EVSYS: EVSYS {
                _marker: PhantomData,
            },
            FREQM: FREQM {
                _marker: PhantomData,
            },
            GCLK: GCLK {
                _marker: PhantomData,
            },
            HMATRIX: HMATRIX {
                _marker: PhantomData,
            },
            ICM: ICM {
                _marker: PhantomData,
            },
            I2S: I2S {
                _marker: PhantomData,
            },
            MCLK: MCLK {
                _marker: PhantomData,
            },
            NVMCTRL: NVMCTRL {
                _marker: PhantomData,
            },
            OSCCTRL: OSCCTRL {
                _marker: PhantomData,
            },
            OSC32KCTRL: OSC32KCTRL {
                _marker: PhantomData,
            },
            PAC: PAC {
                _marker: PhantomData,
            },
            PCC: PCC {
                _marker: PhantomData,
            },
            PDEC: PDEC {
                _marker: PhantomData,
            },
            PM: PM {
                _marker: PhantomData,
            },
            PORT: PORT {
                _marker: PhantomData,
            },
            QSPI: QSPI {
                _marker: PhantomData,
            },
            RAMECC: RAMECC {
                _marker: PhantomData,
            },
            RSTC: RSTC {
                _marker: PhantomData,
            },
            RTC: RTC {
                _marker: PhantomData,
            },
            SDHC0: SDHC0 {
                _marker: PhantomData,
            },
            SDHC1: SDHC1 {
                _marker: PhantomData,
            },
            SERCOM0: SERCOM0 {
                _marker: PhantomData,
            },
            SERCOM1: SERCOM1 {
                _marker: PhantomData,
            },
            SERCOM2: SERCOM2 {
                _marker: PhantomData,
            },
            SERCOM3: SERCOM3 {
                _marker: PhantomData,
            },
            SERCOM4: SERCOM4 {
                _marker: PhantomData,
            },
            SERCOM5: SERCOM5 {
                _marker: PhantomData,
            },
            SERCOM6: SERCOM6 {
                _marker: PhantomData,
            },
            SERCOM7: SERCOM7 {
                _marker: PhantomData,
            },
            SUPC: SUPC {
                _marker: PhantomData,
            },
            TC0: TC0 {
                _marker: PhantomData,
            },
            TC1: TC1 {
                _marker: PhantomData,
            },
            TC2: TC2 {
                _marker: PhantomData,
            },
            TC3: TC3 {
                _marker: PhantomData,
            },
            TC4: TC4 {
                _marker: PhantomData,
            },
            TC5: TC5 {
                _marker: PhantomData,
            },
            TC6: TC6 {
                _marker: PhantomData,
            },
            TC7: TC7 {
                _marker: PhantomData,
            },
            TCC0: TCC0 {
                _marker: PhantomData,
            },
            TCC1: TCC1 {
                _marker: PhantomData,
            },
            TCC2: TCC2 {
                _marker: PhantomData,
            },
            TCC3: TCC3 {
                _marker: PhantomData,
            },
            TCC4: TCC4 {
                _marker: PhantomData,
            },
            TRNG: TRNG {
                _marker: PhantomData,
            },
            USB: USB {
                _marker: PhantomData,
            },
            WDT: WDT {
                _marker: PhantomData,
            },
            COREDEBUG: COREDEBUG {
                _marker: PhantomData,
            },
            ETM: ETM {
                _marker: PhantomData,
            },
            SYSTICK: SYSTICK {
                _marker: PhantomData,
            },
            SYSTEMCONTROL: SYSTEMCONTROL {
                _marker: PhantomData,
            },
            TPI: TPI {
                _marker: PhantomData,
            },
        }
    }
}
