# AtomPtr

A safe, strongly typed (generic) atomic pointer abstraction to build
datastructures, and lock-free algorithms on top of.  Only uses
`libstd`.

The standard library contains an `AtomicPtr` type, which by itself
isn't very ergonomic to use, because it deals with raw pointers.  This
library assumes that types can always be heap allocated, wrapping them
in a `Box<T>`, and provides a nicer (and safe!) abstraction for
`std::sync::atomic::AtomicPtr`.  Using this crate is fairely
self-explanatory:

```rust
use atomptr::AtomPtr;

struct MyData { name: String }
let data = MyData { name: "Kookie".into() };

let a = AtomPtr::new(data);
println!("Name is: {}", a.get_ref().name);

let old_ref = a.swap(MyData { name: "Bob".into() });
println!("Name now is: {}, was {}", a.get_ref().name, old_ref.name);
```

Note that the type that is returned by `get_ref` and `swap` is
`Ref<T>`, which means that the old data is not de-allocated after a
swap, before this last reference goes out of scope.  You can of course
always manually call `drop()` on it.


## License

This micro-library is free software, and licensed under the GNU
General Public License, version 3.0 or (at your choice), any later
version.

**Additional Permissions:** For Submission to the Apple App Store:
Provided that you are otherwise in compliance with the GPLv3 for each
covered work you convey (including without limitation making the
Corresponding Source available in compliance with Section 6 of the
GPLv3), the qaul.net developers also grant you the additional
permission to convey through the Apple App Store non-source executable
versions of the Program as incorporated into each applicable covered
work as Executable Versions only under the Mozilla Public License
version 2.0.

A copy of both the GPL-3.0 and MPL-2.0 license texts are included in
this repository.

