use actix_web::{HttpRequest, HttpResponse, error};

pub fn json_error_handler(err: error::JsonPayloadError, _req: &HttpRequest) -> error::Error {
  use actix_web::error::JsonPayloadError;

  let detail = err.to_string();
  let resp = match &err {
      JsonPayloadError::ContentType => {
          HttpResponse::UnsupportedMediaType().body(detail)
      }
      JsonPayloadError::Deserialize(json_err) if json_err.is_data() => {
          HttpResponse::UnprocessableEntity().body(detail)
      }
      _ => HttpResponse::BadRequest().body(detail),
  };
  error::InternalError::from_response(err, resp).into()
}
