mod verify;
extern crate clap;
use clap::{Arg, App};

fn main() {
    let app = App::new("Atlas Entity Verifier")
        .version("0.1.2")
        .about("Verify referential integrity of Apache Atlas Entities")
        .author("Junaid Rahim");

    let name_option = Arg::with_name("prefix")
        .long("prefix")
        .short("p")
        .takes_value(true)
        .help("JSON file prefix")
        .required(true);

    let app = app.arg(name_option);
    let matches = app.get_matches();

    let file_prefix = matches.value_of("prefix")
        .expect("File prefix can't be None");

    let ec = verify::EntityChecker::new(file_prefix);
    ec.run_checks();
}