use crate::states;

use super::MessageType;

/// This packet is sent to the AT4 unit to request all group data.
pub const GET_GROUP_STATUS_PACKET: [u8; 10] = [
    0x55,
    0x55,
    0x80,
    0xb0,
    0x01,
    MessageType::GROUP_STATUS_MESSAGE,
    0,
    0,
    0xf5,
    0x2f,
];

/// The state of a group.
#[derive(Debug, PartialEq, Clone, Copy)]
pub struct GroupStatus {
    pub power_state: states::GroupPowerState,
    /// Valid values are `0`-`15`.
    pub group_number: u8,
    pub control_method: states::GroupControlMethod,
    pub open_percentage: u8,
    pub battery_low: bool,
    pub turbo_support: bool,
    pub target_setpoint: u8,
    pub has_sensor: bool,
    pub current_temperature: Option<f64>,
    pub spill: bool,
}
