use crate::states;

use super::MessageType;

/// This packet is sent to the AT4 unit to request all AC unit data.
pub const GET_AC_STATUS_PACKET: [u8; 10] = [
    0x55,
    0x55,
    0x80,
    0xb0,
    0x01,
    MessageType::AC_STATUS_MESSAGE,
    0,
    0,
    0xf4,
    0xcf,
];

/// The state of an AC unit.
#[derive(Debug, PartialEq, Clone, Copy)]
pub struct ACStatus {
    pub power_state: Option<states::ACPowerState>,
    /// Valid values are `0`-`3`.
    pub number: u8,
    pub mode: Option<states::ACMode>,
    pub fan_speed: Option<states::ACFanSpeed>,
    pub spill: bool,
    pub has_timer: bool,
    pub target_setpoint: u8,
    pub temperature: Option<f64>,
    // TODO: Add further error information
    pub error_code: u16,
}
